// ThisBuild / scalaVersion     := "2.12.13"
ThisBuild / scalaVersion     := "2.11.12"
ThisBuild / version          := "0.1.0"
ThisBuild / organization     := "com.gmei.up"

val jsonVersion = "3.6.10"
val jsonNative = "org.json4s" %% "json4s-native" % jsonVersion
val jsonJackson = "org.json4s" %% "json4s-jackson" % jsonVersion

val elastic4sVersion = "7.1.0"
val esCore = "com.sksamuel.elastic4s" %% "elastic4s-core" % elastic4sVersion
val esJava = "com.sksamuel.elastic4s" %% "elastic4s-client-esjava" % elastic4sVersion

val flinkVersion = "1.11.0"
val flinkCore= "org.apache.flink" % "flink-core" % flinkVersion
val flinkScala = "org.apache.flink" %% "flink-scala" % flinkVersion
val flinkStreamingScala = "org.apache.flink" %% "flink-streaming-scala" % flinkVersion
val flinkJSON = "org.apache.flink" % "flink-json" % flinkVersion % Test
val flinkRuntime =  "org.apache.flink" %% "flink-runtime" % flinkVersion % Test
val flinkRuntimeWeb = "org.apache.flink" %% "flink-runtime-web" % flinkVersion % Test
val flinkClients = "org.apache.flink" %% "flink-clients" % flinkVersion
val flinkML = "org.apache.flink" % "flink-ml-api" % flinkVersion
val flinkKafka = "org.apache.flink" %% "flink-connector-kafka" % flinkVersion
val flinkHadoop = "org.apache.flink" %% "flink-hadoop-compatibility" % flinkVersion % Test

lazy val root = (project in file("."))
  .settings(
    name := "streamingUserPortrait",

    libraryDependencies += "ch.qos.logback" % "logback-classic" % "1.2.3",
    libraryDependencies += "com.typesafe.scala-logging" %% "scala-logging" % "3.9.2",

    libraryDependencies += "com.alibaba" % "fastjson" % "1.2.75",
    libraryDependencies += jsonNative,
    libraryDependencies += jsonJackson,

    libraryDependencies += esCore,
    libraryDependencies += esJava,

    libraryDependencies += "net.debasishg" %% "redisclient" % "3.30",

    libraryDependencies += "com.lihaoyi" %% "requests" % "0.1.9",

    libraryDependencies += flinkCore,
    libraryDependencies += flinkScala,
    libraryDependencies += flinkStreamingScala,
    libraryDependencies += flinkClients,
    libraryDependencies += flinkRuntime,
    libraryDependencies += flinkRuntimeWeb,
    // libraryDependencies += flinkJSON,
    libraryDependencies += flinkML,
    libraryDependencies += flinkKafka,
    libraryDependencies += flinkHadoop,
    libraryDependencies += "com.alibaba.alink" %% "alink_core_flink-1.11" % "1.3.1" % "provided"
  )

scalacOptions in ThisBuild ++= Seq(
  "-encoding", "UTF-8",
  "-deprecation",
  "-feature",
  "-unchecked"
)

mainClass in assembly := Some("Main")

assemblyMergeStrategy in assembly := {
  case PathList("META-INF", xs @ _*) => MergeStrategy.discard
  case x => MergeStrategy.first
}
