package com.gmei.up.utils

import scala.concurrent.Future
import scala.collection.JavaConverters._
import com.alibaba.fastjson.JSON
import com.redis.{ RedisClient, RedisClientPool }

object Redis {
  // TODO read from config file

  implicit val ec: scala.concurrent.ExecutionContext = scala.concurrent.ExecutionContext.global

  val pRc2 = new RedisClient("172.16.40.173", 6379, 0, Some("ReDis!GmTx*0aN9"), 5000)

  val pRc4 =
    new RedisClientPool("172.16.50.145", 6379, database = 0, secret = Some("XfkMCCdWDIU%ls$h"), timeout = 500)

  def getRead(deviceId: String, contentType: String): List[Long] = {
    val key = s"doris:user_portrait:tag3:read_v2:device_id:${deviceId}:content_type:${contentType}"
    val today = java.time.LocalDate.now.toString()
    val redisRes = pRc2.hget(key, today)
    redisRes.map(s => JSON.parseArray(s, classOf[Long]).asScala.toList).getOrElse(List.empty[Long])
  }

  def save(
      contentEitherFuture: Either[Throwable, Future[IndexedSeq[Content]]],
      deviceId: String,
      contentType: String,
      timeBegin: Long
  ): Unit = {
    val key = s"streaming:candidate:${contentType}:device_id:${deviceId}"

    contentEitherFuture match {
      case Left(e) => e.printStackTrace()
      case Right(contentFuture) =>
        pRc4.withClient { client =>
          contentFuture.foreach { seq =>
            val ids = seq.map(c => c.id)
            if (ids.size > 0) {
              client.del(key)
              ids.foreach { id =>
                // println(id)
                client.rpush(key, id)
              }
              client.expire(key, 60 * 60 * 24 * 15)
              if (deviceId == "64695DE0-B926-4188-9C62-D987DC20BEDF") {
                DingTalk.send(
                  Map(
                    "method" -> "Redis.save",
                    "deviceId" -> deviceId,
                    "contentType" -> contentType,
                    "streamTotalSeconds" -> s"${(System.currentTimeMillis - timeBegin)}ms"
                  )
                )
              }
            }
          }
        }
    }
  }
}
