package com.gmei.up.utils

import scala.concurrent.Future
import scala.collection.JavaConverters._
import com.alibaba.fastjson.JSON
import com.redis.{ RedisClient, RedisClientPool }
import org.json4s._
import org.json4s.jackson.Serialization
import org.json4s.jackson.Serialization.{ read, write }

object Redis {
  // TODO read from config file

  implicit val ec: scala.concurrent.ExecutionContext = scala.concurrent.ExecutionContext.global

  val pRc2 = new RedisClient("172.16.40.173", 6379, 0, Some("ReDis!GmTx*0aN9"), 5000)
  val pRc4 = new RedisClient("172.16.50.145", 6379, 0, Some("XfkMCCdWDIU%ls$h"), 5000)

  val pRc4Pool =
    new RedisClientPool("172.16.50.145", 6379, database = 0, secret = Some("XfkMCCdWDIU%ls$h"), timeout = 5000)

  def getRead(deviceId: String, contentType: String): List[Long] = {
    val key = s"doris:user_portrait:tag3:read_v2:device_id:${deviceId}:content_type:${contentType}"
    val today = java.time.LocalDate.now.toString()
    val redisRes = pRc2.hget(key, today)
    redisRes.map(s => JSON.parseArray(s, classOf[Long]).asScala.toList).getOrElse(List.empty[Long])
  }

  def save(
      contentEitherFuture: Either[Throwable, Future[IndexedSeq[Content]]],
      deviceId: String,
      contentType: String,
      timeBegin: Long
  ): Unit = {
    val key = s"streaming:candidate:${contentType}:device_id:${deviceId}"

    try {
      contentEitherFuture match {
        case Left(e) => e.printStackTrace()
        case Right(contentFuture) =>
          pRc4Pool.withClient { client =>
            contentFuture.foreach { seq =>
              val ids = seq.map(c => c.id)
              if (ids.size > 0) {
                client.del(key)
                ids.foreach { id =>
                  // println(id)
                  client.rpush(key, id)
                }
                client.expire(key, 60 * 60 * 24 * 15)
                val total = System.currentTimeMillis - timeBegin
                if (total > 1000 && total < 50000) {
                  DingTalk.send(
                    Map(
                      "method" -> "Redis.save",
                      "deviceId" -> deviceId,
                      "contentType" -> contentType,
                      "description" -> "从流开始处理到存入结果的总耗时",
                      "streamTotalSeconds" -> s"${total}ms"
                    )
                  )
                }
              }
            }
          }
      }
    } catch {
      case e: Throwable =>
        DingTalk.send(
          Map(
            "method" -> "Redis.save",
            "deviceId" -> deviceId,
            "contentType" -> contentType,
            "error" -> e.getStackTrace.mkString("\n")
          ),
          contentType = "exception"
        )
    }
  }

  def saveServiceDiary(
      contentEitherFuture: Either[Throwable, Future[IndexedSeq[Content]]],
      deviceId: String
  ): Unit =
    try {
      implicit val formats = Serialization.formats(NoTypeHints)

      val key = s"streaming:candidate:service_diary:device_id:${deviceId}"
      contentEitherFuture match {
        case Left(e) => e.printStackTrace()
        case Right(contentFuture) =>
          contentFuture.foreach { seq =>
            val idPairs = seq.map(c => (c.id, c.serviceId.getOrElse("-1")))
            val res = write(idPairs)
            if (idPairs.size > 0) {
              pRc4.del(key)
              pRc4.set(key, res)
            }
          }
      }
    } catch {
      case e: Throwable =>
        DingTalk.send(
          Map(
            "method" -> "Redis.saveServiceDiary",
            "deviceId" -> deviceId,
            "contentType" -> "service_diary",
            "error" -> e.getStackTrace.mkString("\n")
          ),
          contentType = "exception"
        )
    }
}
