// ThisBuild / scalaVersion     := "2.12.13"
ThisBuild / scalaVersion     := "2.11.12"
ThisBuild / version          := "0.1.0"
ThisBuild / organization     := "com.gmei.up"

val esVersion = "7.10.2"
val es = "org.elasticsearch" % "elasticsearch" % esVersion
val esCore= "org.elasticsearch" % "elasticsearch-core" % esVersion

val flinkVersion = "1.12.1"
val flinkCore= "org.apache.flink" % "flink-core" % flinkVersion
val flinkScala = "org.apache.flink" %% "flink-scala" % flinkVersion
val flinkStreamingScala = "org.apache.flink" %% "flink-streaming-scala" % flinkVersion
val flinkJSON = "org.apache.flink" % "flink-json" % flinkVersion % Test
val flinkRuntime =  "org.apache.flink" %% "flink-runtime" % flinkVersion % Test
val flinkRuntimeWeb = "org.apache.flink" %% "flink-runtime-web" % flinkVersion % Test
val flinkClients = "org.apache.flink" %% "flink-clients" % flinkVersion
val flinkML = "org.apache.flink" % "flink-ml-api" % flinkVersion
val flinkKafka = "org.apache.flink" %% "flink-connector-kafka" % flinkVersion
val flinkHadoop = "org.apache.flink" %% "flink-hadoop-compatibility" % flinkVersion % Test


lazy val root = (project in file("."))
  .settings(
    name := "streamingUserPortrait",

    // libraryDependencies += "com.alibaba" % "fastjson" % "1.2.75",
    libraryDependencies += es,
    libraryDependencies += esCore,

    libraryDependencies += flinkCore,
    libraryDependencies += flinkScala,
    libraryDependencies += flinkStreamingScala,
    libraryDependencies += flinkClients,
    libraryDependencies += flinkRuntime,
    libraryDependencies += flinkRuntimeWeb,
    // libraryDependencies += flinkJSON,
    libraryDependencies += flinkML,
    libraryDependencies += flinkKafka,
    libraryDependencies += flinkHadoop
  )

scalacOptions in ThisBuild ++= Seq(
  "-encoding", "UTF-8",
  "-deprecation",
  "-feature",
  "-unchecked"
)

mainClass in assembly := Some("Main")
assemblyJarName in assembly := s"tryFlink.jar"
