# coding=utf-8

from __future__ import absolute_import, unicode_literals

import six
from ..utils.enum import Enum, unique


@unique
class SIMULATE_EYELID_TYPE(int, Enum):
    KAI_SHAN = (1, u"开扇型双眼皮")
    PING_XING = (2, u"平行式双眼皮")
    XIN_YUE = (3, u"新月型双眼皮")
    OU_SHI = (4, u"欧式双眼皮")


@unique
class PLASTIC_TAG(int, Enum):
    SUODUANYANJU = (994, u"缩短眼距")
    QUANGUNEITUI = (986, u"颧骨内推")
    SUOXIAHEJIAO = (985, u"缩下颌角")
    RENZHONGSUODUAN = (983, u"人中缩短")
    SUOXIABA = (984, u"缩短下巴")
    XIAYANLIANXIAZHI = (992, u"下眼睑下至")
    SHANGYANLIANTISHENG = (991, u"上眼睑提升")
    SUOBIYI = (599, u"缩鼻翼")
    BIBUSUODUAN = (979, u"鼻部缩短")
    FENGCHUN = (538, u"丰唇")
    BOCHUN = (548, u"薄唇")
    DIANXIABA = (340, u"垫下巴")
    SHOULIAN = (584, u"瘦脸")
    ZUIJIAOSAHNGYANG = (978, u"嘴角上扬")
    QUHEIYANQUAN = (460, u"祛黑眼圈")
    CHUFALINGWEN = (356, u"除法令纹")
    BIBUJIACHANG = (1011, u"鼻部加长")


@unique
class PLASTIC_PARAMETER(int, Enum):
    SHOULIAN = (1, u"瘦脸")
    ZHAILIAN = (2, u"窄脸")
    XIAOLIAN = (3, u"小脸")
    DAYAN = (4, u"大眼")
    YANJIAODU = (5, u"眼角度")
    SHOUQUANGU = (6, u"瘦颧骨")
    SHOUXIAHEGU = (7, u"瘦下颌骨")
    SHOUBI = (8, u"瘦鼻")
    CHANGBI = (9, u"长鼻")
    XIABA = (10, u"下巴")
    ETOU = (11, u"额头")
    ZUIXING = (12, u"嘴型")
    WEIXIAO = (13, u"微笑")
    YANJU = (14, u"眼距")
    YANYIDONG = (15, u"眼移动")
    SUORENZHONG = (16, u"缩人中")
    HEIYANQUAN = (17, u"黑眼圈")
    FALINGWEN = (18, u"法令纹")


@unique
class PLASTIC_TAG_TYPE(int, Enum):
    SUODUANYANJU = (1, u"缩眼距")
    QUANGUNEITUI = (2, u"颧骨内推")
    SUOXIAHEJIAO = (3, u"缩下颌角")
    RENZHONGSUODUAN = (4, u"人中缩短")
    SUOXIABA = (5, u"缩短下巴")
    XIAYANLIANXIAZHI = (6, u"下眼睑下至")
    SHANGYANLIANTISHENG = (7, u"上眼睑提升")
    SUOBIYI = (8, u"缩鼻翼")
    BIBUSUODUAN = (9, u"鼻部缩短")
    FENGCHUN = (10, u"丰唇")
    BOCHUN = (11, u"薄唇")
    DIANXIABA = (12, u"垫下巴")
    SHOULIAN = (13, u"瘦脸")
    ZUIJIAOSAHNGYANG = (14, u"嘴角上扬")
    QUHEIYANQUAN = (15, u"祛黑眼圈")
    CHUFALINGWEN = (16, u"祛法令纹")
    BIBUJIACHANG = (17, u"鼻中隔延长")
    XIAHEYUANTISHENG = (18, u"下颌缘提升")
    MEIBAINENFU = (19, u"美白")
    KAIYANJIAO = (20, u"开眼角")
    DAYANJING = (21, u"大眼睛")
    KONGYOU = (22, u"控油")
    QUYANDAI = (23, u"祛眼袋")
    QUDOU = (24, u"祛痘")
    SHUANGYANPI = (25, u"双眼皮")
    CHUTAITOUWEN = (26, u"祛抬头纹")
    CHUYUWEIWEN = (27, u"除鱼尾纹")
    CHUMEIJIANWEN = (28, u"祛眉间纹")
    QUHEITOU = (29, u"祛黑头")
    SUOMAOKONG = (30, u"缩毛孔")
    QUBAN = (31, u"祛斑")
    QUZHI = (32, u"祛痣")
    FENGTAIYANXUE = (33, u"丰太阳穴")
    MCHUN = (34, u"M唇")
    XIUMEI = (35, u"修眉")
    SUOZHAIXIABA = (36, u"缩窄下巴")
    QUYANWEN = (37, u"祛眼纹")
    BUSHUI = (38, u"补水")


class KYC_FACE_SHAPE(Enum):
    WAWAFACE = (1, '娃娃脸')
    EDANGFACE = (2, '鹅蛋脸')
    FANGFACE = (3, '方脸')
    LIXINGFACE = (4, '梨形脸')
    GUAZIFACE = (5, '瓜子脸')
    ZHUANGSHIFACE = (6, '钻石脸')
    CHANGFACE = (7, '长脸')


class KYC_FACE_FEATURE(Enum):
    TAOHUAEYE = (1, '桃花眼')
    XIFENFEYE = (2, '细凤眼')
    XIAOGOUEYE = (3, '小狗眼')
    XIAOLUEYE = (4, '小鹿眼')
    XINGEYE = (5, '杏眼')
    KUANGBIYI = (6, '宽鼻翼')
    ZAIBIYI = (7, '窄鼻翼')
    ZHENGCHANGBIYI = (8, '正常鼻翼')
    BAOCHUN = (9, '薄唇')
    HOUCHUN = (10, '厚唇')
    TAIDUCHUN = (11, '态度唇')
    WEIXIAOCHUN = (12, '微笑唇')
    CHUMEI = (13, '粗眉')
    LIUYEMEI = (14, '柳叶眉')
    TIAOMEI = (15, '挑眉')
    YESHENGMEI = (16, '野生眉')
    YIZIMEI = (17, '一字眉')


class KYC_FACE_STYLE(Enum):
    CHULIANFACE = (1, '初恋脸')
    YOUCHIFACE = (2, '幼齿脸')
    RIXIFACE = (3, '日系脸')
    HANGXIFACE = (4, '韩系脸')
    WUMEIFACE = (5, '妩媚脸')
    GUDIANFACE = (6, '古典脸')
    ZHIXINGFACE = (7, '知性脸')
    XIAOLUFACE = (8, '小鹿脸')
    BIAOZHUNFACE = (9, '美人脸')


class PointLocationType(Enum):
    """点位类型"""
    X_P = (1, '(x, -), x已知，不变；y变')
    P_Y = (2, '(-, y), x变，y已知，不变')
    X_Y = (3, '(x, y), x, y为已知两点')


class IncludedAngleType(Enum):
    """夹角类型"""
    GREATER_THAN_90 = (1, '大于90度')
    LESS_THAN_90 = (2, '小于等于90度')


class GoldValueDefineType(Enum):
    """黄金值定义类型"""

    ANGLE = (1, "角度")
    PERCENT = (2, "比值")
    SKIN = (3, "肤质")


class PointValueUnit(Enum):
    """值的单位"""
    CENTIMETRE = (1, "CM 厘米")
    ANGLE = (2, "度 角度")
    SKIN = (3, "肤质")


class GoldSkinValue(Enum):
    """黄金肤质"""

    skin_color = (1, "肤色")
    dark_circle = (2, "黑眼圈")
    eye_pouch = (3, "眼袋")
    forehead_wrinkle = (4, "抬头纹")
    crows_feet = (5, "鱼尾纹")
    eye_finelines = (6, "眼部细纹")
    glabella_wrinkle = (7, "眉间纹")
    nasolabial_fold = (8, "法令纹")
    skin_type1 = (9, "出油度")
    skin_type2 = (10, "含水度")
    pore = (11, "毛孔")
    blackhead = (12, "黑头")
    acne = (13, "痘痘")
    mole = (14, "痣")
    skin_spot = (15, "斑点")


class RatioCombination(Enum):
    """脸型比例组合"""

    COMBINATION_A = ('a', "0.62<下颌颧宽比<=0.77 且 0.9<中下庭比<=1.18;")
    COMBINATION_B = ('b', "0.62<下颌颧宽比<=0.77 且 中下庭比<=0.9;")
    COMBINATION_C = ('c', "0.62<下颌颧宽比<=0.77 且 1.18<中下庭;")
    COMBINATION_D = ('d', "下颌颧宽比<=0.62 且 0.9<中下庭比<=1.18;")
    COMBINATION_E = ('e', "下颌颧宽比<=0.62 且 中下庭比<=0.9；")
    COMBINATION_F = ('f', "下颌颧宽比<=0.62 且 1.18<中下庭比；")
    COMBINATION_G = ('g', "0.77<下颌颧宽比 且 0.9<中下庭比<=1.18")
    COMBINATION_H = ('h', "0.77<下颌颧宽比 且 中下庭比<=0.9")
    COMBINATION_I = ('i', "0.77<下颌颧宽比 且 1.18<中下庭比")


class CheekStyleSort(Enum):
    """脸型比例组合"""

    RANK = (1, "按模板排序")
    FEASIBILITY = (2, "按可行性排序")


class PLASTIC_V4_TAGS(int, Enum):
    BIBUSUODUAN = (1, u"鼻部缩短")
    BIBUJIACHANG = (2, u"鼻中隔延长")
    RENZHONGSUODUAN = (3, u"人中缩短")
    SUOXIABA = (4, u"缩短下巴")
    DIANXIABA = (5, u"垫下巴")
    FENGCHUN = (6, u"丰唇")
    BAOCHUN = (7, u'薄唇')
    SUODUANYANJU = (8, u"缩眼距")
    FENGTAIYANXUE = (9, u"丰太阳穴")
    KAIYANJIAO = (10, u"开眼角")
    SHUANGYANPI = (11, u"双眼皮")
    SHOULIAN = (12, u"瘦脸")
    SUOXIAHEJIAO = (13, u"缩下颌角")
    SUOBIYI = (14, u"缩鼻翼")
    SUOBIBEI = (15, u"缩鼻背")
    XIUMEI = (16, u"修眉")
    SUOZHAIXIABA = (17, u"缩窄下巴")
    MCHUN = (18, u"M唇")
    XIAYANLIANXIAZHI = (19, u"下眼睑下至")
    MEIBAINENFU = (20, u"美白")
    QUHEIYANQUAN = (21, u"祛黑眼圈")
    QUYANDAI = (22, u"祛眼袋")
    CHUTAITOUWEN = (23, u"祛抬头纹")
    QUYANWEN = (24, u"祛眼纹")
    CHUMEIJIANWEN = (25, u"祛眉间纹")
    CHUFALINGWEN = (26, u"祛法令纹")
    KONGYOU = (27, u"控油")
    BUSHUI = (28, u"补水")
    SUOMAOKONG = (29, u"缩毛孔")
    QUHEITOU = (30, u"祛黑头")
    QUDOU = (31, u"祛痘")
    QUZHI = (32, u"祛痣")
    QUBAN = (33, u"祛斑")
    SHANGYANLIANTISHENG = (34, u"上眼睑提升")
    QUANGUNEITUI = (35, u"颧骨内推")
