#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, absolute_import
from ..utils.enum import Enum, unique


class TRACTATE_STATUS(Enum):
    """
    新帖子审核状态
    """
    TEMPORARY_STORAGE = ("1", u"暂存")
    UNAUDITED = ("2", u"未审核")
    AUDIT_SUCCESS = ("3", u"审核通过")
    AUDIT_REJECT = ("4", u"审核拒绝")


class TRACTATE_PLATFORM(Enum):
    """
    新帖子发布来源
    """
    GM = ("1", u"更美")
    HERA = ("2", u"HERA后台")
    DOCTOR = ("3", u"医生端")
    XIAOHONGSHU = ("4", u"小红书")
    WEIBO = ("5", u"微博")
    SOYOUNG = ("6", u"新氧")
    MARK = ("7", u"站内打卡活动")
    VARIETY_SHOW_YOUNG = ("8", "选秀节目(少年之名)打榜活动")
    GROUP_DETAIL = ("9", "普通小组")
    GROUP_TOPIC_DETAIL = ("10", "普通小组话题")


class TRACTATE_CONTENT_LEVEL(Enum):
    """
    新帖子内容等级
    """
    NULL = ("0", u"未评级")
    BAD = ('2', u'差')
    GENERAL = ('3', u'一般')
    FINE = ('4', u'良好')
    EXCELLENT = ('5', u'优秀')
    OUTSTANDING = ('6', u'特别优秀')


class TRACTATE_REPLY_SOURCE(Enum):
    """
    新帖子评论，数据来源
    """
    GM = ("1", u"更美")
    HERA = ("2", u"HERA后台")


class TRACTATE_ID_SOURCE(Enum):
    """
    新帖子，数据类型，目前应用于举报
    """
    TRACTATE = ('1', u'新帖子')
    TRACTATE_REPLY = ('2', u'新帖子评论')


class TRACTATE_REPORT_TYPE(Enum):
    """
    举报类型
    """
    TRACTATE = ('1', "举报帖子")
    IMAGE = ('2', u'举报图片')
    VIDEO = ('3', u'举报视频')
    REPLY = ('4', u'举报回复')


class TRACTATE_REPORT_ACTION(Enum):
    """
    举报处理
    """
    UNHANDLED = ('0', '未处理')
    USER_MISTAKE = ('6', '用户误点')


class TRACTATE_REPLY_STATUS(Enum):
    """
    Hera后台回复状态
    """
    NOT_REPLY = ('0', '回复')
    HAS_REPLY = ('1', '已回复')


class TRACTATE_REPLY_HIGHLIGHT(Enum):
    """
    高亮状态
    """
    DARK = (0, '不高亮')
    LIGHT = (1, '高亮')
    MORE_LIGHT = (2, '查看更多高亮')


class SOFT_ARTICLE_RELATION_TYPE(Enum):
    """
    医生后台  关联相关内容类型
    """
    TAG = (1, '标签')
    SERVICE = (2, '美购')
    DIARY = (3, '日记本')


class SOFT_ARTICLE_TYPE(Enum):
    """
    医生后台   帖子类型
    """
    ORDINARY = (1, '普通帖子')
    VIDEO = (2, '视频帖子')


class SOFT_ARTICLE_ORDER(Enum):
    """
    医生后台  帖子顺序
    """
    UNSET = (999, '未设置置顶')
    IN_TOP = (1, '置顶1')
    IN_SECOND = (2, '置顶2')
    IN_THIRD = (3, '置顶3')


class TRACTATE_DATA_TYPE(Enum):
    """
    帖子数据类型，用于区分是医生帖 和 用户帖
    """
    USER = ("user_post", "用户帖")
    DOCTOR = ("doctor_post", "医生帖")


class TRACTATE_SORT_TYPE(Enum):
    """
    帖子数据排序方式，用于微信小程序 帖子列表的最热和最新
    """
    HOTEST = (1, "最热")
    NEWEST = (2, "最新")


class APPLET_PAGE_FROM(Enum):
    """
    小程序进入页面的来源
    """
    CARD = (100, "订阅消息卡片")


class APPLET_SUBSCRIBE_MSG_TYPE(Enum):
    """
    小程序订阅消息类型
    """
    COMMENT = (1, "评论")
    VOTE = (2, "点赞")
    NEW_COMMENT = (3, "新增评论")
    RELATED_CONTENT = (4, "相关内容")


class PGC_TYPE(Enum):
    """
    增加pgc类别：无，社区，新媒体，美学专家，默认是无
    """
    DDEFAULT = (0, "无")
    COMMUNITY = (1, "热点")
    NEW_MEDIA = (2, "科普")
    AESTHETIC_EXPERT = (3, "转化")
