# -*- coding: utf-8 -*-
"""
Created on Mon Jan  8 17:05:21 2018

@author: hanye
"""
import logging
from func_build_maintainance_index import build_maintainance_index
import datetime
import task_stats


today=datetime.datetime.now()
previous_day=today-datetime.timedelta(days=1)
fetch_year=previous_day.year
fetch_month=previous_day.month
fetch_day=previous_day.day

# define logger
loggerName = 'maintainance_build_manual'
logger=logging.getLogger(loggerName)
logger.setLevel(logging.DEBUG)
# create handler
path='/home/hanye/project_data/Python/Projects/proj-short-videos/write-data-into-es/log/'
log_fn='build_maintainance_for_%s_on_%s_log' % (previous_day.isoformat()[:10], datetime.datetime.now().isoformat().replace(':','-'))
fh=logging.FileHandler(path+log_fn)
fh.setLevel(logging.INFO)
# create formatter and add it to the handler
formatter=logging.Formatter('%(asctime)s - %(name)s - %(levelname)s - %(message)s')
fh.setFormatter(formatter)
# add handler to logger
logger.addHandler(fh)

logger.info('log starts')

# write task status into task-stats index when starts
task_start_ts = int(today.timestamp()*1e3)
task_stats.record_task_stats(
     task_name='build_maintainance_index_daily_task',
     program_file_name='build_maintainance_index_daily_task.py',
     task_freq='daily',
     start_time=task_start_ts,
     time_of_processed_data=task_start_ts
     )

for cal_day in range(1, fetch_day+1):
    build_maintainance_index(fetch_year, fetch_month, cal_day)

logger.info('All done.')

# write task status into task-stats index when ends
task_end_ts = int(datetime.datetime.now().timestamp()*1e3)
task_stats.record_task_stats(
     task_name='build_maintainance_index_daily_task',
     program_file_name='build_maintainance_index_daily_task.py',
     task_freq='daily',
     start_time=task_start_ts,
     time_of_processed_data=task_start_ts,
     end_time=task_end_ts,
     is_done=True,
     task_stats='Done',
     )


