import datetime
import argparse
import pandas as pd
from BigCustomerClass import BigCustomerWeiXin
from BigCustomerClass import week_num

if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('-s', '--start_day', default=None)
    parser.add_argument('-e', '--end_day', default=None)
    args = parser.parse_args()
    now = datetime.datetime.now()
    if args.start_day is None:
        now_list = [now]
    else:
        now_list = pd.date_range(args.start_day, args.end_day)


    # 写入日数据
    for now in now_list:
        write_date = now - datetime.timedelta(2)
        weixin_detail = BigCustomerWeiXin(systematic='weixin', data_day=write_date.day, data_year=write_date.year,
                                          data_month=write_date.month, data_week=None)

        weixin_detail.construction_search_body()
        scan_detail = weixin_detail.scan_data(index=weixin_detail.detail_index, doc_type=weixin_detail.detail_doc_type,
                                              search_body=weixin_detail.search_detail_body)
        weixin_detail.write_into_mysql(scan_detail, tablename=weixin_detail.detail_table)

        # # 周详细数据写入
        # if now.weekday() == 0:
        #     data_week = week_num()[7]
        #     weixin = BigCustomerWeiXin(systematic='weixin', data_day=None, data_year=now.year,
        #                                data_month=now.month, data_week=data_week)
        #
        #     weixin.construction_search_body()
        #     scan_detail = weixin.scan_data(index=weixin.detail_index, doc_type=weixin.detail_doc_type,
        #                                    search_body=weixin.search_detail_body)
        #     weixin.write_into_mysql(scan_detail, tablename=weixin.detail_table)
