# coding: utf-8

from __future__ import unicode_literals, absolute_import

from ..utils.enum import Enum as NewEnum


class PromotionTimeType(NewEnum):

    CONTINUE_TIME = (1, "连续时间")    # 哪年几月几日几点几分几秒 -  哪年几月几日几点几分几秒
    SUBSECTION_TIME = (2, "分段时间")    # 几点到几点  每天重复


class PaymentType(NewEnum):

    FINAL_PAYMENT = (1, "尾款")
    ADVANCE_PAYMENT = (2, "预付款")


class ReducedType(NewEnum):
    """
    优惠类型： 价格或者类型
    """

    PRICE = (1, "价格")
    DISCOUNT = (2, "折扣")


class RuleType(NewEnum):

    SECONDS_KILL = (1, "秒杀")
    GROUP_BOOKING = (2, "拼团")
    COMMON_PRICE = (3, "普通价格")
    DINE_AND_DASH = (4, "霸王餐")
    COMBO_PACKAGE = (5, "套餐")
    OVER_BOUGHT = (6, "多买优惠")
    ONE_TO_ONE_FREE = (7, "买一增一")
    BUY_GIFT = (8, "买赠")


class PromotionStatus(NewEnum):

    CREATING = (1, "创建中")           # 创建中 的活动 不展示，属于信息不全的活动
    CREATED = (2, "已创建")            # 创建活动最后的步骤是提交商品分类，此时活动状态变更为已创建
    TO_SIGN_UP = (3, "提报中")
    START = (4, "已开始")
    FINISH = (5, "已结束")
    SHUTOFF = (6, "已停止")
    SIGN_UP_END = (7, "提报结束")


class PromotionTransitionStep(NewEnum):

    CREATED = (1, "创建成功")
    START_SIGN = (2, "开始提报")
    START_LIVE = (3, "开始活动")
    FINISH_LIVE = (4, "结束活动")
    SHUTOFF_LIVE = (5, "停止活动")
    SIGN_END = (6, "结束提报")


class RuleValueType(NewEnum):
    # 规则类型 值得可选类型

    WRITE_INTEGER = (1, "填写整数")
    WRITE_FLOAT = (2, "填写浮点数")
    WRITE_STRING = (3, "填写字符串")
    WRITE_DATE = (4, "填写日期")
    WRITE_VALID_DATE = (5, "填写有效期")
    WRITE_SCOPE = (6, "填写范围")
    ONE_CHOICE = (7, "单选")
    MULTIPLE_CHOICE = (8, "多选")


class BaseRuleType(NewEnum):

    USER_SCOPE = (1, "用户")
    TIME = (2, "时间")
    DISCOUNT = (3, "折扣")
    MUTEX = (4, "互斥")
    COMMODITY = (5, "商品")
    SETTLEMENT_CASH = (6, "结算金额")
    SETTLEMENT_TIME = (7, "结算时间")
    SETTLEMENT_ORDER = (8, "结算订单")


class CommodityRuleType(NewEnum):

    SINGLE = (1, "单个")
    MULTIPLE = (2, "多个")
    GIFT = (3, "赠品")


class SettlementOrderRuleType(NewEnum):

    AUTO_REFUND = (1, "自动退款")
    FREE = (2, "0元单")
    GIFT_FREE = (3, "赠品免费")


class SettlementCashRuleType(NewEnum):

    SINGLE_DIRECT_REDUCTION = (1, "单品直减")
    SINGLE_INCREASE = (2, "单品加价购")
    SUBTOTAL_DIRECT_REDUCTION = (3, "小计直减")
    SUBTOTAL_FULL_GIFT = (4, "小计满赠")
    SUBTOTAL_FULL_REDUCTION = (5, "小计满减")
    SUBTOTAL_EACH_FULL_REDUCTION = (6, "小计每满减")
    SUBTOTAL_LADDER_FULL_REDUCTION = (7, "小计阶梯满减")
    TOTAL_DIRECT_REDUCTION = (8, "总计直减")
    TOTAL_FULL_GIFT = (9, "总计满赠")
    TOTAL_FULL_REDUCTION = (10, "总计满减")
    TOTAL_EACH_FULL_REDUCTION = (11, "总计每满减")
    TOTAL_LADDER_FULL_REDUCTION = (12, "总计阶梯满减")


class SettlementTimeType(NewEnum):

    EFFECTIVE_TIME = (1, "有效时间")
    FAILURE_TIME = (2, "失效时间")


class TimeRuleType(NewEnum):

    LADDER = (1, "阶梯")
    CONTINUOUS = (2, "连续时间")


class TimeUnitType(NewEnum):

    HOUR = (1, "时分秒")
    DATE = (2, "年月日时分秒")


class UserScopeType(NewEnum):

    NEW = (1, "新用户")
    OLD = (2, "老用户")
    OLD_BELT_NEW = (98, "老带新")
    NEW_BELT_OLD = (99, "新带老")


class DiscountRuleType(NewEnum):

    BUY_GIFT = (1, "买赠")
    PACKAGE = (2, "套餐")
    FULL_REDUCTION = (3, "满减")
    FULL_GIFT = (4, "满赠")
    DIRECT_REDUCTION = (5, "直减")
    DISCOUNT = (6, "折扣")
    GROUP_BUY = (7, "团购")


class AreaScopeType(NewEnum):

    NATIONWIDE = (1, "全国")
    REGION = (2, "按大区")
    PROVINCE = (3, "按省市")
    MERCHANT = (4, "按商户")


class PromotionPriority(NewEnum):

    HIGH = (1, "高")
    MID = (2, "中")
    LOW = (3, "低")


class CommodityAuditStatus(NewEnum):

    UN_AUDITED = (1, "待审核")
    REJECTED = (2, "已驳回")
    AUDITED = (3, "过审核")


class PriceSetType(NewEnum):

    PRICE_RANGE = (0, "商品价格区间")
    DIRECT_SUBTRACT = (1, "直减")
    DISCOUNT = (2, "折扣")
    BOTH_DIRECT = (3, "商品价格区间 + 直减")
    BOTH_DISCOUNT = (4, "商品价格区间 + 折扣")


class ParticipationStatus(NewEnum):

    ALL = (0, "全部")
    CAN_SIGN_IN = (1, "可报名")
    SIGNED_IN = (2, "已报名")
    NOT_SIGN_IN = (3, "未报名")


class InventoryType(NewEnum):

    ALL_INVENTORY = (1, "总库存")
    DAY_INVENTORY = (2, "日库存")


class AllPromotionType(object):
    """促销活动所有活动类型"""
    SEC_KILL = "秒杀"
    GROUP_BOOK = "拼团"
    DINE_AND_DASH = "霸王餐"
    COMBO = "优惠套餐"
    OVER_BUY = "多买优惠"
    DISCOUNT = "折扣"


class SignUpStatus(NewEnum):
    # 活动报名状态  用于列表展示
    SIGNED_IN = (1, "已报名")
    NOT_SIGN_IN = (2, "未报名")
    ACTIVITY_OFF = (3, "活动截止")


class ActivitySignUpStatus(NewEnum):
    # 活动报名状态  用于列表展示
    NO_SIGNED_IN = (0, "未报名其他排他性活动")
    SIGNED_IN_THIS = (1, "已报名该活动")
    SIGNED_IN_OTHER = (2, "已报名其他排他性活动")
    NO_CAN_SIGNED_IN = (3, "该商品限制分类不符，不可报名此活动")
    CAN_SIGNED_IN = (4, "可报名")


class AllPromotionEnum(NewEnum):
    # 活动报名状态  用于列表展示
    SEC_KILL = (1, "秒杀")
    GROUP_BOOK = (2, "拼团")
    DINE_AND_DASH = (3, "霸王餐")
    COMBO = (4, "优惠套餐")
    OVER_BUY = (5, "多买优惠")
    DISCOUNT = (6, "折扣")
