# -*- coding: utf-8 -*-
"""
Created on Fri Mar 15 10:52:23 2019

@author: zhouyujiang
"""

import smtplib
import datetime
import sys
import argparse
import re 
from email.message import EmailMessage
from func_send_keyword_in_file_ck_log import func_find_file_keyword

parser = argparse.ArgumentParser()
parser.add_argument('-d', '--datestr', type=str, default=None, 
                    help=('like 2019-3-15'))
args = parser.parse_args() 

if args.datestr is None:
    nowdaystr = str(datetime.datetime.now())[0:10]
else:
    nowdaystr = args.datestr

ck_log_path = '/data0/var/log/maintenance/'
ck_log_file_name = 'getOTTdataFromFTP_log_' + nowdaystr
ck_log_file_name_extract = 'getOTTdataFromFTP_log_' + nowdaystr + '__extract_errs'

ck_file = ck_log_path+ck_log_file_name
ck_file_extract = ck_log_path+ck_log_file_name_extract
ck_log_list = [ck_file, ck_file_extract]
print('will check:', ck_log_list)
keyword_list = ['with zero length on HDFS for platform', 'failed']


re_dict_list = func_find_file_keyword(ck_log_list, keyword_list)
error_file_list = set()
unzip_file_list =set()
for one in re_dict_list:
    path = one['path']
    keyword = one['keyword']
    line_list = one['filelines']
    if line_list != []:
        print('get error in ', path)
        for line in line_list:
            if 'zero length on HDFS for platform' in line:
                list_str = re.findall(".*\[(.*)\].*", line)
                err_messg_str = list_str[0]
                if err_messg_str != '':
                    err_messg_list = err_messg_str.split(',')
                    for one_err in err_messg_list:
                        one_err = one_err.replace("'", '')
                        err_file = one_err.split('/')[-1]
                        error_file_list.add(err_file)
                
                
            if 'failed' in line:
                list_str = re.findall(".*Extract file(.*)failed:.*", line)
                err_messg_str = list_str[0]
                if err_messg_str != '':
                    err_file = err_messg_str.strip().split('/')[-1]
                    unzip_file_list.add(err_file)
all_body = ''
if len(error_file_list) != 0:
    messg_body_file = ',\t'.join(error_file_list)
    messg_body_1 = str(datetime.datetime.now())[0:10] + '发现{%d}个空文件'%len(error_file_list) + '具体如下：\t' + messg_body_file
    all_body = all_body + messg_body_1
if len(unzip_file_list) != 0:
    messg_body_failed = '\t'.join(unzip_file_list)
    messg_body_2= str(datetime.datetime.now())[0:10] + '发现解压文件失败，\t'
    all_body = all_body + '\n\n' + messg_body_2
if all_body != '':
    email_subj = '[TVpOTT 原始数据预警] %s'%str(datetime.datetime.now())[0:10]
    email_msg=EmailMessage()
    csm_mail_service='mail.csm.com.cn'
    sender = 'zhouyujiang@csm.com.cn'
    email_group = ['zhouyujiang@csm.com.cn']
    email_msg.set_content(all_body)
    email_msg['Subject']=email_subj
    email_msg['From']=sender
    email_msg['to']=email_group
    server=smtplib.SMTP(host=csm_mail_service)
    server.send_message(email_msg)
    server.quit()          
                
        
       
        
    
    

