# coding=utf-8
from __future__ import unicode_literals, absolute_import
from ..utils.enum import Enum, unique


@unique
class CONTENT_CLASS(Enum):
    UNAUDITED = (0, '未分级')
    ILLEGAL = (1, '不合规')
    BAD = (2, '差')
    GENERAL = (3, '一般')
    FINE = (4, '良好')
    EXCELLENT = (5, '优秀')
    OUTSTANDING = (6, '特别优秀')


@unique
class SPAM_LABEL(Enum):
    NORMAL = (0, '正常')
    SPAM = (1, '疑似垃圾')
    EROTICISM = (2, '色情')
    ADVERTISE = (3, '广告')
    PROHIBIT = (4, '违禁')
    ABUSE = (5, '谩骂')
    WATERING = (6, '灌水')


@unique
class GRABBING_PLATFORM(Enum):
    ZHIHU = ('0', '知乎')
    WEIXIN = ('1', '微信')
    WEIBO = ('2', '微博')
    HERA = ('3', 'hera后台')
    #WANGYI = ('4', '网易女人')
    #TENCENT = ('5', '腾讯网')
    #HEADLINE = ('6', '今日头条')
    INSHEADLINE = ('7', '趣头条')
    KYC = ('8', 'kyc流程创建')
    GM = ('99', '更美内部')  # 7675后版本增加用户上传图文混排


@unique
class QUESTION_SOURCE(Enum):
    INVITATION = ("0", "邀请回答")
    RECOMMEND = ("1", "推荐回答")

@unique
class ASSESSMENT_TYPE(Enum):
    ANSWER = ("0", "回答")
    SPECIALCOLUMN = ("1", "专栏")


@unique
class QUESTION_TYPE(Enum):
    TRADE = (0, '交易')
    GOSSIP = (1, '八卦')
    EMOTION = (2, '情感')
    BEAUTY_SKILL = (3, '变美技巧')
    STAR_PRETTY = (4, '明星颜值')
    PRODUCT_TEST = (5, '美妆产品评测')
    STAR_SHARE = (6, '明星变美分享')


@unique
class SEND_ANSWER_STATUS(Enum):
    WAITTING = (0, '未发送')
    SUCCESS = (1, '发送成功')
    FAILE = (2, '发送失败')


@unique
class QA_CONTENT_TYPE(Enum):
    ORDINARY = ('0', '普通问答')
    VIDEO = ('1', '视频问答')


@unique
class VIDEO_SOURCE_TYPE(Enum):
    DIARY = (0, '日记贴视频')
    QUESTION = (1, '问题视频')
    ANSWER = (2, '回答视频')
    ARTICLE = (3, '专栏视频')


@unique
class COMMENT_DIFF_TYPE(Enum):
    GENERAL = (0, '普通评论')
    QUALITY = (1, '异形评论')


@unique
class QUALITY_QUESTION_REPLY_TYPE(Enum):
    ANSWER = (2, '异形回复')
    REPLY = (3, '异形评论')