import datetime
import argparse
import pandas as pd
from BigCustomerClass import BigCustomerShortVideo
from BigCustomerClass import week_num

if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('-s', '--start_day', default=None)
    parser.add_argument('-e', '--end_day', default=None)
    args = parser.parse_args()
    now = datetime.datetime.now()
    if args.start_day is None:
        now_list = [now]
    else:
        now_list = pd.date_range(args.start_day, args.end_day)

    # 写入日数据
    for now in now_list:
        print(now, now_list)
        write_date = now - datetime.timedelta(2)
        short_video = BigCustomerShortVideo(systematic='short_video', data_day=write_date.day, data_year=write_date.year,
                                            data_month=write_date.month, data_week=None)
        short_video.construction_search_body()
        scan_detail = short_video.scan_data(index=short_video.detail_index, doc_type=short_video.detail_doc_type,
                                            search_body=short_video.search_detail_body)
        short_video.write_into_mysql(scan_detail, tablename=short_video.detail_table)

    # if now.weekday() == 0:
    #     data_week = week_num()[7]
    #     short_video_detail = BigCustomerShortVideo(systematic='short_video', data_year=now.year,
    #                                                data_month=now.month, data_week=data_week)
    #     short_video_detail.construction_search_body()
    #     scan_detail = short_video_detail.scan_data(index=short_video_detail.detail_index,
    #                                                doc_type=short_video_detail.detail_doc_type,
    #                                                search_body=short_video_detail.search_detail_body)
    #
    #     short_video_detail.write_into_mysql(scan_detail, short_video_detail.detail_table)
    #
    #     # 周汇总数据
    #     short_video_agg = BigCustomerShortVideo(systematic='short_video', data_year=now.year,
    #                                             data_month=now.month, data_week=data_week)
    #     short_video_agg.construction_search_body()
    #     scan_agg = short_video_agg.scan_data(index=short_video_agg.agg_index, doc_type=short_video_agg.agg_doc_type,
    #                                          search_body=short_video_agg.search_agg_body)
    #     short_video_agg.write_into_mysql(scan_agg, short_video_agg.agg_table)

