# -*- coding: utf-8 -*-
from __future__ import print_function, absolute_import, unicode_literals

from .utils.enum import Enum, unique


@unique
class ERROR(int, Enum):
    """
    分配错误码时请参考、维护代码库根目录下的文件 ERROR_CODE_REGION.txt
    """

    SUCCESS = (0, '请求成功')

    # 不要定义 10000（一万）以下的错误码！！！
    # DON'T DEFINE ERROR CODE BELOW 10000 (ten thousand) !!!
    # REGION BEGIN DEPRECATED
    SERVICE_NOT_EXSIT = (1, '美购不存在')
    SERVICE_SOLD_OUT = (2, '美购已售完')
    SPECIAL_ORDER = (3, '特殊订单，请使用美分兑换')
    SERVICE_NO_POINT = (4, '您的美分不足以兑换该福利，赚更多美分之后可以再来看看')
    PARAMS_INCOMPLETE = (5, '参数不完整')
    NO_PERMISSION = (7, '没有权限')
    LIMITED = (8, '超过购买限制')
    OPERATION_NOT_SUPPORTED = (9, u'非法操作')
    SERVICE_STATUS_ERROR = (10, u'美购状态错误')
    DATA_SOURCE_NOT_CORRECT = (11, u'数据状态有误')
    LIVE_IS_CONTINUE = (12, u'已在直播中')
    LIVE_MSG_TOO_FREQUENTLY = (13, u'您发送弹幕过于频繁了,请稍后再试')
    LIVE_IS_NOT_FOUND = (14, u'直播流不存在')
    LIVE_IS_BAN_SEND_MSG = (15, u'您已经被禁言')
    LIVE_LIKE_TIME_LIMIT = (16, u'您点赞太频繁')

    BODYPART_NOT_FOUND = (100, u'bodypart未找到')
    BODYPART_SUBITEM_NOT_FOUND = (101, u'bodypart_subitem未找到')
    SHARE_NOT_FOUND = (200, u'分享不存在')
    REQUIRED_LOGIN = (1001, 'Login Required')
    BUDAN_RECORD_EXIST = (4399, u'补单记录已存在, 请勿重复创建')

    BLOG_CATEGORY_EXIST = (8002, '博客目录已存在')
    BLOG_POST_NOT_FOUND = (8101, '博客文章不存在')
    BLOG_POST_EXIST = (8102, '博客文章已存在')
    BLOG_CATEGORY_NOT_FOUND = (8103, '博客栏目不存在')
    BLOG_POST_CREATE_ERROR = (8104, '创建博客文章失败')
    # REGION END
    # DON'T DEFINE ERROR CODE BELOW 10000 (ten thousand) !!!
    # 不要定义 10000（一万）以下的错误码！！！

    # 错误号不要凑整！要节约空间！像 15432 就是一个很好的错误码！
    PARAMS_INVALID = (10001, u'非法参数')
    SERVICE_COMMENT_CREATED = (10002, u'已创建此订单评价')
    CREATE_SERVICE_COMMENT_FAILED = (10003, u'创建订单评价失败')
    RENMAI_PARAMS = (10004, u'任买返回参数错误')
    RENMAI_BUSINESS_ERROR = (10005, u'任买业务错误')
    NO_BORROWER = (10006, u'未找到借款人')
    NO_INSTALLMENT = (10007, u'未找到分期单')
    RENMAI_STATUS_ERROR = (10008, '分期单状态错误')
    BORROWER_EXIST = (10009, '借款人已存在')
    BORROWER_INFO_EXIST = (10010, '借款人个人信息已填')
    INSTALLMENT_EXIST = (10012, '结算单已分期')
    BORROWER_RELATIVE_EXIST = (10013, '借款人联系人信息已填')
    RENMAI_IMAGE_ERROR = (10014, '身份证照片错误')
    RENMAI_CONTACTS_ERROR = (10015, '联系人参数错误')
    INSTALLMENT_SERVICE_INVALID = (10016, '分期服务暂不可用')

    FENXIAO_WANGHONG_NOT_EXIST = (10020, '网红不存在')
    CASH_PACKET_ALREADY_RECEIVED = (10021, '现金红包已领取')
    NOT_SUFFICIENT_FUNDS = (10022, '余额不足，无法提现')

    PROVINCE_DOES_NOT_EXIST = (10111, '没有指定地区')
    ITEMWIKI_NOT_EXIST = (10112, '百科不存在')
    QQ_CARD_GAINED = (10113, '卡券已领取')
    QQ_CARD_VERIFY_FAILED = (10114, '身份验证失败')

    RESERVATION_NOT_FOUND = (12300, '找不到预约')
    NO_AVAIL_SLOTS = (12301, '无可预约的时间段')
    NO_RESERVATION_DETAIL = (12302, '没有指定的预约信息')
    NO_RESERVATION_DATA = (12303, '无预约信息')
    RESERVED = (12304, '已进入预约状态')
    NO_RESERVE_STATUS = (12305, '订单暂未进入预约状态')
    NOT_ACCEPT_RESERVATION = (12307, '医生不接受预约')
    ALREADY_CASH_BACK = (12800, '已经返现')
    FEEDBACK_NOT_FOUND = (12900, '反馈不存在')
    FEEDBACK_CATEGORY_NOT_FOUND = (12901, '反馈类型不存在')
    DIARY_HAS_VOTED = (12902, '已经赞过啦')
    FEEDBACK_REPETITION = (12903, '反馈间隔时间太短')

    ALREADY_REPORTED = (13001, '相同内容仅能举报一次～')

    USER_ALREADY_REIGST = (14001, '用户已经注册')
    SETTLEMENT_HAS_INSTALLMENT = (14002, '结算单已分期')
    USER_ALREADY_FILL_USERINFO = (14003, '用户已经填写个人信息')
    ORDER_IS_NOT_STAGE = (14004, '订单非分期订单')
    OSMS_CODE_FAIL = (14005, '验证码失效')
    USER_ALREADY_EXIST = (14006, 'Id或User关联已存在')
    USER_ALREADY_REIGST_DOCTOR = (14007, '用户已经注册医生')
    FACE_IMAGE_NOT_FOUND = (14008, '用户扫脸图片不存在')
    FACE_IMAGE_CREATE_FAILURE = (14009, '用户扫脸图片创建失败')
    FACE_NOT_FOUND = (14010, '本图片中未探测到人脸，换张试试~')

    NOT_QUALIFIED_FOR_COUPONGIFT = (15429, '哎呀，您已经是资深老用户了，把机会留给新用户嘛~')
    COUPON_IS_EMPTY = (15430, '美券已抢完')
    COUPON_CLAIMED = (15431, '美券已被他人领走')
    COUPON_DOES_NOT_EXIST = (15432, '美券不存在')
    COUPON_LAUNCH_DOES_NOT_EXIST = (15433, '该美券投放信息不存在')
    COUPON_YOU_HAVE_GOT_ONE = (15434, '已经领取过此次的美券')
    COUPON_UNAVAILABLE = (15435, '美券无效')
    COUPON_GIFT_DOES_NOT_EXIST = (15436, '美券礼包不存在')
    COUPON_PRE_PAYMENT_FALSE = (15437, '消费额度不够')
    COUPON_SCENARIOS_FALSE = (15438, '美券使用场景不对')
    COUPON_CLAIM_FAIL = (15439, '领取美劵失败')
    CAN_NOT_APPLY_REFUND_SINCE_COUPON_GT_PAYMENT = (15440, '该美购退款金额，不足抵扣优惠减免，无法退款')
    CAMPAIGN_NOT_FOUND = (15500, '找不到活动')
    CAMPAIGN_HAD_OVERFLOW = (15501, '活动已存在超值专场')
    COUPON_EXCEED_LIMIT = (15502, '您已达到领取次数限制')
    COUPON_NOT_START = (15503, '该礼包未到领取时间')
    COUPON_CLOSED = (15504, '该礼包已过领取时间')
    CAMPAIGNPAGE_NOT_FOUND = (15505, '活动已结束')

    GAME_GODDESS_BEYOND_LIMIT = (16000, '已达到优惠上限')
    GAME_GODDESS_HAS_PARTICIPATED = (16001, '已砍过')

    DOCTOR_NOT_PARTICIPANT = (17001, '医生未参加该奖项')
    EXCEED_VOTE_LIMIT = (17002, '每天只能投一次票哦')

    DOCTOR_NOT_JOIN = (17003, '当前医生未参加该活动')
    HOSPITAL_NOT_JOIN = (17004, '当前机构未参加该活动')
    FD_EXCEED_VOTE_LIMIT = (17005, '已达到该项投票上限')
    DOCTOR_HAS_JOIN = (17006, '当前医生已参加该活动')
    HOSPITAL_HAS_JOIN = (17007, '当前机构已参加该活动')

    TOPIC_NOT_FOUND = (20001, '该帖子不存在')
    TOPIC_HAS_BEEN_DELETED = (20002, '该帖子已被删除或下线')
    REPLY_CAN_NOT_CONTAIN_CONTACT = (20003, '对不起，您的回复没有发送成功，为维护社区纯洁性，我们建议您在文中避免加入个人联系信息，并建议用户直接拨打APP内医生预留电话与您联系。')
    REPLY_CAN_NOT_BE_EMPTY = (20004, '回复文字不能为空')
    REPLY_CAN_NOT_BE_REPEATED = (20005, '请勿回复重复内容')
    TOPIC_REPLY_NOT_FOUND = (20006, '该评论不存在')
    TOPIC_REPLY_HAS_VOTED = (20007, '该评论已经赞过')
    TOPIC_HAS_VOTED = (20008, '该帖子已经赞过')
    DIARY_NOT_FOUND = (20009, '该日记本不存在')
    DIARY_HAS_BEEN_DELETED = (20010, '该日记本已被删除或下线')
    DOCTOR_REPLY_TOPIC_LIMITED = (20011, '已经达到回复上限')
    TOPIC_CONTENT_CAN_NOT_BE_EMPTY = (20012, u'帖子文字不能为空')
    TOPIC_CONTENT_CAN_NOT_CONTAIN_CONTACT = (20013, '帖子内容不能包含个人信息')
    ASK_SUOZHANG_TO_DELETE_TOPIC = (20014, '请所长删帖')
    HAS_FAVORED = (20015, '已收藏')
    DIARY_RATE_LIMIT_REACHED = (20016, '抱歉，已达到评价次数上限')
    DIARY_WONT_BE_DELETED = (20017, '该日记本不可删除哦，联系更美客服解决吧！')
    DRAFT_NOT_FOUND = (20018, '指定草稿不存在')
    NO_EDIT = (20019, '不能修改')
    ATTR_CHANGE = (20020, '多属性维度变动')
    NO_SERVICE_REGISTER = (20021, '美购申请不存在')
    NO_OFFLINE = (20022, '审核中，不允许下线')
    ADD_NUM_ERROR = (20023, '库存修改不正确')
    TOPIC_IMAGES_OVERFLOW = (20024, u'最多选择9张图片')
    TOPIC_ERROR_TYPE = (20025, u'发帖类型错误')
    CONTENT_CREATE_ERROR = (20026, u'发布失败，请稍后再试')
    COMMENT_CONTAINS_SENSITIVE_WORD = (20027, u'发送失败')
    COMMENT_BUSY = (20028, u'你的回复有点频繁，稍后再来')
    TOPIC_CONTENT_CAN_NOT_CONTAIN_FORBID_WORD = (20029, u'抱歉，内容含有被禁止的词汇，建议你修改相关内容')
    CONTENT_CAN_NOT_CONTAIN_FORBID_WORD = (20030, u'内容含有被禁止的词汇')
    TOPIC_REPLY_BAN_NOT_OWN = (20031, u'不可对非己方日记贴进行评论')
    NEED_RECREATE = (20032, u'发布失败，请重新发布')

    TRACTATE_NOT_FOUND = (20501, u'帖子不存在')
    TRACTATE_OFF_LINE = (20502, u'帖子已经下线')
    TRACTATEREPLY_NOT_FOUND = (20503, u'评论不存在')
    TRACTATEREPLY_OFF_LINE = (20504, u'评论已经下线')
    TRACTATE_HAS_VOTED = (20505, u'该帖子已经赞过')
    TRACTATEREPLY_HAS_VOTED = (20506, 'u该评论已经赞过')
    TRACTATE_HAS_FAVOR = (20507, u'该帖子已收藏')
    TRACTATE_CREATE_ERROR = (20508, u'发布失败，请稍后再试')
    TRACTATE_REPLY_ERROR = (20509, u'帖子评论失败，请稍后再试')
    TRACTATE_FAVOR_ERROR = (20510, u'帖子收藏失败，请稍后再试')
    TRACTATE_UNFAVOR_ERROR = (20511, u'帖子取消收藏失败，请稍后再试')
    TRACTATE_VOTE_ERROR = (20512, u'赞失败')
    TRACTATE_UNVOTE_ERROR = (20513, u'取消赞失败')
    TRACTATE_CREATE_CONTENT_ERROR = (20514, u'发帖内容字数不符规范，字数限制:10-1000字')
    TRACTATE_CREATE_MEDIA_ERROR = (20515, u'发帖失败，视频或图片必须有一个')
    TRACTATE_CREATE_MEDIA_MAX_ERROR = (20516, u'发帖失败，视频或图片总数超过最大值')

    MESSAGE_TRANSFER_CONSULTANT_NOT_EXISTS = (20900, '客服不存在') # 转诊咨询不存在
    MESSAGE_TRANSFER_CONSULTANT_NOT_EXISTS_IN_MERCHANT = (20901, '该商户下没有客服') # 该商户下没有咨询师
    MESSAGE_TRANSFER_CONSULTANT_CREATE_CONVERSATION_FAILED = (20902, '创建会话失败') # 创建转诊咨询会话失败
    MESSAGE_TRANSFER_NOT_IN_GROUP = (20903, '客服不在该会话中')
    MESSAGE_TRANSFER_NO_ONLINE_CONSULTANT = (20904, '没有在线客服')
    MESSAGE_UNKNOWN_USER = (21001, '用户未登录')
    MESSAGE_INVALID_USER = (21002, '非法用户')
    MESSAGE_NO_PERMISSION = (21003, '没有权限')
    MESSAGE_INVALID_TARGET_USER = (21004, '收信人非法')
    MESSAGE_CONTENT_FILTERED_OUT = (21005, '消息包含过滤词')
    MESSAGE_CONTENT_EMPTY = (21006, '消息不可以为空')
    MESSAGE_INVALID_CONVERSATION = (21007, '无效会话')
    MESSAGE_SAVING_FAILED = (21008, '消息存储失败')
    SEO_DIGEST_NOT_FOUND = (21009, 'SEO资讯不存在')
    SEO_CATEGORY_NOT_FOUND = (21010, 'SEO分词不存在')
    MESSAGE_DOUBTED_CONVERSATION = (21011, '发送失败')
    MESSAGE_CONVERSATION_TAG_NAME_ALREADY_EXIST = (21012, '标签名称已存在')
    MESSAGE_CONVERSATION_TAG_NOT_EXIST = (21013, '标签不存在')
    AGILE_TAG_NAME_ERR = (21014, '标签名称不能为空')
    AGILE_TAG_NAME_EXIST = (21015, '已经存在同名标签')

    INVALID_CODE = (22001, '错误的验证码')
    PHONE_PASSWORD_INVALID = (22002, '手机号或密码不正确')
    PLEASE_RESET_PASSWORD = (22003, '该手机号还未设置过密码，请使用验证码登录，然后设置密码')
    PASSWORD_IS_EMPTY = (22004, '密码不能为空')
    PASSWORD_IS_DIFFERENT = (22005, '两次输入的密码不一致')
    PASSWORD_IS_SAME = (22006, '新密码不可与旧密码相同')
    PASSWORD_FORMAL_ERROR = (22007, '请设置6-16位字母或数字的密码')
    PASSWORD_INVALID = (22008, '当前密码不正确')

    PERSON_EXIST = (23001, '账号已存在')
    PERSON_NOT_FOUND = (23002, '该手机号未注册过更美，请先注册')
    BIND_EXIST_BIND_PHONE = (23103, '绑定一个已经绑定的手机')
    BIND_EXIST_PHONE = (23104, '绑定一个已经注册的手机')
    SENT_TOO_MANY_VERIFICATION_CODE = (23105, '已达到验证码每日发送上限')
    SENT_TOO_MANY_EMAIL = (23106, '已达到邮件每日发送上限')

    ACTIVITY_NOT_EXIST = (24000, '活动不存在')
    DO_NOT_HAS_ENOUGH_POINTS_TO_JOIN_ACTIVITY = (24001, '美分不足')
    ACTIVITY_CLOSED = (24002, '活动已结束')
    ACTIVITY_NOT_STARTED = (24003, '活动未开始')
    ACTIVITY_PARTICIPATE_LIMIT = (24004, '已经参加过啦')
    ACTIVITY_REACH_WIN_LIMIT = (24005, '已无中奖名额')
    ACTIVITY_SKU_LIMIT = (24100, '库存超过设置的上限')
    ACTIVITY_PRICE_OVER = (24101, '价格超过了当前美购价格')
    ACTIVITY_EXCHANGE_FAIL = (24102, '兑换失败，请稍后再试')
    ACTIVITY_IMAGES_NONE = (24103, u'请补充图片')

    DOCTOR_NOT_FOUND = (30001, '该医生不存在')
    DOCTOR_HAS_APPLIED = (30002, '医生已经申请审核加入')
    DOCTOR_HAS_NOT_APPLIED = (30003, '医生未申请审核加入')
    DOCTOR_STATUS_ERRO = (30004, '医生状态错误')
    DOCTOR_HAS_EXISTED = (30005, u'此账号已经注册过医生/医院账号，请更换其他账号注册')
    DOCTOR_OFFLINE = (30006, '医生/机构已下线')
    DOCTOR_REG_PHONE_EXT_ERROR = (30100, u'注册医生分机号失败')

    STATS_NOT_FOUND = (31001, '统计数据不存在')
    REGISTER_TYPE_ERROR = (31002, '注册类型错误')

    HAS_APPLY_BILL = (31101, u'该对账单或充值单已申请过发票')
    NO_BILL_INFO = (31102, u'请补全财务信息后再申请发票。发票抬头、税务登记号修改请联系更美商务。')
    NO_MERCHANT_ACCOUNT = (31201, u'补充完整财务信息后才能才能进行对账确认。请前往"个人信息－财务信息"进行补充。')

    # 医生后台--商务相关
    BUSINESS_NOT_FOUND = (32000, u'只允许商务账号登录')
    BUSINESS_NO_PERMISSION = (32001, u'您没有权限管理该医生')
    # 医生切换账号
    DOCTOR_SWITCH_NO_PERMISSION = (32100, u'您没有管理医生权限')
    DOCTOR_SWITCH_NOTALLOW_TARGET = (32101, u'您没有权限管理该医生')
    DOCTOR_NOT_USER = (32102, u'医生没有关联User')
    DOCTOR_SWITCH_NOT_SELFRUN = (32103, u'该医生已经不是自营医生')
    # 医生资源排序
    DIARY_RANK_NOT_FOUND = (32110, u"此日记本没有设置排名")
    DIARY_RANK_EXIST = (32111, u"此日记本已经设置了排名")
    SERVICE_RANK_EXIST = (32112, u"此美购已经设置了排名")
    SERVICE_RANK_NOT_EXSIT = (32113, u"此美购没有设置排名")
    RANK_ERROR = (32114, u"设置排名参数错误")
    # 医生后台- 案例管理
    DIARY_STICK_PRIORITY_EXIST = (32115, u'当前美购此置顶位已被占用')
    DIARY_STICK_PRIORITY_UNSUPPORT = (32116, u'不支持该优先级')

    UNKNOWN_ERROR = (40000, '未知错误')
    SERVICE_NOT_FOUND = (40001, '美购不存在')
    SERVICE_EXIST = (40002, '福利已存在')
    SERVICE_ATTR_EXIST = (40003, '福利属性已存在')
    SERVICE_OPTION_EXIST = (40005, '福利属性选项已存在')
    SERVICE_OUT_OF_DATE = (40006, '美购已过期')
    SERVICE_ALREADY_IN_SHOPCART = (40007, '美购已经在购物车中')
    SHOPCART_ITEM_NOT_FOUND = (40008, '购物车中没有此项')
    SERVICE_CAN_NOT_ADD_TO_SHOPCART = (40009, '免费美购不能添加到购物车中')
    FREE_OR_GIFT_CAN_NOT_USE_POINTS_DEDUCTION = (40010, '美购不可用美分抵扣')
    SETTLEMENT_CREATE_FAIL = (40011, '创建结算单失败')
    SETTLEMENT_DOES_NOT_EXIST = (40012, '结算单不存在')
    SETTLEMENT_CANCEL_FAIL = (40013, '取消结算单失败')
    SETTLEMENT_PAID = (40014, '已经支付，请勿重复支付')
    SETTLEMENT_CANCELED = (40015, '已经取消，请重新下单')
    SETTLEMENT_HAVE_NOT_CONFIRM = (40016, '存在没有确认的对账单')
    SKU_NOT_FOUND = (40017, 'SKU不存在')
    SERVICE_OFF_LINE = (40018, '该美购已经下线')
    SKU_OFF_LINE = (40019, '该SKU所在美购已经下线')
    SERVICE_NOT_ON_SALE = (40020, '该美购已经不再售卖')
    SKU_NOT_ON_SALE = (40021, '该SKU所在美购已经不再售卖')


    SERVICE_FAVOR_NOT_FOUND = (41001, '找不到福利收藏')
    SPECIAL_DOES_NOT_EXIST = (41002, '美购专题不存在')

    COUPON_NOT_FOUND = (42001, '该美券不存在')
    COUPON_TOTAL_INVALID = (42002, '美券投放总量超过限额')
    COUPON_LAUNCH_TOTAL_INVALID = (42003, '美券投放总量超过限额')
    COUPON_HAS_BEEN_USED = (42004, '美券已经被使用')
    USE_COUPON_FAIL = (42005, '使用美劵时出错')
    COUPON_GIFT_NOT_FOUND = (42006, '该礼包不存在')

    ORDER_NOT_FOUND = (43001, '该订单不存在')
    ORDER_CAN_NOT_CANCEL = (43002, '抱歉，该订单不能取消，请联系工作人员')
    ORDER_CAN_NOT_REFUND = (43003, '抱歉，该订单不可退款，请联系工作人员')
    ORDER_CASH_BACK_FAILURE_TIME = (43004, '对不起，您上次申请的结果为暂时无法返现，需要等待至少72小时才能再次申请，加油更新吧！')
    ORDER_NEED_DIARY_TOPICS_NUM = (43005, '对不起，您的申请返现日记篇数不足')
    REFUND_CAN_NOT_CANCLE = (43006, '抱歉，该退款不可撤销，请联系工作人员')
    REFUND_ERROR = (43007, '退款返现发生错误')
    ORDER_CASH_BACK_STATUS_WAIT = (43008, '请勿重复提交返现申请')
    ORDER_PAID = (43009, '已经支付，请勿重复支付')
    ORDER_CANCELED = (43010, '已经取消，请重新下单')
    ORDER_DUPLICATE = (43011, '订单重复')

    SECKILL_UNAVAILABLE = (44001, '对不起，秒杀已结束')
    SECKILL_TIME_OVERLAP = (44002, '秒杀专场时间重合')
    SERVICE_STOCK_INSUFFICIENT = (44003, '美购库存不足')
    SECKILL_NOT_FOUND = (44004, '找不到对应秒杀')
    SECKILL_NOTIFY_CREATE_FAIL = (44005, '提醒创建失败，请重试')
    SECKILL_NOTIFY_NOT_FOUND = (44006, '还未创建对应秒杀的提醒')
    SECKILL_NOTIFY_HAS_CREATED = (44007, '提醒已设置，请耐心等待')

    GROUPBUY_BEFORE_START_TIME = (44201, '拼团还没有到开始时间')
    GROUPBUY_AFTER_END_TIME = (44202, '拼团已经过期')
    GROUPBUY_SOLD_OUT = (44203, '拼团美购已经卖完')
    GROUPBUY_IS_FINISHED = (44204, '拼团已经结束')
    GROUPBUY_ONLY_NEW_USER_CAN_JOIN = (44205, '只有新用户才能参加拼团')
    GROUPBUY_USER_ALREADY_JOINED = (44206, '你已经参加了拼团')
    GROUPBUY_NOT_EXISTS = (44207, '拼团不存在')
    SERVICE_GROUPBUY_PRICE_DISABLE = (44208, '此商品不再参与此拼团')

    FREE_SERVICE_NOT_SUPPORT_CASHBACK = (45001, '免费项目不支持分享返现')

    REFUND_ORDER_NOT_FOUND = (46001, '该退款单不存在')

    QUESTION_NOT_FOUND = (47000, '该问题不存在')
    ANSWER_NOT_FOUND = (47001, '该评论不存在')
    QUESTION_NOT_ONLINE = (47002, '该问题已下线')
    ANSWER_NOT_NLINE = (47003, '该答案已下线')
    ANSWER_HAS_RECOMMEND = (47004, '已有一个推荐回答')

    QUALITY_QUESTION_NOT_FOUND = (47005, '该问题不存在')
    QUALITY_QUESTION_OFFLINE = (47006, '该问题已经下线')
    QUALITY_ANSWER_NOT_FOUND = (47007, '该回答不存在')
    QUALITY_ANSWER_OFFLINE = (47008, '该回答已经下线')
    QUALITY_REPLY_NOT_FOUND = (47009, '该回答已经下线')
    QUALITY_HAS_QUESTIONING = (47010, '该问题已经追过问')
    QUALITY_QUESTION_VOTED = (47011, '该问题已经点过赞')

    GROUP_NOT_FOUND = (47101, '该小组不存在')
    GROUP_OFFLINE = (47102, '该小组已下线')
    GROUP_FOLLOWED = (47103, '已经关注该小组')

    BUDAN_NOT_PROJECTS = (48000, u'请填写开发项目')
    BUDAN_NO_PERMISSION = (48001, u'您没有权限查看该补单')
    BUDAN_STATUS_ERROR = (48002, u'补单状态不对，请刷新')
    BUDAN_HISTORY_READNOLY = (48003, u'只能撤销本月内创建的补单')

    TAG_NOT_FOUND = (50001, '找不到tag')
    TAG_HAS_NO_WIKI = (50002, '该tag没有三级分类WIKI')
    TAG_RELATION_CYCLE = (50003, 'TAG连成了环')
    TAG_CAN_NOT_RELATE = (50010, 'TAG不能产生关联')

    NEWS_NOT_FOUND = (50011, '找不到指定行业资讯')

    SLIDE_NOT_FOUND = (51001, '找不到轮播图')

    ZONE_NOT_FOUND = (52001, '圈子不存在')
    VALID_POINT_TYPE = (52010, '积分类型不存在')
    VALID_POINT_OPERATION = (52011, '错误的积分操作')

    NO_FACE_ANALYZE_AVAILABLE = (53001, '无可用的人脸分析档案')
    FACE_ANALYZE_NOT_EXISTS = (53002, '该人脸分析档案不存在')
    FACE_SAVE_SIMULATE_RESULT_FAIL = (53003, '保存模拟整形结果失败')
    BDTRANSFER_NOT_EXIST = (53010, '商务转诊不存在')
    BDTRANSFER_OPERATION_RECORD_NOT_EXIST = (53011, '商务转诊操作记录不存在')
    BDTRANSFER_SINGLE_RECORD_NOT_EXIST = (53012, '商务转诊派单记录不存在')
    BDTRANSFER_COMMUNICATION_RECORD_NOT_EXIST = (53013, '商务转诊沟通记录不存在')


    HOSPITAL_NOT_FOUND = (60001, '该机构不存在')
    HOSPITAL_HAD_OFFICER = (60101, '该机构已经存在一个管理者')
    XIAOYING_ERROR = (60102, '小赢错误')

    # ----------------  61000-62000 for ai  -------------------
    NEED_KYC_ERROR = (61000, '需要完成kyc')

    THEME_NOT_FOUND = (61001, '主题不存在')

    # ----------------  70000-71000 for user -------------------
    LOGIN_REQUIRED = (70000, '请登录后再试')
    USER_NOT_FOUND = (70001, '找不到用户')
    LOGIN_FAIL = (70002, '登陆失败')
    USERNAME_PASSWORD_NOT_MATCH = (70003, '用户名或者验证码错误')
    USER_IN_BLACKLIST = (70004, '用户在黑名单中')
    UPDATE_FAIL = (70005, '操作失败')
    USER_NEED_AUTHORIZE = (70006, '需要实名认证')
    ACCESS_OVER_LIMIT = (70007, '访问超出频率限制')

    GET_THIRD_INFO_FAILED = (70010, '获取第三方信息失败')
    UNSUPPORTED_APP = (70011, '应用参数异常')
    INVALID_PHONE_NUM = (70012, '手机号无效, 请检查输入')
    INVALID_PARAMS = (70013, '参数错误')
    INVALID_VFC = (70014, '验证码错误')

    EXIST_THRID_FOR_PHONE = (70015, '此手机号已绑定过账号')
    ACCESS_LIMIT = (70016, '操作太过频繁, 请稍候再试')
    PHONE_NEEDED_FOR_THIRD_REG = (70017, '需绑定手机号')
    DECRYPT_FAILED = (70018, '参数验证失败')
    SIGN_VERIFY_FAILED = (70019, '接口验证失败')
    ACCOUNT_SESSION_INCON = (70020, '账户异常')
    GET_PHONE_FAILED = (70021, '获取手机号失败')
    NO_MATCH_PHONE_MODE = (70022, '未定义的手机对接方式')

    ASSIST_PRIZE_INVALID = (70101, '助力商品不存在')
    ASSIST_PRICE_EXPIRED = (70102, '助力活动已过期')
    # ------------------ user_error end ----------------------
    DOCTOR_NO_SCHEDULE_TEMPLATE = (71001, '您没有可用模板，请先设置模板')

    VERIFY_CODE_TYPE_ERROR = (72001, u'验证码类型错误')
    MAX_CUSTOM_MADE_TIME_ERROR = (72002, u'每天最多提交5次')

    MAIDAN_STATUS_ERROR = (73000, u'买单设置审核中, 请勿重复提交申请')
    MAIDAN_NOT_OPEN = (73001, u'医生没有开启买单功能，请咨询医生')

    VERSION_UPDATE_ERROR = (73010, u'已经是最新版本了')
    UNBIND_MACHINE_CODE = (73012, u'导入失败，有未绑定的终端号')

    # 80000-89999 错误码不要用, 留给电商系统!!!!!!
    # 80000-89999 错误码不要用, 留给电商系统!!!!!!
    # 80000-89999 错误码不要用, 留给电商系统!!!!!!
    ORDER_VALIDATE_FAILED = (80000, '订单验证失败')
    ORDER_HAS_BEEN_VALIDATED = (80001, '订单已验证，无法再次验证')
    ORDER_WRONG_STATUS_CODE = (80002, '订单状态错误')
    GET_ORDER_INFO_FAILED = (80003, '订单信息查询失败')
    GET_JIKE_ORDER_INFO_FAILED = (80004, '即科订单信息查询失败')
    ORDER_HAS_BEEN_REFUNDED_CAN_NOT_VALIDATE = (80005, '订单已被验证')
    # 下订单 81100+
    ORDER_PAY_STATUS_ERROR = (81100, '支付订单状态错误')
    ORDER_PAY_CHECK_ERROR = (81101, '支付校验失败')
    SETTLEMENT_BOUGHT_SERVICE_EXCEED_LIMIT = (81102, '用户已购买过此美购并已达到购买限制')
    SETTLEMENT_HAS_UNPAID = (81103, '用户已购买过此美购尚未付款')
    VERIFY_FAILED = (81104, '网关校验失败')
    # 返现单 81200+
    ORDER_CASHBACK_NONSUPPORT = (81200, '订单不支持返现')
    ORDER_CASHBACK_NOT_FOUND = (81201, '该返现订单不存在')
    ORDER_CASHBACK_NOT_STALE = (81202, '不是过期返现单无法操作线下返现')
    ORDER_CASHBACK_HAS_BEEN_OPERATED = (81203, '已经被操作过返现')
    # 退款单 81300+
    ORDER_REFUDN_STATUS_ERROR = (81300, '退款状态错误, 无法继续操作')
    ORDER_REFUDN_PAYMENT_ERROR = (81301, '订单金额错误')
    ORDER_REFUDN_CANCLE_STATUS_ERROR = (81302, '取消退款状态错误')
    ORDER_REFUDN_HAS_BEEN_OPERATED = (81303, '已经被操作过退款')
    ORDER_REFUDN_NOT_FOUND = (81304, '该退款订单不存在')
    ORDER_REFUDN_NOT_STALE = (81305, '不是过期订单无法操作线下退款')
    # 医生结算单 81400+
    STATEMENT_NOT_EXIST = (81400, '此结算单不存在')
    STATEMENT_STATUS_ERROR = (81401, '结算单状态错误')
    # 保险错误码 81500+
    INSURANCE_ORDER_NOT_EXIST = (81500, '保险单不存在')
    # 80000-89999 错误码不要用, 留给电商系统!!!!!!
    # 80000-89999 错误码不要用, 留给电商系统!!!!!!
    # 80000-89999 错误码不要用, 留给电商系统!!!!!!
    SEARCH_PARAM_ERROR = (98001, '搜索输入参数错误')
    EMAIL_NOT_ALLOWED = (99001, '该邮箱不允许注册后台')
    EMAIL_INVALID = (99002, '邮箱无效')
    USER_MAX_RETIES = (99003, '登录失败，已达到每日最大尝试次数')
    USER_MAX_RETIES_CHANGE = (99004, '已超过每日最大尝试次数')
    IMAGE_UPLOAD_FAIL = (99005, '图片上传失败')

    # 综艺投票
    ACTIVITY_VOTE_OLD_USER = (9200, '填写失败，非新用户不可填写')
    INVITE_CODE_NOT_EXIST = (9201, '该邀请码不存在，请重新输入')
    ACTIVITY_OFFLINE = (9202, '活动已经下线')
    # ACTIVITY_NOT_EXIST = (9203, '活动不存在')
    VOTE_NUM_NOT_ENOUGH = (9204, '当前票数不足')
    HAS_INVITED = (9205, '填写失败，不可重复提交')
    ACTIVITY_END = (9206, '活动已经结束')
    TONGDUN_RISK = (9207, '不可填写')
    ACTIVITY_NOT_START = (9208, '活动还没开始')
    INVITE_CODE_IS_YOURS = (9209, '填写失败，不可填写自己的邀请码')
    ACTIVITY_IDOL_NOT_FOUND = (9210, '选手不存在')
    ACTIVITY_IDOL_IS_OUT = (9211, '选手已淘汰')
    ACTIVITY_TASK_MAX_ASSIST = (9221, "对不起，当然任务完成次数已达上线!")

    IS_DOCTOR = (9300, '该账户是机构号')
    HAS_SIGN = (9301, '用户已签到')
    ADD_SIGN_STATUS_ERROR = (9302, '已分享，请稍后再试')
    SIGN_SUCCESS_AND_STATUS_ERROR = (9303, '补签成功，请稍后再试')
    SIGN_RUSH_PRIZE_NO_ONTIME = (9304, '活动还没有开始，娃娃还在路上哦～')
    SIGN_NO_PRIZE = (9305, '兑换的商品不存在哦!')
    SIGN_ZERO_PRIZE_COUNT = (9306, 'Oops，手慢啦，下次一定能抢到！')
    SIGN_NO_QUALIFICATION = (9307, '收集的娃娃还不够呢，快去做任务吧！')
    SIGN_TASK_DONE = (9308, '叮！此项任务达成，去隔壁完成其他任务吧！')
    SIGN_HAS_ASSIST = (9309, '你已成功为好友助力！')
    SIGN_MAX_ASSIST = (9310, '今天助力次数已达上限，明天再来吧！')
    SIGN_NO_POINTS = (9311, '你的积分不足哦，快去完成任务赚取积分吧！')
    SIGN_NO_BLIND_BOX = (9312, '你的娃娃离家出走了 再抽一次吧！')
    SIGN_HAS_EXCHANGED = (9313, '您已兑换过此奖品，加油集齐盲盒兑换其他大奖吧！')
    CAN_NOT_USE_DISCOUNT = (9400, '机构账号拍单不可以使用美券和美分哦～')

    # 打卡
    DAILY_CHECK_ACTIVITY_NOT_FOUND = (9500, '打卡活动未找到')
    DAILY_CHECK_MAX_NUMS_REMIND = (9501, "同一打卡活动, 参与次数已达上限")
    DAILY_CHECK_LUCK_DATA_NOT_FOUND = (9502, '运势信息未找到')

    #IP黑名单和设备黑名单错误码
    IP_BLACK_DELETE_SUCCESS = (95000, 'IP删除成功')
    IP_BLACK_EXISTS = (95001, 'IP已存在')
    DEVICE_BLACK_DELETE_SUCCESS = (95002, '设备id删除成功')
    DEVICE_BLACK_EXISTS = (95003, '设备id已存在')

    # 96000-97000 错误码不要用, 留给面诊系统!!!!!!
    # 96000-97000 错误码不要用, 留给面诊系统!!!!!!
    # 96000-97000 错误码不要用, 留给面诊系统!!!!!!

    USER_IS_BLOCKED = (96001, '用户被封禁')
    USER_HAS_NOT_FINISHED_RECORD = (96002, '用户存在未结束的通话')
    USER_CANOT_CALL_SELF = (96003, '用户不能呼叫自己')

    COUNSELLOR_IS_BUSY = (96004, '对方正在面诊中，请稍后再试')
    COUNSELLOR_IS_BLOCKED = (96005, '当前面诊账号被禁止使用视频面诊')
    COUNSELLOR_IS_OFFLINE = (96006, '对方已下线，可以关注并私信他哟～')

    COUNSELLOR_NOT_EXIST = (96007, '医生不存在')
    CONSULTATION_FAILED = (96008, '呼叫失败，请稍后再试')
    CONSULTATION_RECORD_NOT_EXIST = (96009, '面诊记录不存在')
    CONSULTATION_CANCELLED = (96010, '视频面诊通话已取消')
    CONSULTATION_SYSTEM_CANCELLED = (96011, '视频面诊通话未接通')
    CONSULTATION_FINISHED = (96012, '视频面诊通话已结束')
    NOT_FOUND_CONSULTATION_COUNSELLER = (96013, '没有找到指定的医生')
    NOT_FOUND_CONSULTATION_RECORD = (96014, '没有找到指定的面诊记录')
    # CONSULTATION_RECORD_NOT_FOUND = (96015, "面诊记录不存在")
    CONSULTATION_COMMENT_RECORD_NOT_FOUND = (96015, "面诊评价记录不存在")
    CONSULTATION_COMPLAINTED = (96017, "面诊记录已经被评价")
    CONSULTATION_NOT_COMPLAINT = (96018, "面诊评价记录不存在")
    COUNSELLOR_START_CONSULTATION_FAIL = (96019, '开启面诊失败')
    COUNSELLOR_STOP_CONSULTATION_FAIL = (96020, '结束面诊失败')
    CONSULTATION_CONNECTED = (96021, '视频面诊通话已接通')
    NO_MATCH_CURRENT_CONSULTATION_DISPATCH = (96022, '没有等待分配的面诊派单')
    CONSULTATION_DISPATCH_NOT_FOUND = (96023, '没有找到指定的面诊派单')
    NO_MATCH_COUNSELLOR_FOR_DISPATCH = (96024, '没有符合派单条件的面诊顾问')
    CONSULTATION_DISPATCH_IS_EXPIRED = (96025, '面诊派单已经过期')
    NOT_FOUND_CONSULTATION_DISPATCH_TASK = (96026, '没有找到指定的面诊派单任务')
    CONSULTATION_DISPATCH_IS_CANCELLED = (96027, '面诊派单已经取消')
    CONSULTATION_DISPATCH_IS_ASSIGNED = (96028, '面诊派单已经被分配')
    CONSElLOR_DOCTOR_IS_OFFLINE = (96029, '当前医生已下线')
    CONSElLOR_CONSULTANT_IS_OFFLINE = (96030, '当前面诊师已下线')
    COUNSELLOR_STOP_CONSULTATION_FAIL_CONSULTATING = (96031, '结束失败：正在面诊中')  # 结束面诊失败96020扩展
    COUNSELLOR_STOP_CONSULTATION_FAIL_HAVING_STOP = (96032, '当前已经结束面诊')  # 结束面诊失败96020扩展
    COUNSELLOR_START_CONSULTATION_FAIL_HAVING_START = (96033, '当前已经开启面诊')  # 开启面诊失败96019扩展

    CONSULTATION_ORDER_ALREADY_PAID = (96034, '面诊订单已支付')
    CONSULTATION_ORDER_ALREADY_CANCELLED = (96035, '面诊订单已取消')
    CONSULTATION_ORDER_STATUS_ERROR = (96036, '面诊订单状态异常, 请重新提交')
    CONSULTATION_ORDER_NOT_SUPPORT_CHANNEL = (96037, '暂时不支持该支付方式')
    CONSULTATION_ORDER_PRICE_CHANGED = (96038, '面诊订单价格有变动，请重新提交')
    CONSULTATION_ORDER_PAY_FAIELD = (96039, '面诊订单支付失败')
    CONSULTATION_ORDER_UNPAY = (96040, u'面诊订单未支付，请先支付')
    CONSULTATION_ORDER_NOT_EXISTS = (96041, '面诊订单不存在')
    CONSULTATION_ORDER_ALREADY_HAS_RECORD = (96042, '面诊订单已存在面诊记录')
    CONSULTATION_VERSION_LOWER = (96043, '请更新最新版更美APP体验视频面诊功能')
    CONSULTATION_ORDER_CANCELLED = (96044, '视频面诊已取消，本次视频面诊订单金额将原路退还至您的账户中')

    COUNSELLOR_IS_BUSY_WITH_REFUND = (96045, '抱歉，对方正在面诊中\n本次视频面诊订单金额将原路退还至您的账户中。')
    COUNSELLOR_IS_BLOCKED_WITH_REFUND = (96046, '抱歉，对方已被禁用视频面诊功能\n本次视频面诊订单金额将原路退还至您的账户中')
    COUNSELLOR_IS_OFFLINE_WITH_REFUND = (96047, '抱歉，对方已下线\n本次视频面诊订单金额将原路退还至您的账户中。')

    CONSULTATION_DISPATCH_HAS_SELF_JOINED = (96048, '您已经抢过该面诊派单了')
    CONSULTATION_DISPATCH_HAS_SELF_FINISHED = (96049, '您已经抢过该面诊派单了')

    SALES_LEAD_ACTION_TRIGGLE_BAD_PARAMS = (96501, '线索任务触发异常: 参数错误')
    SALES_LEAD_ACTION_TRIGGLE_USER_NOT_FOUND = (96502, '线索任务触发异常: 用户不存在')
    SALES_LEAD_ACTION_TRIGGLE_USER_BAD_PHONE = (96503, '线索任务触发异常: 用户手机号不正确')
    SALES_LEAD_ACTION_TRIGGLE_BAD_ACTION = (96504, '线索任务触发异常: 暂时不支持的触发行为')
    SALES_LEAD_ACTION_TRIGGLE_BAD_PAGE = (96505, '线索任务触发异常: 暂时不支持的触发页面')
    SALES_LEAD_ACTION_TRIGGLE_THOROTTLE_LIMIT = (96506, '线索任务触发异常: 触发流控规则')

    SALES_LEAD_PHONE_AUTHORIZE_BAD_USER_PHONE = (96507, '电话线索授权异常: 用户手机号非法')
    SALES_LEAD_PHONE_AUTHORIZE_BAD_MERCHANT_PHONE = (96508, '电话线索授权异常: 商户手机号非法')
    SALES_LEAD_PHONE_AUTHORIZE_ERROR = (96509, '电话线索授权异常: 服务异常')
    SALES_LEAD_PHONE_AUTHORIZE_NO_VIRTUAL_PHONE = (96510, '电话线索授权异常: 绑定虚拟号码失败')
    SALES_LEAD_ACTION_TRIGGLE_ALREADY_TRIGGLED = (96511, '线索任务触发异常: 已经生成线索任务')
    SALES_LEAD_ACTION_NOT_FOUND_MERCHANT = (96512, '线索任务触发异常: 没有找到对应的商户')

    SALES_LEAD_MERCHANT_BIND_INVALID_PHONE = (96513, '请输入正确的手机号码')

    SALES_LEAD_PHONE_LEAD_TASK_EXPIRED = (96514, '该电话线索任务已过期')
    SALES_LEAD_BIND_PHONE_NOAVAILABLE_PHONE = (96515, '暂无可用号码，请联系商务')
    SALES_LEAD_BIND_PHONE_FAILED = (96516, '绑定虚拟号码失败')

    SALES_LEAD_PAGE_TRIGGLE_ACTION_CLOSED = (96517, '核心页面行为触发已关闭')
    SALES_LEAD_PAGE_SKIP_TRIGGLE_ACTION_CLOSED = (96518, '核心页面跳转行为触发已关闭')
    SALES_LEAD_ACTION_NOT_WHITELIST_MERCHANT = (96519, '线索任务触发异常: 不是白名单商户')
    SALES_LEAD_ACTION_NOT_FOUND_USER = (96520, '线索任务触发异常: 没有找到对应的用户')

    # 首页page type
    PAGE_TYPE_NOT_FOUND = (91234, '错误page类型')
    UNIVERSAL = (99999, '通用错误码')
    # 错误码不要再涨了!!!
    # 错误吗不要再涨了!!!
    # 错误吗不要再涨了!!!
    # 不要写超过 99999 的错误码!!!
    # 不要写超过 99999 的错误码!!!
    # 不要写超过 99999 的错误码!!!
    # 错误号不要凑整！要节约空间！像 15432 就是一个很好的错误码！
