# coding=utf-8
from __future__ import absolute_import, unicode_literals
from ..utils.enum import Enum, unique


@unique
class ERROR(int, Enum):
    """
    分配错误码时请参考、维护代码库根目录下的文件 ERROR_CODE_REGION.txt
    """
    POINT_ACTIVITY_NOT_EXIST = (802001, '活动不存在')
    POINT_ACTIVITY_EXPIRE = (802002, '活动已过期')
    POINT_ACTIVITY_NOT_START = (802003, '活动未开始')
    POINT_ACTIVITY_GOODS_NOT_EXIST = (802004, '礼品不存在')
