# -*- coding: utf-8 -*-
""" 项目库. """
from gm_types.utils.enum import Enum


class FEED_CARD_TYPE(Enum):
    """ 项目库Feed 卡片类型 """
    PLAN = ("plan", '价格')
    HOSPITAL = ("hospital", '医院')
    DOCTOR = ("doctor", '医生')
    DIARY = ("diary", '评价')


class PLAN_CARD_CONSULT_TYPE(Enum):
    """ 项目库Feed 卡片咨询类型 """

    MESSAGE = ("message", '私信')
    SALES_LEAD = ("sales_lead", '私信线索触发')


class PLAN_TYPE(Enum):
    """ 方案类型. """

    LEVEL_ONE = (1, "一级方案")
    LEVEL_TWO = (2, "二级方案")


class PLAN_ATTR_TYPE(Enum):
    """ 属性类型 """

    SINGLE_CHOICE = (1, '单选')
    MULTIPLE_CHOICE = (2, '多选')
    TEXT = (3, '文字')


class PLAN_MATERIAL_TYPE(Enum):
    """ 物料类型 """

    DRUGS = (1, '药品')
    INSTRUMENT = (2, '仪器')
    MATERIAL = (3, '材料')


class PRICE_AGGRE_TYPE(Enum):
    """ 最低/最高价聚合维度类型. """

    ONE_LEVEL_PLAN = (1, '一级方案')
    TWO_LEVEL_PLAN = (2, '二级方案')
    ONE_LEVEL_PLAN_HOSPITAL = (3, '一级方案下医院')
    ONE_LEVEL_PLAN_DOCTOR = (4, '一级方案下医生')
    TWO_LEVEL_PLAN_HOSPITAL = (5, '二级方案医院')
    TWO_LEVEL_PLAN_DOCTOR = (6, '二级方案医生')
    PLAN = (7, '一级/二级方案')


class REQ_AUDIT_STATUS(Enum):
    """ 请求参数中的报价审核状态 """

    ALL = (1, '全部')
    NEW_PENDING = (2, '新增待审核')
    UPDATE_PENDING = (3, '修改待审核')
    PASSED = (4, '审核通过')
    REJECTED = (5, '审核不通过')


class PLAN_QUOTATION_TYPE(Enum):
    """ 报价类型 """

    NEW = (1, '新增')
    UPDATE = (2, '修改')


class PLAN_QUOTATION_STATUS(Enum):
    """ 报价状态 """

    PENDING = (1, '待审核')
    PASSED = (2, '已通过')
    REJECTED = (3, '已驳回')


class AUDIT_OPERATION(Enum):
    """ 审核操作 """

    PASS = (1, '通过')
    REJECT = (2, '驳回')


class PLAN_OPERATION(Enum):
    """ 方案操作 """

    ENABLE = (1, '启用')
    DISABLE = (2, '禁用')
