# -*- coding: utf-8 -*-
from __future__ import unicode_literals, absolute_import
from ..utils.enum import Enum, unique


@unique
class ERROR(Enum):
    """
    分配错误码时请参考、维护代码库根目录下的文件 ERROR_CODE_REGION.txt
    """
    NOT_SUPPORT_CHANNEL = (803100, u'不支持的渠道')
    NOT_SUPPORT_METHOD = (803101, u'不支持的方法')
    PARAM_INCOMPLETE = (803102, u'参数不完整')
    PARAM_ERROR = (803103, u'参数错误')
    PAYMENT_NOT_FOUND = (803104, u'支付单不存在')
    PREPAY_NOT_FOUND = (803106, u'预支付不存在')
    PAYMENT_ALREAD_FINISH = (803105, u'支付已完成')

    CALL_WECHAT_ERROR = (803300, u'调用微信API失败')
    WECHAT_ERROR = (803301, u"微信业务失败")
    WECHAT_VERIFY_SIGN_FAIL = (803302, u'验证微信签名失败')

    CALL_ALI_ERROR = (803501, u'调用支付宝错误')
    ALI_VERIFY_SIGN_FAIL = (803502, u'验证支付宝签名失败')
    ALI_NOTIFY_STATUS_ERROR = (803503, u'支付宝通知状态错误')

    CALL_LIANLIAN_ERROR = (803601, u'连连支付业务失败')
    LIANLIAN_VERIFY_FAIL = (803602, u'连连签名验证失败')


# 废弃，设计问题
@unique
class PAY_ERROR(Enum):
    NOT_SUPPORT_CHANNEL = (100, u'不支持的渠道')
    NOT_SUPPORT_METHOD = (101, u'不支持的方法')
    PARAM_INCOMPLETE = (102, u'参数不完整')
    PARAM_ERROR = (103, u'参数错误')
    PAYMENT_NOT_FOUND = (104, u'支付单不存在')
    PREPAY_NOT_FOUND = (106, u'预支付不存在')
    PAYMENT_ALREAD_FINISH = (105, u'支付已完成')

    CALL_WECHAT_ERROR = (300, u'调用微信API失败')
    WECHAT_ERROR = (301, u"微信业务失败")
    WECHAT_VERIFY_SIGN_FAIL = (302, u'验证微信签名失败')

    CALL_ALI_ERROR = (501, u'调用支付宝错误')
    ALI_VERIFY_SIGN_FAIL = (502, u'验证支付宝签名失败')
    ALI_NOTIFY_STATUS_ERROR = (503, u'支付宝通知状态错误')

    CALL_LIANLIAN_ERROR = (601, u'连连支付业务失败')
    LIANLIAN_VERIFY_FAIL = (602, u'连连签名验证失败')
