#!/usr/bin/env python
# -*- coding:utf-8 -*-
#
#   Author  :   RobertDing
#   E-mail  :   robertdingx@gmail.com
#   Date    :   16/11/29 20:08:20
#   Desc    :   自身错误表加第三方错误映射
#

from ..utils.enum import Enum, unique

# XXX 使用500,000 到 600,000错误码段
# XXX 501,000 到 510,000 为第三方错误码映射，请不要使用


@unique
class Error(int, Enum):
    """
    分配错误码时请参考、维护代码库根目录下的文件 ERROR_CODE_REGION.txt
    """

    CARD_ID_VALIDATE_ERROR = 500001, '身份证验证错误'
    UNSUPPORT_AGE = 500002, '18岁以上55岁以下才能申请'
    CERT_PHONE_NEEDED = 500003, '手机运营商授权后，才能使用分期哦，请至[我的]-[白条]中填写'
    PHONE_VALIDATE_ERROR = 500004, '实名验证失败，请填写正确的姓名、身份证号和本人手机号'

    CHANNEL_FAIL = 501103, '渠道编码无效'
    PARAM_ERROR = 501101, '参数异常'
    SYSTEM_ERROR = 501102, '登录失败，请5分钟后再试'
    ID_V_FAIL = 501104, '身份证校验失败'
    ID_V_USED = 501105, '此身份证被占用'
    INVALID_AMOUNT = 501106, '非法分期或非法金额'
    INVALID_HOSPITAL = 501107, '此商家暂不支持分期业务'
    INVALID_TOID = 501108, 'applyCode无效'
    TAOBAO_UNFINISH = 501109, '淘宝数据未完成'
    OPERATOR_UNFINISH = 501110, '运营商数据未完成'
    REGISTER_NEED = 501111, '用户未注册'
    VCODE_ERROR = 501112, '验证码错误'
    V_YRD_ERROR = 501113, '身份证号错误'
    PERSON_REGISTED = 501114, '用户已注册'
    AGE_INVALID = 501115, '白条业务暂只支持22周岁以上用户申请'

    ACCOUNT_FAIL = 501201, '网络错误，请稍后重试'
    PHONE_REGISTED = 501203, '手机号已注册'
    REGISTER_FAIL = 501205, '用户注册出错'
    LOGIN_FAIL = 501220, '帐号或密码错误,请重新提交'
    IMAGE_CODE_NEED = 501221, '需要提交图片验证码'
    PHONE_CODE_NEED = 501222, '需要提交短信验证码'
    PARSING = 501223, '解析中'
    PARSING_FAIL = 501224, '解析失败，重新登录'
    CONFIRM_FAIL = 501226, '消费确认失败'
    OPERATOR_FAIL = 501228, '运营商未抓取'
    TAOBAO_FAIL = 501229, '淘宝未抓取'
    OT_BOTH_FAIL = 501230, '淘宝运营商都未抓取成功'
    CANCEL_FAIL = 501233, '取消失败'
    NO_REPAY = 501235, '暂无还款计划'
    BEYOND_CREDIT = 501240, '订单额度超出您的信用额度，无法分期'
    ALREADY_INSTALLEMNT = 501241, '您的请求已提交，请耐心等待'
    BANK_ERROR = 501251, '您提交的信息有误，请重新提交'
    BANK_NAME_ERROR = 501252, '银行卡信息与姓名不符'
    BANK_ID_ERROR = 501253, '银行卡信息与证件信息不符'
    BANK_BEYOND = 501254, '您绑定的银行卡数超出上线'
    BANK_BINDED = 501255, '该银行卡已绑定'
    INVALID_BANK = 501256, '银行卡号有误'
    BANKCARD_NEED = 501257, '没有绑定银行卡'
    CANNOT_REPAY = 501260, '每日23:00-次日02:00期间内，不可还款'
    REPAY_NONEED = 501261, '款项已还清'
    NOT_TIME_RANGE = 501262, '该计划不在还款时间范围内'
    NONEED_PAY = 501300, '已还款成功'
    PASSWD_ERROR = 501310, '账户或密码错误，请重新登录'
    CODE_ERROR = 501311, '验证码错误，请重新输入'
    ACCOUNT_ABORNORMAL = 501340, '账号异常，请在浏览器登录淘宝后回来重试'
    TAOBAO_PHONE = 501341, '请在淘宝绑定手机后重试'
    ERROR_LIMIT = 501342, '密码错误达到上限，账号被锁3小时'
    ERROR_LIMIT_24 = 501361, '密码错误达到上限，账号被锁24小时'
    OPERATOR_PHONE = 501360, '请至运营商网站实名验证手机号'

    LOGIN_TIMEOUT = 501500, '登录失败，请重新登录'
    LOGIN_TIMEOUT1 = 501501, '登录失败，请重新登录'

    BANK_NEED = 501626, '请选择一个银行卡进行支付'
    NO_REPAY_AGAIN = 501635, '该还款单不能再次处理'
    SMS_FAIL = 501637, '短信发送失败，请重试'
    REPAY_FAIL = 501638, '支付失败，请重试'
    V_CODE_FAIL = 501639, '验证码错误'
    INVALID_ORDER = 501640, '订单不存在'
    ARGS_INVALID = 501699, '参数异常'

    # ########### ############ ############ ############ ############ ########
    # 以下任买异常错误码
    RM_SYSTEM_ERROR = 502101, "网络错误，请稍后重试"
    SYSBUSI = 502102, "网络错误，请稍后重试"

    # 业务逻辑异常
    VALIDATE_MSG_CODE_FAIL = 502001, "验证码错误"
    BUSI_NOT_EXIT = 502002, "商户不存在"
    THIRD_SOURCE_NOT_EXIT = 502003, "第三方系统标识不存在"
    PRODUCT_ID_NOT_EXIT = 502004, "商品ID不存在"
    CREDITPERSONFAIL = 502005, "实名认证失败"
    CREDITPERSONALREADY = 502006, "该用户已经实名通过"
    NOT_CREDIT_PERSON = 502007, "未进行实名认证"
    NOT_PERSON_INFO = 502008, "未进填写用户信息"
    CUSTOMER_NOT_EXIST = 502009, "该用户不存在"
    BANK_AUTH_FAIL = 502010, "您的银行卡鉴权失败，请重试或更换银行卡"
    NOT_BANK_AUTH = 502011, "未进行银行卡鉴权"
    STUDENT_SCORE_FAIL = 502012, "学生信息认证失败"
    REPAY_PLAN_FAIL = 502013, "账单查询失败"
    CUSTINFOCANNOTUPDATE = 502014, "客户信息不可修改"
    DORDER_CANCEL_FAIL = 502015, "订单取消失败"
    CARD_NULL = 502016, "信用卡额度不能为空"
    CARD_MIN = 502017, "信用卡额度过小"
    QQ_FAIL = 502018, "QQ校验失败"
    COM_NULL = 502019, "未填写公司信息"
    RELATIONSHIP_LESS_THREE = 502020, "联系人不能少于三条"
    STU_CANT_REST_COMPANY_INFO = 502021, "学生信息不允许请求公司接口！"
    RELATIONSHIP_NULL = 502022, "联系人不能为空"
    ORDER_IS_ROB = 502023, "订单已被抢"
    AUTHED = 502024,  "该用户已认证，请勿重复认证！"
    NO_BASE_AUTHED = 502025,  "该用户未进行基本信息认证，请先进行基本信息认证！"
    TB_LOGIN_FAIL = 502026, "淘宝登陆失败"
    JCYWYC = 502027, "决策引擎处理业务逻辑异常"

    # 参数异常
    RL_NOT_NULL = 503001, "联系人姓名不能为空"
    RL_NAME_TOO_LONG = 503002, "联系人姓名过长"
    RL_PHONE_NOT_NULL = 503003, "联系人电话不能为空"
    RL_PHONE_NOT_RIGHT = 503004, "联系人电话格式错误"
    RL_RL_ERROR = 503005, "联系人关系错误"
    RL_MARK_NOT_NULL = 503006, "联系人标记不能为空"
    RL_MARK__TOO_LONG = 503007, "联系人标记过长"
    PIC_NOT_EXITS = 503008, "图片不存在"
    IDCARD_INVALI = 503009, "身份证无效"
    INVALID_OPENID = 503010, "无效的openId"
    SCHOOL_YEAR_MORE_THAN_10 = 503011, "入学不得超过10年"
    CUST_BOOK_TOO_LONG = 503012, "通讯录长度过长"
    PIC_URL_ERROR = 503013, "图片链接格式有误"
    RM_INVALID_ORDER = 503014, "无效的订单"
    INVALID_ORDER_STATE = 503015, "无效的订单状态"
    REPEAT_SUBMIT = 503016, "重复提交请求"
    ORDER_ID_NOT_NULL = 503017, "订单id不能为空"
    OPENID_NOT_NULL = 503018, "openId不能为空"
    ADDR_NOT_NULL = 503019, "通讯录不能为空"
    BN_NOT_NULL = 503020, "银行名称不能为空"
    BN_XYES = 503021, "银行名称不能超过20字符"
    BC_NOT_NULL = 503022, "银行Code不能超过20字符"
    BC_XYES = 503023, "银行Code不能超过20字符"
    BO_NOT_NULL = 503024, "银行卡号不能为空"
    BO_XYES = 503025, "银行卡号不能超过20字符"
    BP_NOT_NULL = 503026, "银行卡预留手机号不能为空"
    BP_XYES = 503027, "银行卡预留手机号长度不正确"
    CI_NOT_NULL = 503028, "合同Id不能为空"
    UT_NOT_NULL = 503029, "用户类型不能为空"
    PP_NOT_NULL = 503030, "产品金额不能为空"
    PP_DYL = 503031, "产品金额必须大于0"
    LLR_NOT_NULL = 503032, "联系人不能为空"

    DWN_NOT_NULL = 503033, "单位名称不能为空"
    DWN_TOOL_ONG = 503034, "单位名称过长"
    CT_NOT_NULL = 503035, "所在城市不能为空"
    CT_TOO_LONG = 503036, "所在城市名不能过长"
    DWDZ_NOT_NULL = 503037, "单位详细地址不能为空"
    DWDZ_TOO_LONG = 503038, "单位详细地址过长"
    RZSJ_NOT_NULL = 503039, "入职时间不能为空"
    MI_NOT_NULL = 503040, "月收入不能为空"
    MIDYL = 503041, "月收入必须大于0"
    DWDH_NOT_NULL = 503042, "单位电话不能为空"
    DWDHIS_FALSE = 503043, "单位电话长度有误"

    NAME_NOT_NULL = 503044, "名字不能为空"
    IDNO_NOT_NULL = 503045, "身份证号不能为空"
    IDNOIS_FALSE = 503046, "身份证号位数不对"
    IDPIC_NOT_NULL = 503047, "身份证照片不能为空"
    IDUPIS_FALSE = 503048, "idCardUp链接格式有误"
    IDDOWNIS_FALSE = 503049, "idCardDown链接格式有误"
    IDHANDIS_FALSE = 503050, "idCardHand链接格式有误"

    CALLBACKURLIS_FALSE = 503051, "回调地址格式有误"
    CALLBACKURL_NOT_NULL = 503052, "回调地址不能为空"

    MACID_NOT_NULL = 503053, "设备号不能为空"
    MACID_TOO_LONG = 503054, "macId不能大于50位"
    JN_NOT_NULL = 503055, "经度不能为空"
    JN_TOO_LONG = 503056, "经度不能大于30位"
    WD_NOT_NULL = 503057, "纬度不能为空"
    WD_TOO_LONG = 503058, "纬度不能大于30位"

    AAMT_NOT_NULL = 503059, "申请分期金额不能为空"
    AAMTXY = 503060, "申请分期金额必须是大于等于500"
    TM_NOT_NULL = 503061, "申请分期期数不能为空"
    PI_NOT_NULL = 503062, "productId不能为空"
    TS_NOT_NULL = 503063, "第三方渠道标识不能为空"
    RI_NOT_NULL = 503064, "requestId不能为空"

    XL_NOT_NULL = 503065, "学历不能为空"
    XYK_NOT_NULL = 503066, "是否有信用卡信息不能为空"
    XYKJEGD = 503067, "信用卡金额过大"
    DZ_NOT_NULL = 503068, "地址不能为空"
    QQ_NOT_NULL = 503069, "QQ不能为空"
    QQ_TOO_LONG = 503070, "QQ过长"
    YX_NOT_NULL = 503071, "邮箱不能为空"
    YXIS_FALSE = 503072, "请填写正确格式的邮箱地址"
    PRO_NOT_NULL = 503073, "省不能为空"
    DZCDIS_FALSE = 503074, "地址长度有误"
    CITY_NOT_NULL = 503075, "城市不能为空"
    FT_NOT_NULL = 503076, "是否全日制信息不能为空"
    RX_NOT_NULL = 503077, "入学年份不能为空"
    YSHF_NOT_NULL = 503078, "月生活费不能为空"
    SNAME_NOT_NULL = 503079, "学校名称不能为空"
    SNAME_TOO_LONG = 503080, "学校名称过长"
    TXL_NOT_NULL = 503081, "通讯录不能为空"
    HY_NOT_NULL = 503082, "婚姻状况不能为空"
    HZ_NOT_NULL = 503083, "孩子信息不能为空"
    FZ_NOT_NULL = 503084, "房子信息不能为空"
    XLIS_FALSE = 503085, "学历有误"
    PHONE_NOT_NULL = 503086, "手机号码不能为空"
    PHONESIZEIS_FALSE = 503087, "手机长度不正确"
    YZM_NOT_NULL = 503088, "验证码不能为空"
    YZMSIZEIS_FALSE = 503089, "验证码长度错误"
    COOKIE_NOT_NULL = 503090, "cookie不能为空"
    PN_NOT_NULL = 503091, "商品名称不能为空"
    PN_TOO_LONG = 503092, "商品名称过长"
    BUSIID_NOT_NULL = 503093, "商户Id不能为空"
    BUSIID_TOO_LONG = 503094, "商户Id过长"
    BUSINAME_NOT_NULL = 503095, "商户名称不能为空"
    BUSINAME_TOO_LONG = 503096, "商户名称过长"
    PPNOTRIGHT = 503098, "商品金额必须在0到1000万之间"
    RELATIONSHIP_THREE = 503099, "联系人信息需要三条"
    RELATIONSHIPRULE = 503100, " 不符合联系人信息规则"
    PN_NOT_IN = 503101, "期数只有：3，6，9，12"
    GT_NOT_RIGHT = 503102, "GrabType不合法！"
    RI_FALSE = 503103, "requestId长度不合法！"
    DWCS_FALSE = 503104, "单位城市格式有误"
    RZSJ_FALSE = 503105, "入职时间格式有误"

    # ########### ############ ############ ############ ############ ########
    # 以下易美健异常错误码
    YMJ_PHONE_FORMAT = 504101, '手机号码不正确'
    YMJ_SYSTEM_ERROR = 504102, '第三方系统异常'
    YMJ_VCODE_ERROR = 504201, '验证码错误'
    YMJ_NO_CODE = 504202, '请先获取验证码'

    YMJ_ARG_ERROR = 505101, '参数不全'
    YMJ_UPLOAD_FAIL = 505102, '上传失败'
    YMJ_ARG_ERROR1 = 505201, '参数不能为空'
    YMJ_ID_FORMAT1 = 505202, '身份证格式不正确'
    YMJ_ARG_ERROR2 = 505203, '参数不合法'
    YMJ_PHONE_VERIFY = 505204, '手机号未认证'
    YMJ_CREDIT_ERROR = 505205, '信用卡格式错误'
    YMJ_CREDIT_ZHIMA = 505206, '信用卡与芝麻信用授权必选一个'
    YMJ_OPER_IMG = 505207, '运营商授权与认证图片必选一个'
    YMJ_NEED_HOSPITAL = 505208, '申请医院不存在'
    YMJ_PERIOD_NOT_SUPP = 505209, '申请期数不再支持范围内'
    YMJ_AMOUNT_NOT_SUPP = 505210, '申请金额不在支持范围内'
    YMJ_LACK_FILE = 505211, '缺少必填附件信息'
    YMJ_CON_PHONE = 505212, '直属亲属手机号格式错误'
    YMJ_COMP_PHONE = 505213, '工作电话格式错误'
    YMJ_COMP_CON_PHONE = 505214, '工作联系人手机号格式错误'
    YMJ_BANK_PHONE = 505215, '银行卡预留手机号格式错误'
    YMJ_SUPP_FIEL = 505216, '附件fileid不存在'
    YMJ_TRANSACTION = 505217, '已存在相同transaction_no的进件'
    YMJ_SELF_BANK = 505218, '只能使用本人银行卡'
    YMJ_AGE_ERROR = 505219, '年龄必须在18-55岁'
    YMJ_AMOUNT_ERROR = 505220, '申请金额不能小于3000'

    YMJ_WAIT_RESULT = 506101, '审核中未出结果'
    YMJ_BANK_FAIL = 506102, '银行卡验证失败'
    YMJ_ACCOUNT_FAIL = 506103, '个人账户开户失败'
    YMJ_THIRD_FAIL = 506104, '三方数据核查未通过'
    YMJ_DENY = 506105, '已拒绝'
    YMJ_PAYING_LOAN = 506106, '用户有未还完贷款'
    YMJ_NO_LOAN = 506151, '没有此工单'
    YMJ_CONT_NOT = 506201, '没有该借款单'
    YMJ_CONT_NOT_YEAT = 506202, '合同尚未生成'
    YMJ_SIGN_NOT = 506301, '没有该借款单'
    YMJ_SIGN_ERROR = 506302, '签约失败'
    YMJ_BILL_ARG = 506400, '参数错误'
    YMJ_NO_BILL = 506401, '没有账单'
    YMJ_TOKEN_ARG = 506500, '参数错误'
    YMJ_NO_USER = 506501, '用户不存在'
    YMJ_ARG_NOTNONE = 506601, '参数不能为空'
    YMJ_ID_FORMAT = 506602, '身份证格式不正确'
    YMJ_PHONE_ERROR = 506603, '手机号错误'
    YMJ_NAME_SYS = 506605, '用户姓名与系统已存在的姓名不一致'
    YMJ_IDCARD_SYS = 506606, '用户身份证与系统已存在的身份证不一致'
    YMJ_CANCEL_FAIL = 506802, '15天未验证的分期申请系统会自动取消 '
    YMJ_SYS_FAIL = 506999, '第三方系统异常'

    YMJ_SYS_FAIL1 = 507001, '渠道鉴权失败'
    YMJ_SYS_FAIL2 = 507002, '未传渠道验证信息'
    YMJ_SYS_FAIL3 = 507003, '未传params数据'
    YMJ_SYS_FAIL4 = 507004, '未传sign数据'
    YMJ_SYS_FAIL5 = 508001, '解密失败'
    YMJ_SYS_FAIL6 = 508002, 'sign验证失败'
    YMJ_SYS_FAIL7 = 508003, 'json串格式不合法'
    YMJ_SYS_FAIL8 = 508004, 'base64格式不合法'
    YMJ_SYS_FAIL9 = 508999, '参数解析未知错误'

    HAS_BOUGHT_SAME_INSURANCE = 510000, "已经为该美购购买过当前种类保险"

    # ########### ############ ############ ############ ############ ########
    # 以下海绵宝异常错误码
    HMB_SYS_ERROR = 509001, '系统错误'
    HMB_SIGN_ERROR = 509002, '无效的签名'
    HMB_APPID_ERROR = 509003, '无效的appId参数'
    HMB_MESSAGE_ERROR = 509004, '无效的应用信息'
    HMB_PARAM_ERROR = 509005, '无效的参数	'
    HMB_SERVICE_NAME = 509006, '无效的服务名'
    HMB_TIME_OUT = 509020, '请求超时'
    HMB_SYS_FAIL = 509021, '服务调用失败'

    HMB_PRODUCE_NULL = 509201, '保险产品代码不能为空'
    HMB_PRODUCE_ERROR = 509202, '保险产品不正确'
    HMB_COMPANY_NULL = 509203, '公司代码不能为空'
    HMB_COMPANY_ERROR = 509204, '公司不正确'
    HMB_POLICY_ID_ERROR = 509205, '投保人身份证不正确'
    HMB_POLICY_PHONE_ERROR = 509206, '投保人用户电话不存在'
    HMB_INSURED_ID_ERROR = 509207, '被保人身份证不正确'
    HMB_ORDER_NULL = 509208, '订单必填项不能为空'
    HMB_ORDER_REPEAT = 509209, '同一订单不能重复购买该保险产品'
    HMB_START_TIME_ERROR = 509210, '保险起始时间不正确'
    HMB_BUY_MAX_TIME = 509212, '同一被保险时间内购买次数超出最大值'
    HMB_NO_ORDER = 509220, '订单信息不存在'
    HMB_ORDER_ERROE = 509240, '投保失败'
    HMB_NO_POLICY = 509281, '保单信息不存在'

    # ########### ############ ############ ############ ############ ########
    # 以下有遁异常错误码
    UDUN_SYS_ERROR = 509399, '系统异常'
    UDUN_VALIDATE_ERROR = 509301, '验证失败'
    UDUN_SIGN_ERROR = 509302, '商户请求签名错误'
    UDUN_WAIT_ERROR = 509303, '商户请求地址未在白名单'
    UDUN_MESSAGE_ERROR = 509304, '请求报文格式错误'
    UDUN_PARAM_MISS = 509305, '参数缺失'
    UDUN_USER_ERROR = 509306, '商户不存在'
    UDUN_PRODUCE_ERROR = 509307, '商户未开通此产品权限'
    UDUN_CONFIG_ERROR = 509308, '产品配置异常'
    UDUN_PARAM_ERROR = 509309, '参数有误'
    UDUN_ORDER_ID_ERROR = 509310, '外部订单号重复'
    UDUN_PRODUCE_CODE_ERROR = 509311, '外部订单号重复'
    UDUN_ACCOUNT_ERROR = 509312, '商户资金账户状态异常'

    # ########### ############ ############ ############ ############ ########
    # 以下为博金贷异常错误码
    BJD_SIGN_FAIL = 509320, '验签失败'
    BJD_ERROR = 509321, '操作失败'
    BJD_PHONE_ERROR = 509322, '手机号格式不正确'
    BJD_FORBID_APPLY = 509323, '您还有还款中的订单，请完成还款后，再申请'
    BJD_ERROR_PRODUCTTYPE = 509324, '产品类别参数不正确'
    BJD_BANKCARDNO_NULL = 509325, '银行卡号为空'
    BJD_LESS_LOWEST = 509326, '申请金额不能低于最低金额'
    BJD_MORE_HIGHEST = 509327, '申请金额不能高于最高金额'
    BJD_PERSON_UNFIND = 509328, '用户信息不存在'
    BJD_AUTHEN_UNFIND = 509329, '此认证项未对接，请仔细检查autType值是否正确'
    BJD_AUTHEN_ING = 509330, '该认证认证中，无需重复操作'
    BJD_AUTHEN_SUCCESS = 509331, '该认证已成功'
    BJD_AUTHEN_FAIL = 509332, '该认证已失败'
    BJD_ORDER_UNFIND = 509333, '该订单号不存在'
    BJD_AUTHEN_UNDO = 509334, '必要认证未完成'
    BJD_FORBID_CONFIRM = 509335, '订单还未审核通过，不允许确认分期'
    BJD_CONFIRM_ALREADY = 509336, '该订单已确认分期'
    BJD_ORDER_CANCEL = 509337, '订单已取消'
    BJD_ORDER_OTHER = 509338, '该订单处于异常状态'

    # ########### ############ ############ ############ ############ ########
    # 以下为闪银异常错误码

    SY_SYSTEM_ERROR = 509340, '请求系统异常,请稍后再试'
    SY_SIGN_ERROR = 509341, '验签失败'
    SY_PARAM_ERROR = 509342, '参数校验错误'
    SY_USER_UNFIND = 509343, '用户不存在'
    SY_USER_MESSAGE_LOSE = 509344, '用户信息缺失'
    SY_USER_ORDER_UNFIND = 509345, '订单不存在'
    SY_HOSPITAL_UNFIND = 509346, '医院未录入或通道已关闭'
    SY_YUNYIN_UNAUT = 509347, '未进行运营商授权或授权未通过'
    SY_ZHIMA_UNAUT = 509348, '未进行芝麻信用授权或授权未通过'
    SY_ORDER_REPEAT = 509349, '订单号重复'
    SY_BANK_UNFIND = 509350, '无绑卡信息'
    SY_APPLY_FAIL = 509351, '进件申请失败'
    SY_ORDER_ERROR = 509352, '订单状态异常'
    SY_BANK_ERROR = 509353, '绑卡失败'
    SY_PLATFORM_UNFIND = 509354, '商户平台未注册或已关闭'
    SY_APPLY_FAIL_HAS_ORDER = 509355, '进件申请失败,已有待审核记录'
    SY_APLLY_MORE_TIME = 509356, '提交频率过高,请稍后再试'
