# -*- coding: utf-8 -*-
from __future__ import unicode_literals, absolute_import

from ..utils.enum import Enum, unique


@unique
class GOODS_TYPE(Enum):
    POINT = 'point', u'美分'
    COUPON = 'coupon', u'美券'
    REAL = 'real', u'实物'
    THSJOIN = 'thsjoin', u'谢谢参与'
    ONEAGAIN = 'oneagain', u'再抽一次'


@unique
class ACTIVITY_TYPE(Enum):
    LOTTERY = 'lottery', u'抽奖'
    EXCHANGE = 'exchange', u'兑换'


@unique
class GOODS_CLAIM_STATUS(Enum):
    CAN_CLAIM = 1, '可兑换'
    CANNOT = 2, '已抢光'
    ALREADY_CLAIM = 3, '已兑换'


@unique
class GOODS_CLAIM_RESULT(Enum):
    SUCCESS = 1, '兑换成功'
    CANNOT = 2, '已抢光'
    ALREADY_CLAIM = 3, '已兑换'
    LEVEL_NOT_ENOUGH = 4, '等级不足'
    POINT_NOT_ENOUGH = 5, '美分不足'


@unique
class LOTTERY_RESULT(Enum):
    POINT_NOT_ENOUGH = 1, '美分不足'
    FREQUENT_LIMIT = 2, '达到上限'
    NOTHING = 3, '谢谢参与'
    TRY_AGAIN = 4, '再抽一次'
    POINT = 5, '抽到美分'
    COUPON = 6, '抽到美券'
    REAL = 7, '抽到实物'

@unique
class POINT_ACTIVITY_RESULT_TYPE(Enum):
    POINT = 1, '美分'
    COUPON = 2, '美券'
    REAL = 3, '实物'
    NOTHING = 4, '谢谢参与'


@unique
class SIGN_ACTIVITY_EXCHANGE_GOODS_TYPE(int, Enum):
    SUCCESS = (1, u"兑换成功")
    CANNOT = (2, u"已抢光")
    LOW_STOCKS = (3, u"库存不足")
    OUT_NUMBER = (4, u"兑换数量过大，超出可兑换值")
    UN_STANDARD = (5, u"对不起，未到兑换门槛")
