# coding=utf-8
# create by oldman at 17/3/22

from gm_types.utils.enum import Enum, unique


@unique
class ERROR(int, Enum):
    """
    分配错误码时请参考、维护代码库根目录下的文件 ERROR_CODE_REGION.txt

        !!! 字符前面一定要记得加 u  !!!!!
        700000 ~ 700999
    """
    NOTFOUND = (700001, u'资源不存在！')

    # 广告配置相关
    TIME_HAS_BEEN_SET = (7000002, u'广告时间冲突')
    ADVERPRODUCT_HAS_ORDER = (7000005, u'广告商品已有订单')

    # account 相关
    NO_PERMISSION = (7001000, u'没有权限')
    STATUS_ILLEGAL = (7001001, u'状态错误')
    NO_PAY_ID = (7001002, u'无此支付订单')
    PARAM_ERROR = (7001003, u'参数错误')

    # 下单相关
    PAY_ERROR = (7002000, u'购买错误')
    PAY_CITY_SOLD = (7002001, u'地域已被售出')
    PAY_KEYWORD_SOLD = (7002002, u'关键词已被售出')
    PAY_SERVICE_BTN_SOLD = (7002003, u'按钮已被售出')

    PAY_ADVERTISE_OFFLINE = (7002004, u'该商品已经下线了')
    PAY_ACCOUNT_LACK = (7002005, u'账号余额不足')
    PAY_ADTIME_DEACTIVATIVE = (7002006, u'选择投放排期已下线，请重新选购')
    PAY_KEYWORD_EMPTY = (7002007, u'请输入购买的关键词')
    PAY_OTHERSETTING_EMPTY = (7002008, u'请选择要购买的按钮')
    PAY_CITY_EMPTY = (7002009, u'请选择区域')
    PAY_NOT_RESIDUE = (7002010, u'当前剩余城市不可购买')
    PAY_RESIDUE_SOLD = (7002011, u'当前剩余城市已售出')
    PAY_PRICE_UPDATED = (7002012, u'价格变更了，请刷新页面重新下单')
    PAY_ACCOUNT_STATUE_ERROR = (7002013, u'您账号已被冻结，请联系商务')
    PAY_CITY_ERROR = (7002014, u'选择城市信息不在配置当中')
    PAY_SPECIAL_ERROR = (7002015, u'当前专题已售出')
    PAY_ADBDLIST_DEACTIVATIVE = (7002016, u'选择投放榜单已下线，请重新选购')
    PAY_SPECIAL_DEACTIVATIVE = (7002017, u'选择投放专题已下线，请重新选购')
    PAY_NOT_BUY = (7002018, u'请勿购买同一排期、同一投放地域不同位置')
    PAY_SAME_PROVINCE = (7002019, u'请勿同时购买某省份和此省份下任何城市')

    # Material
    MATERIAL_NEED_SERVICE = (7003001, u'请提交美购物料')
    MATERIAL_NEED_DOCTOR = (7003002, u'请提交医生物料')
    MATERIAL_SUBMITED = (7003003, u'您已经提交过了')
    MATERIAL_NEED_HOSPITAL = (7003004, u'请提交医院物料')

    # discountscheme
    DISCOUNT_SCHEME_IS_ACTIVITY = (7004001, u'打折方案已经生效！')
    DISCOUNT_SCHEME_CONFLICT = (7004002, u'部分商品在本时间段，已经在其他打折方案中了，不能再次添加咯。')

    # cashbackratio
    CASHBACK_RATIO_RANGE_DEFEAT = (7005001, u'区间有冲突！')
    CASHBACK_RATIO_RANGE_START_GT_END = (7005002, u'区间开始值必须小于结束值！')

    # cpc_whitelist
    HAS_ACCREDIT = (7006001, u'该商户存在尚未结束的相同授权功能类型的记录')
    ERROR_MERCHANT = (7006002, u'此商户不存在')

    # cpc
    HAS_PROMOTE = (7007001, u'已经存在该美购推广')
    HAS_PROMOTE_COMMUNITY = (7007002, u'已经存在该日记推广')
    HAS_PROMOTE_DOCTOR = (7007003, u'已经存在该医生的推广')
