#!/usr/bin/env python
# -*- coding: utf-8 -*-


from __future__ import unicode_literals, absolute_import
from ..utils.enum import Enum, unique


class COMMUNITY_DISPERSE_SORT_TYPE(Enum):
    """
    社区数据散排类型
    """
    LIVE = (1, u"直播")
    ACTIVITY = (2, u"免费招募")
    LIVE_NOTICE = (3, u"直播预告")
    DOCTOR_VIDEO_POST = (4, u"医生视频帖")
    DOCTOR_TEXT_POST = (5, u"医生文本帖")
    ARTICLE = (6, u"专栏")


class MEDIA_IMAGE_URL_SOURCE(Enum):
    """
    图片地址来源
    """
    CREATE = ("1", "创建")
    RICH_TEXT = ("2", "富文本")
    HEAD = ("3", "头图")


@unique
class COMMON_REPLY_TYPE(Enum):
    ANSWER = ('1', '回答')
    TOPIC = ('2', '日记帖')
    ARTICLE = ('3', '专栏')
    TRACTATE = ('4', '用户帖')
    QUALITY = ('5', '回答异行评论')
    DOCTOR_TRACTATE = ('6', '医生帖')


@unique
class ATTENTION_NOTIFY_TYPE(Enum):
    """
    关注用户的动态 类型
    """
    UNDEFINED = ('1', '全部类型')
    QUESTION = ('2', '问题')
    DIARY = ('3', '日记本')
    TRACTATE = ('4', '帖子（用户）')
    LIVE = ('5', '直播')


@unique
class VIDEO_IMMERSE_DATA_TYPE(Enum):
    """
    视频沉浸式，数据类型
    """
    DIARY = ("diary", "日记本")
    TRACTATE = ("user_post", "用户帖")
    QUESTION = ("question", "问题")
    ANSWER = ("answer", "回答")


@unique
class VIDEO_IMMERSE_FROM_TYPE(Enum):
    """
    视频沉浸式，入口来源
    """
    INDEX = ("index", "首页")
    SEARCH = ("search", "搜索")
    CONTENT_AGGRE = ("content_aggre", "内容聚合")
    CATEGORY_AGGRE = ("category_aggre", "品类聚合")
    PLASTIC_FEEDS = ("plastic_feeds", "模拟整形feeds")


class VOTE_TASK_TYPE(Enum):
    """
    点赞灌水业务类型
    """
    TOPIC = ('1', '日记帖')
    TRACTATE = ('2', '用户帖')
    QUESTION = ('3', '问题')
    DIARY = ('4', '日记本')


class IMAGE_TYPE(Enum):
    """
    图片类型
    """
    OTHER = (1, '其他图片')
    GIF = (2, "GIF动图")
    JPG = (3, "JPG图片")
    JPEG = (4, "JPEG图片")
    PNG = (5, "PNG图片")
    BMP = (6, "BMP位图")
    WEBP = (7, "WEBP图片类型")
    TIFF = (8, "TIFF图片类型")


class TOPIC_PLATFORM_TYPE(Enum):
    """
    帖子来源类型
    """
    DEFAULT = (0, '默认')
    XIAOHONGSHU = (1, '小红书')
    WEIBO = (2, '微博')


class PUSH_ACTION_TYPE(Enum):
    """
    推送行为、具体类型划分
    """
    ANSWER_RECV_VOTE = (1, "回答被点赞")
    ANSWER_RECV_REPLY = (2, "回答下发评论")
    ANSWER_CREATE_PUSH_TO_QUESTION_AUTHOR = (3, "创建回答, 推送给问题作者")
    ANSWER_CREATE_PUSH_TO_FANS = (4, "创建回答, 推送给粉丝")

    USER_RECV_FOLLOW = (11, "用户加关注")


class INTEREST_CONTENT_TYPE(Enum):
    """
    感兴趣内容类型
    """
    DIARY = (1, '日记本')
    TOPIC = (2, '日记帖')
    QUESTION = (3, '问题')
    ANSWER = (4, '回答')
    TRACTATE = (5, '用户帖')
    SERVICE = (6, '美购')
    COUPON = (7, '美券')
    MARK = (8, '打卡内容卡片')


class DELAY_PUSH_TYPE(Enum):
    """
    防干扰推送
    """
    INTEREST = (1, '感兴趣')
    ANSWER_REPLY_VOTE = (2, '回答评论点赞')


class QUALITY_QUESTION_CLASSIFY_TYPE(Enum):
    """
    追问问题类型
    """
    COMMON = (1, '普通问题')
    TAG = (2, '标签绑定问题')
    TAG_GROUP = (3, '标签大组绑定问题')


class GROUP_TOPIC_SORT_TYPE(Enum):
    """小组、话题排序规则"""

    ALL = (1, '全部')
    DYNAMIC = (2, '动态规则')


class QUICK_SEARCH_CONTENT_DIVISION(Enum):
    """
    文本内部快速搜索内容划分
    """
    TOPIC = ("topic", u"日记帖")
    QUESTION = ("question", u"问题")
    ANSWER = ("answer", u"回答")
    TRACTATE = ("tractate", u"用户帖")
    ARTICLE = ("article", u"专栏")


class FAKE_REPLY_BAND_TYPE(Enum):
    """
    灌水评论配置类型
    """
    TAG = (1, '标签绑定')
    TAG_GROUP = (2, '标签大组绑定')
    # TAG_ATTR = (3, '属性标签')  # v7.29.0标签调整，注释属性标签


class COMMUNITY_CONTENT_TYPE(Enum):
    """社区内容类型"""
    TOPIC = ('topic', '日记帖')
    ANSWER = ('answer', '回答')
    TRACTATE = ('tractate', '用户帖')


class FAKE_TYPE(Enum):
    """灌水类型"""
    COMMENT = ('comment', '评论')
    VOTE = ('vote', '点赞')
    QUALITY = ('quality', '追问')
    FOLLOW = ('follow', '关注')


class COMMUNITY_OTHER_ACTIVITY_CREATION_TYPES(Enum):
    """
    社区其他活动创建内容类型
    """
    DAILY_CHECK = ("daily_check", "打卡")
    VARIETY_SHOW_YOUNG = ("variety_show_young", "选秀节目(少年之名)打榜活动")
    GROUP_DETAIL = ("group", "普通小组详情页")
    GROUP_TOPIC_DETAIL = ("group_topic", "普通小组话题详情页")


class TRACATE_VIDEO_URL_SOURCE(Enum):
    """
    帖子视频地址来源
    """
    HEAD = ("1", "头部")
    RICH_TEXT = ("2", "富文本")


class NOTICATION_LIST_CATEGORY(Enum):
    """
    消息列表类型
    """
    VOTE = (0, '赞列表')
    FAVOR = (1, '收藏列表')