# -*- coding: utf-8 -*-
from crawler.gm_types.gm_types.utils.enum import Enum, unique


@unique
class IMG_TYPE(Enum):
    BANNER = (1, 'Banner')
    BODYPART = (2, 'BodyPart')
    DIARY = (3, '日记本')
    CAMPAIGNIMAGELINK = (5, '活动图片链接')
    CONSULTWIKI = (6, '咨询百科')
    DOCTOR = (7, '医生')
    FEEDBACKCATEGORY = (8, '反馈类型')
    FEEDBACKIMAGE = (9, '用户反馈上传的图片')
    GREETINGPOPUP = (10, '开屏页和首页提醒')
    HOSPITAL = (11, '医院')
    ITEMWIKI = (12, '整形项目（wiki）')
    PRIVATECONVERSATION = (13, '私信对话')
    ORGANIZATIONIMAGE = (14, '机构图片')
    PREOPERATIONIMAGE = (15, '术前图')
    RECOMMENDAPP = (16, '精品应用')
    WEBSLIDE = (17, 'web 轮播图')
    BULLETIN = (18, '公告(医生版)')
    SERVICE = (19, '美购')
    SERVICEACTIVITY = (20, '美购活动')
    SHARE = (21, '分享')
    SLIDE = (22, '轮播图')
    SMALLIMAGE = (23, '首页小图(单排横滑模版)')
    SPECIAL = (24, '专题')
    TAG = (25, 'TAG')
    TOPIC = (26, '帖子')
    TOPICREPLY = (27, '帖子回复')
    TOPICIMAGE = (28, '帖子图片')
    USEREXTRA = (29, '用户')
    POST = (30, '文章(医生版)')
    ARTICLE = (31, '所长推荐/扒扒扒')
    DOCTORREGISTER = (32, '医生注册')
    HOSPITALCAPTURE = (33, '医院（采集）')
    HOMEPOPUP = (34, '首页弹窗(医生)')
    HOMESLIDE = (35, '首页轮播图(医生)')
    ZEUS_STAFF_PROTRAIT = (36, 'ZEUS员工头像')
    CIRCLEBANNER = (37, '圈子圈子横幅')
    CAMPAIGNBANNER = (38, '活动圈子活动banner图')
    CIRCLEICON = (39, '圈子图标')
    ADVERTISE = (40, '广告位')
    INSTALLMENT = (41, '分期')
    BANK = (42, '银行logo')
    AUDIO = (43, '录音音频')
    ZHIBO = (44, '直播')

    # 广告系统相关
    ADCOVERMAP = (45, '广告封面图')
    TRADEIMAGE = (46, '交易图片')

    SERVICE_COMMENT = (47, '美购评价')
    APOLLO = (48, '分销')
    SERVICE_WATERMARK = (49, '促销标签')

    PLUTUS_QR = (50, '分期二维码')
    PLUTUS_PDF= (51, '金融pdf')

    POLYMER = (52, '聚合页')
    SERVICEHOME = (53, '美购主页')
    CATEGORY_POLYMER = (54, '品类聚合页')
    ICON = (55, '我的页面icon')

    # 无类型
    WATERMARK = (98, '带水印')
    NOWATERMARK = (99, '不带水印')

# domain add http/https, when change the http or https, remember to modify testcase
qiniu_no_watermark = {
    'domain': 'https://heras.igengmei.com',
    'bucket': 'hera',
}

qiniu_no_watermark_platform = {
    'qiniu': qiniu_no_watermark
}

qiniu_watermark = {
    'domain': 'https://pic.igengmei.com',
    'bucket': 'wanmeizhensuo',
}

qiniu_video = {
    'domain': 'http://video-static.igengmei.com',
    'bucket': 'video',
}

qiniu_watermark_platform = {
    'qiniu': qiniu_watermark
}

qiniu_audio_platform = {
    'qiniu': {
        'domain': 'http://phonerecord.private.igengmei.com',
        'bucket': 'phone-record',
    }
}

qiniu_installment_platform = {
    'qiniu': {
        'domain': 'http://idcard.private.igengmei.com',
        'bucket': 'id-card',
    }
}

image_type = {
    IMG_TYPE.WATERMARK: {
        'prefix': '',
        'platform': qiniu_watermark_platform,
    },
    IMG_TYPE.NOWATERMARK: {
        'prefix': '',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.BANNER: {
        'prefix': 'banner',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.ICON: {
        'prefix': '',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.BODYPART: {
        'prefix': 'bodypart',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.DIARY: {
        'prefix': 'diary',
        'platform': qiniu_watermark_platform,
    },
    IMG_TYPE.CAMPAIGNIMAGELINK: {
        'prefix': 'campaignimagelink',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.CONSULTWIKI: {
        'prefix': 'consultwiki',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.DOCTOR: {
        'prefix': 'doctor',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.FEEDBACKCATEGORY: {
        'prefix': 'feedbackcategory',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.FEEDBACKIMAGE: {
        'prefix': 'feedbackimage',
        'platform': qiniu_watermark_platform,
    },
    IMG_TYPE.GREETINGPOPUP: {
        'prefix': 'greetingpopup',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.HOSPITAL: {
        'prefix': 'hospital',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.ITEMWIKI: {
        'prefix': 'itemwiki',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.PRIVATECONVERSATION: {
        'prefix': 'privateconversation',
        'platform': qiniu_watermark_platform,
    },
    IMG_TYPE.ORGANIZATIONIMAGE: {
        'prefix': 'organizationimage',
        'platform': qiniu_watermark_platform,
    },
    IMG_TYPE.PREOPERATIONIMAGE: {
        'prefix': 'preoperationimage',
        'platform': qiniu_watermark_platform,
    },
    IMG_TYPE.RECOMMENDAPP: {
        'prefix': 'recommendapp',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.WEBSLIDE: {
        'prefix': 'webslide',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.BULLETIN: {
        'prefix': 'bulletin',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.SERVICE: {
        'prefix': 'service',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.SERVICEACTIVITY: {
        'prefix': 'serviceactivity',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.SHARE: {
        'prefix': 'share',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.SLIDE: {
        'prefix': 'slide',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.SMALLIMAGE: {
        'prefix': 'smallimage',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.SPECIAL: {
        'prefix': 'special',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.TAG: {
        'prefix': 'tag',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.TOPIC: {
        'prefix': 'topic',
        'platform': qiniu_watermark_platform,
    },
    IMG_TYPE.TOPICREPLY: {
        'prefix': 'topicreply',
        'platform': qiniu_watermark_platform,
    },
    IMG_TYPE.TOPICIMAGE: {
        'prefix': 'topicimage',
        'platform': qiniu_watermark_platform,
    },
    IMG_TYPE.USEREXTRA: {
        'prefix': 'userextra',
        'platform': qiniu_watermark_platform,
    },
    IMG_TYPE.POST: {
        'prefix': 'consultwiki',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.ARTICLE: {
        'prefix': 'article',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.DOCTORREGISTER: {
        'prefix': 'doctorregister',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.HOSPITALCAPTURE: {
        'prefix': 'hospitalcapture',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.HOMEPOPUP: {
        'prefix': 'homepopup',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.HOMESLIDE: {
        'prefix': 'homeslide',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.ZEUS_STAFF_PROTRAIT: {
        'prefix': 'zeusstaffprotrait',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.ADVERTISE: {
        'prefix': 'advertise',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.CIRCLEBANNER: {
        'prefix': 'circlebanner',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.CIRCLEICON: {
        'prefix': 'circleicon',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.CAMPAIGNBANNER: {
        'prefix': 'campaignbanner',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.INSTALLMENT: {
        'prefix': 'installment',
        'platform': qiniu_installment_platform,
    },
    IMG_TYPE.BANK: {
        'prefix': 'bank',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.AUDIO: {
        'prefix': '',
        'platform': qiniu_audio_platform,
    },
    IMG_TYPE.ZHIBO: {
        'prefix': '',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.ADCOVERMAP: {
        'prefix': 'artemis',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.TRADEIMAGE: {
        'prefix': 'artemis',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.SERVICE_COMMENT: {
        'prefix': 'service_comment',
        'platform': qiniu_watermark_platform,
    },
    IMG_TYPE.APOLLO: {
        'prefix': 'apollo',
        'platform': qiniu_installment_platform,
    },
    IMG_TYPE.SERVICE_WATERMARK: {
        'prefix': 'service_watermark',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.PLUTUS_QR: {
        'prefix': 'plutus_qr',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.PLUTUS_PDF: {
        'prefix': 'plutus_pdf',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.POLYMER: {
        'prefix': 'polymer',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.SERVICEHOME: {
        'prefix': 'service_home',
        'platform': qiniu_no_watermark_platform,
    },
    IMG_TYPE.CATEGORY_POLYMER: {
        'prefix': 'category_polymer',
        'platform': qiniu_no_watermark_platform,
    },
}


class GmImageManager(object):
    def __init__(self, img_type):
        assert img_type in IMG_TYPE
        self.img_type = img_type

    def get_domain(self, platform='qiniu'):
        # NOTE: 这里返回结果变为带http/https前缀的domain
        return image_type.get(self.img_type)['platform'].get(platform)['domain']

    def get_bucket(self, platform='qiniu'):
        return image_type.get(self.img_type)['platform'].get(platform)['bucket']

    def get_prefix(self):
        return image_type.get(self.img_type)['prefix']
