# -*- coding: utf-8 -*-
"""
Created on Tue May 28 15:32:04 2019

@author: zhouyujiang

用redis 计算周增量
本周减去上周数据
"""


import logging
import datetime
import argparse
import sys
import re
import task_stats
from func_cal_NI_by_redis import func_cal_increment
from func_cal_NI_by_redis import func_cal_new_released_NI
from func_cal_weekly_net_inc import parse_week_param
from func_find_week_num import find_week_belongs_to
from func_update_weekly_datapool import define_doc_type
from func_find_week_num import find_first_day_for_given_start_weekday

def get_weekly_doc_type_name_by_week_str(week_str):
    weekly_doc_type = 'daily-url-%s' % week_str
    parse_week = parse_week_param(weekly_doc_type)
    if parse_week is None:
        print('Illegal input week_str: %s' % week_str)
        return None
    else:
        return weekly_doc_type

week_day_start = 1
todayT = datetime.datetime.today()

parser = argparse.ArgumentParser()
parser.add_argument('-w', '--week_str', type=str, default=None, help=('like 2018_w25_s1'))
parser.add_argument('-p', '--platform_list',  action='append', default=None)
parser.add_argument('-t', '--ctype',
                    help=('will decide cal new_released or obversded,like N or O'))

args = parser.parse_args()


week_day_start = 1

def week_start_day(week_year, week_no,week_day, week_day_start=1):
    year_week_start = find_first_day_for_given_start_weekday(week_year, week_day_start)
    week_start = year_week_start + datetime.timedelta(days=(week_no-1)*7)
    return week_start
    
if args.ctype == None:
    new_released = True
    obversed = True
elif args.ctype != None:
    if args.ctype == 'O':
        new_released = False
        obversed = True 
    if args.ctype == 'N':
        new_released = True
        obversed = False
    else:
        print('error in --ctype')
        
if args.week_str is None:
    seven_days_ago_T = todayT - datetime.timedelta(days=7)
    week_year, week_no, week_day = find_week_belongs_to(seven_days_ago_T,
                                                        week_day_start)

    week_start = week_start_day(week_year,week_no,week_day)
    nowT_qingbo = week_start + datetime.timedelta(days=7)
    nowT_feihua = week_start + datetime.timedelta(days=6)
    weekly_doc_type_name = define_doc_type(week_year, week_no,
                                           week_day_start=week_day_start)
    
    last_seven_days_ago_T = todayT - datetime.timedelta(days=14)
    lweek_year, lweek_no, lweek_day = find_week_belongs_to(last_seven_days_ago_T,
                                                        week_day_start)

    last_weekly_doc_type_name = define_doc_type(lweek_year, lweek_no,
                                           week_day_start=week_day_start)
    
else:
    weekly_doc_type_name = get_weekly_doc_type_name_by_week_str(args.week_str)
    p = re.compile(r'\d+')
    week_mess = p.findall(args.week_str)
    week_year = int(week_mess[0])
    week_no = int(week_mess[1])
    week_day = int(week_mess[2])
    week_start = week_start_day(week_year,week_no,week_day)
    nowT_qingbo = week_start + datetime.timedelta(days=7)
    nowT_feihua = week_start + datetime.timedelta(days=6)
    if weekly_doc_type_name is None:
        print('Failed to parse week info from input argument: %s, '
              'program exits.' % args.week_str)
        sys.exit('cal_weekly_net_inc_auto_task - '
                 'Program exits dure to illegal input week_str')
    else:
        pass
    last_seven_days_ago_T = week_start - datetime.timedelta(days=7)
    lweek_year, lweek_no, lweek_day = find_week_belongs_to(last_seven_days_ago_T,
                                                        week_day_start)

    last_weekly_doc_type_name = define_doc_type(lweek_year, lweek_no,
                                           week_day_start=week_day_start)


dayT = datetime.datetime(nowT_qingbo.year, nowT_qingbo.month, nowT_qingbo.day)
day_str_tody = dayT.isoformat()[:10]
dayT_ye = datetime.datetime(nowT_feihua.year, nowT_feihua.month, nowT_feihua.day)
day_str_ye = dayT_ye.isoformat()[:10]
time_of_processed_data_T = datetime.datetime(nowT_qingbo.year, nowT_qingbo.month, nowT_qingbo.day)
index = 'short-video-weekly'
pre_task_names = {
    'write_qingbo_TK_ATU_data_from_ftp_daily_task':
        {'days_str_of_proc_data': day_str_tody},
    'write_fh_data_from_ftp_call_func_daily_task00':
        {'days_str_of_proc_data': day_str_ye},
    }
print (pre_task_names, weekly_doc_type_name)


logger_name = 'calculate_weekly_MNI_by_redis'
logger = logging.getLogger(logger_name)
logger.setLevel(logging.DEBUG)
# create handler
path = ('/home/hanye/project_data/Python/Projects/proj-short-videos/'
        'write-data-into-es/log/')

log_fn = ('calculate_MNI_for_%s_by_redis_on_%s_log'
          % (weekly_doc_type_name, datetime.datetime.now().isoformat().replace(':', '-')))

log_file = open(path + log_fn, 'w')
print('start: \nthis-doc-type:', weekly_doc_type_name, '\nlast_doctype:',
      last_weekly_doc_type_name, '\nthis-index:', index, '\nlast-index:', index)
print('wiil cal MNI on index: %s - %s'%(weekly_doc_type_name, datetime.datetime.now()), file=log_file)
print('cal index : %s  %s'%(weekly_doc_type_name, datetime.datetime.now()), file=log_file)
print('last  index need write into redis : %s  %s'%(last_weekly_doc_type_name, datetime.datetime.now()), file=log_file)



ob_release_time_end_dt = week_start - datetime.timedelta(1)
ob_release_time_start_dt = ob_release_time_end_dt -  datetime.timedelta(30)
ob_release_time_end_ts = int(datetime.datetime.timestamp(
                                                         datetime.datetime(ob_release_time_end_dt.year,
                                                                  ob_release_time_end_dt.month,
                                                                  ob_release_time_end_dt.day))*1000)
ob_release_time_start_ts = int(datetime.datetime.timestamp(datetime.datetime(ob_release_time_start_dt.year,
                                                                  ob_release_time_start_dt.month,
                                                                  ob_release_time_start_dt.day))*1000)
new_release_end_d =  week_start + datetime.timedelta(6)
new_release_end_dt = datetime.datetime(new_release_end_d.year,
                                       new_release_end_d.month,
                                       new_release_end_d.day)
task_start_ts = int(todayT.timestamp()*1e3) 

task_stats.record_task_stats(
    task_name='calculate_weekly_net_inc_by_redis_weekly_task',
    program_file_name='calculate_weekly_net_inc_by_redis_weekly_task.py',
    task_freq='weekly',
    start_time=task_start_ts,
    time_of_processed_data=task_start_ts,
    with_task_description=False
    )
# 计算obversed 
if obversed:
    print('cal ob')
    print('will cal obversed *******',datetime.datetime.now(), file=log_file)
    func_cal_increment(index_last=index, doc_type_last=last_weekly_doc_type_name, 
               cal_type='W',index_now=index, doc_type_now=weekly_doc_type_name, 
               release_time_st_last=ob_release_time_start_ts, release_time_et_last=ob_release_time_end_ts, 
               redis_db=10, log_f=log_file, limit_platform=args.platform_list)

#2计算新发布的
if new_released:
    print('cal new')
    nw_release_time_end_dt = new_release_end_dt
    nw_release_time_start_dt = datetime.datetime(ob_release_time_end_dt.year,
                                                 ob_release_time_end_dt.month,
                                                 ob_release_time_end_dt.day)
    nw_release_time_end_ts = int(datetime.datetime.timestamp(nw_release_time_end_dt)*1000)
    nw_release_time_start_ts = int(datetime.datetime.timestamp(nw_release_time_start_dt)*1000)
    print('will cal new_released *******',datetime.datetime.now(), file=log_file)
    func_cal_new_released_NI(cal_type='W',index_now=index, doc_type_now=weekly_doc_type_name,
                             release_time_st_now=nw_release_time_start_ts,
                             release_time_et_now=nw_release_time_end_ts,
                             log_f=log_file, limit_platform=args.platform_list)




print('All done.', datetime.datetime.now(), file=log_file)

# write task status into task-stats index when ends
task_end_ts = int(datetime.datetime.now().timestamp()*1e3)
task_stats.record_task_stats(
    task_name='calculate_weekly_net_inc_by_redis_weekly_task',
    program_file_name='calculate_weekly_net_inc_by_redis_weekly_task.py',
    task_freq='monthly',
    start_time=task_start_ts,
    time_of_processed_data=task_start_ts,
    end_time=task_end_ts,
    is_done=True,
    task_stats='Done',
    with_task_description=False
    )