# -*- coding: utf-8 -*-
"""
Created on Wed Apr 11 13:08:16 2018

@author: hanye
"""

import os, sys, datetime
import ftplib
import re


def transfer_from_ftp(filename_pattern, ftp_path, local_path,
                      f_log=sys.stdout,
                      host='192.168.17.12', user='ftpadmin', passwd='hy_csm_16'
                      ):
    ccr_ftp=ftplib.FTP(host=host, user=user, passwd=passwd)
    ccr_ftp.set_pasv(True)
    ccr_ftp.encoding='utf-8'
    
    target_dir=ftp_path
    ccr_ftp.cwd(target_dir)
    ftp_file_Lst=ccr_ftp.nlst()
    
    transf_target_file_Lst=[]
    for fn in ftp_file_Lst:
        rematch=re.fullmatch(filename_pattern, fn)
        if rematch!=None:
            transf_target_file_Lst.append(fn) 
    if len(transf_target_file_Lst)==0:
        print('There is no file matches given pattern', filename_pattern,
              datetime.datetime.now(), file=f_log)
        return None
    else:
        os.chdir(local_path)
        print('Transfering %d files ...' % len(transf_target_file_Lst),
              datetime.datetime.now(), file=f_log)
        trfile_c=0
        for retr_fn in transf_target_file_Lst:
            trfile_c+=1
            print('[%d/%d] retrieving %s ...' % (trfile_c, len(transf_target_file_Lst), retr_fn),
                  datetime.datetime.now(), file=f_log)
            with open(retr_fn, 'wb') as local_f:
                ccr_ftp.retrbinary('RETR %s' % retr_fn, local_f.write)
            print('[%d/%d]' % (trfile_c, len(transf_target_file_Lst)), retr_fn, 'done.',
                  datetime.datetime.now(), file=f_log)
        return transf_target_file_Lst


#
if __name__=='__main__':
    local_path=r'D:\CSM\Docs\Projects\短视频\code\write-data-into-es\test\FHTech\fhtech-ftp-files'
    pattern='[MTP]_2018-04-09_[NU]\\w{0,2}\\.zip'
    trf=transfer_from_ftp(pattern, 'FHTech', local_path)
    