# -*- coding: utf-8 -*-
from .utils.enum import Enum, unique


@unique
class NETEASEIM_SIGNAL_INVITE_TYPE(Enum):
    """
        网易云信信令服务，邀请加入房间信息的类型定义。
        由于客户端/Web端等多端可能同时在线，但是部分邀请消息只有部分端才需要处理，因此定义这个类型
        所有邀请的Ext信息都是一个JSON，一定会带有一个type字段，type里面的值由这个枚举定义。
        接收方先根据type判断自己能否处理，再按照对应的JSON格式进行动态解析。
    """
    CONSULTATION_COUNSEL_ONE2ONE = (1, '视频1V1邀请医生/面诊师加入面诊')
    USER_SEND_MESSAGE_TO_DOCTOR = (2, '用户发送私信时通知医生')
    CONSULTATION_COUNSEL_DISPATCH = (3, '视频派单邀请用户加入面诊')
    CALL_CENTER_SEND_MESSAGE = (4, '呼叫中心发送消息')