# coding=utf-8
from __future__ import absolute_import, unicode_literals
from ..utils.enum import Enum, unique


@unique
class MESSAGE_TYPE(Enum):
    TEXT = ('0', '文字')
    AUDIO = ('1', '语音')
    IMAGE = ('2', '图片')
    SERVICE = ('3', '美购详情')
    DOCTOR_TOPIC = ('4', '医生发布帖子')
    TEXT_WITH_URL = ('5', '文字+链接')
    CUSTOMER_SRV_CTRL = ('6', '客服控制消息')
    DIARY = ('8', "日记本")
    GIFT = ('9', "美券礼包")


@unique
class CONVERSATION_TYPE(Enum):
    MESSAGE = (1, '普通私信会话')
    CUSTOMER_SRV = (2, '客服私信会话')


@unique
class CONVERSATION_ORDER(Enum):
    LAST_REPLY_TIME = (1, '最后对话时间')
    UNREAD = (2, '未读+最后对话时间')


@unique
class NOTIFY_EVENT(Enum):
    CONVERSATION = ('conversation', u'私信相关')


@unique
class NOTIFY_OPERATE(Enum):
    ADD = ('add', u'新增')
    CLEAR = ('clear', u'清除计数')
