# -*- coding: utf-8 -*-
""" 号码保护相关枚举 """
from gm_types.utils.enum import Enum

class ALI_NPP_API_CODE(Enum):
    """阿里号码保护api错误码"""
    OK = (0, 'OK')
    ISP_RAM_PERMISSION_DENY = (1 , 'RAM权限DENY')
    ISV_OUT_OF_SERVICE = (2, '业务停机')
    ISV_PRODUCT_UN_SUBSCRIPT = (3, '未开通云通信产品的阿里云客户')
    ISV_ACCOUNT_NOT_EXISTS = (4, '账户不存在')
    ISV_ACCOUNT_ABNORMAL = (5, '账户异常')
    ISP_SYSTEM_ERROR = (6, '系统异常')
    ISP_UNKNOWN_ERR_CODE = (7, '运营商未知错误')
    ISV_PARTNER_NOT_EXIST = (8, '未知合作伙伴')
    ISV_NO_NOT_EXIST = (9, '号码不存在')
    ISV_ILLEGAL_ARGUMENT = (10, '参数错误')
    ISP_DAO_EXCEPTION = (11, '数据库异常')
    ISV_NO_AVAILABLE_NUMBER = (12, '无可用号码')
    ISP_VENDOR_UNAVAILABLE = (13, '运营商降级')
    ISV_FLOW_LIMIT = (14, '业务流控')
    ISV_PARTNER_IS_CLOSED = (15, 'partner被关停')
    ISV_FORBIDDEN_ACTION = (16, '无权操作')
    ISV_NO_USED_BY_OTHERS = (17, '号码被其他业务方占用')
    ISV_VENDOR_BIND_FAILED = (18, '运营商绑定失败')
    ISV_EXPIRE_DATE_ILLEGAL = (19, '过期时间非法')
    ISV_MOBILE_NUMBER_ILLEGAL = (20, '号码格式非法')
    ISV_BIND_CONFLICT = (21, '绑定冲突')
    SDK_INVALID_REGION_ID = (22, 'sdk中regionid错误')
    SDK_SERVER_UNREACHABLE = (23, '服务器不可达')
    SDK_INVALID_REQUEST = (24, '请求不合法')
    SDK_MISSING_ENDPOINTS_FILER = (25, 'sdk中缺失endpoint操作')
    SDK_UNKNOWN_SERVER_ERROR = (26, 'sdk未知阿里服务器错误')
    SDK_INVALID_CREDENTIAL = (27, 'sdk证书错误')
    SDK_INVALID_SESSION_EXPIRATION = (28, 'sdk中session错误')
    SDK_GET_SESSION_CREDENTIAL_FAILED = (29, 'sdk获取session证书错误')
    SDK_INVALID_PARAMS = (30, 'sdk参数错误')
    SDK_NOT_SUPPORT = (31, 'sdk不支持')
    SDK_ENDPOINT_RESOLVING_ERROR = (32, 'endpoint处理错误')
    SDK_ENDPOINT_TESTABILITY = (33, 'SDK.EndpointTestability')
    SDK_HTTP_ERROR = (34, 'http错误')
    SDK_INVALID_PARAMETER = (35, 'sdk无效参数')
    SUBS_NOT_EXIST = (36, '绑定关系不存在')
    POOLKEY_NOT_EXIST = (37, 'pool_key错误')
    UNKNOWN_ALI_CODE = (400, '未知code')

class VIRTUAL_PHONE_STATUS(Enum):
    """
    阿里虚拟号码绑定状态
    """
    NORMAL = (1, '呼叫正常')
    ANOMAL_GIVE_X = (2, '当前绑定关系呼叫状态异常，平台重新分配了一个临时可用的X号码用于呼叫')
    ANOMAL_GIVE_X_FAIL = (3, '当前绑定呼叫异常，且分配临时号码失败。建议用户降级为透传真实的被叫号码来继续呼叫。')
    OVERDUE = (4, '绑定关系已经过期')

class CALL_DISPLAY_TYPE(Enum):
    DISPLAY_X = (1, '主被叫显示中间号码X')
    DISPLAY_B = (2, 'B/N侧号码呼叫时，给A侧号码显示B/N的真实号码')
    DISPLAY_A = (3, 'A侧号码呼叫时，给B/N侧号码显示真实号码。')


class VIRTUAL_CALL_RELEASE_CAUSE(Enum):
    UN_BIND_NUM = (1, '未分配的号码')
    UN_ROUTE_SWITCH = (2, '无路由到指定的转接网')
    UN_ROUT_DESTINATION = (3, '无路由到目的地')
    SEND_DEDICATED_MESSAGE_TONE = (4, '发送专用信息音')
    NORMAL_CALL_UNWINDING = (16, '正常的呼叫拆线')
    USER_BUSY = (17, '用户忙')
    NOT_RESPONDING = (18, '用户未响应')
    NOT_ANSWER = (19, '用户未应答')
    ABSENCE = (20, '用户缺席')
    CALL_REJECT = (21, '呼叫拒收')
    NUM_CHANGED = (22, '号码改变')
    UNREACH_DESTINATION = (27, '目的地不可达')
    INVALID_NUM_FORMAT = (28, '无效的号码格式（地址不全）')
    PERFORMANCE_REJECT = (29, '性能拒绝')
    NORMAL_UNSPEZIFIZIERT = (31, '正常—未指定')
    NOT_SCHALTUNGEN = (34, '无电路 / 通路可用')
    SWITCH_DEVICE__BLOCK = (42, '交换设备拥塞')
    REQUEST_PERFORMANCE_NOT_PREDETERMINED = (50, '所请求的性能未预定')
    CUG_RESTRAINT_TO_CALL = (53, 'CUG中限制去呼叫')
    CUG_RESTRAINT_CALLED = (55, 'CUG中限制来呼叫')
    NO_COMPETENCE_IN_CARRYING_CAPACITY =  (57, '承载能力无权')
    UNAVAILABLE_CARRYING_CAPACITY = (58, '承载能力目前不可用')
    UNREACHED_CARRYING_CAPACITY = (65, '承载能力未实现')
    UNREACHED_PERFORMANCE = (69, '所请求的性能未实现')
    CALLED_USER_NOT_MEMBER_OF_CUG = (87, '被叫用户不是CUG的成员')
    INCOMPATIBLE_DESTINATION = (88, '不兼容的目的地')
    NOT_EXIST_CUG = (90, '不存在的CUG')
    INVALID_TRANSFER_CHOICE = (91, '无效的转接网选择')
    INVALID_MESSAGE = (95, '无效的消息，未指定')
    INVALID_MESSAGE_TYPE = (97, '消息类型不存在或未实现')
    INVALID_PARAM = (99, '参数不存在或未实现')
    RESUME_TIMER = (102, '定时器终了时恢复')
    INVALID_PARAM_TRANSFER = (103, '参数不存在或未实现—传递')
    MESSAGE_HAVE_UNDIFINED_PARAM = (110, '消息带有未被识别的参数—舍弃')
    WRONG_PROCOTOL = (111, '协议错误，未指定')
    INTEROPERABLE = (127, '互通，未指定')

class UNBIND_REASON(Enum):
    AUTO = (1, '自动过期解绑')
    MANUAL = (2, '手动解绑')
    ERROR = (3, '异常解绑')

class CALL_TYPE(Enum):
    A_TO_B = (0, 'A打给B')
    B_TO_A = (1, 'B打给A')
    SEND_MESSAGE = (2, '短信发送')
    RECIEVE_MESSAGE = (3, '短信接受')
    CALL_INTERDICT = (4, '呼叫拦截')
    MESSAGE_INTERDICT = (5, '短信收发拦截')


class RELEASE_DIR(Enum):
    PLATFORM = (0, '平台释放')
    CALL_RELEASE = (1, '主叫挂断')
    CALLED_RELEASE = (2, '被叫挂断')