# -*- coding: utf-8 -*-
from __future__ import print_function, absolute_import, unicode_literals

from .utils.enum import Enum, unique

class EventType(Enum):
    COMPLETEPORTRAIT = ('1', '完善头像')
    BINDPHONE = ('2', '绑定手机号')
    CREATEOPERATIONTOPIC = ('3', '发布手术类日记帖')  # 7.6.20后统一用此，不区分是否非手术
    CREATENONOPERATIONTOPIC = ('4', '发布非手术类日记帖')
    DIARYCOMMENTED = ('5', '日记本被评论')
    TOPICCOMMENTED = ('6', '日记贴被评论')
    OPERATIONDIARYBEEDEXCELENTFROMFINE = ('7', '手术类日记本从良变优')
    NONOPERATIONDIARYBEEXCELENTFROMFINE = ('8', '非手术类日记本从良变优')
    OPERATIONDIARYBEEDEXCELENTFROMOTHER = ('9', '手术类日记本从其他变优')
    NONOPERATIONDIARYBEEXCELENTFROMOTHER = ('10', '非手术类日记本从其他变优')
    OPERATIONDIARYBEFINEFROMEX = ('11', '手术类日记本从优变良')
    NONOPERATIONDIARYBEFINEFROMEX = ('12', '非手术类日记本从优变良')
    OPERATIONDIARYBEFINEFROMOTHER = ('13', '手术类日记本从其他变良')
    NONOPERATIONDIARYBEFINEFROMOTHER = ('14', '非手术类日记本从其他变良')
    COMMENTDIARY = ('15', '评论日记本')  # replaced by COMMENT_OTHER
    COMMENTTOPIC = ('16', '评论咨询帖／日记帖')  # replaced by COMMENT_OTHER
    ANSWERRECOMMENDED = ('17', '回答被评为优质回答')
    QUESTIONRECOMMENDED = ('18', '问题被评为优质问题')
    TOPICISSPAM = ('19', '帖子被举报')
    COMMENTISSPAM = ('20', '回复被举报')
    BUYSERVICE = ('21', '购买美购商品')
    CHECKIN = ('22', '签到')
    COMMENT_OTHER = ('23', '评论日记本／日记帖/回答/专栏') # added 7.6.20
    COMMENT_OTHER_MULTI_TIMES = ('24', '累计评论多次') # 7.6.20 6次
    ANSWER_QUESTION = ('25', '发布回答') # 7.6.20 6次
    VOTE_MULTI_TIMES = ('26', '点赞多次') # 7.6.20 6次
    FOLLOW_MULTI_TIMES = ('27', '关注多次') # 7.6.20 6次
    ANSWER_MULTI_TIMES = ('28', '回答多次') # 7.6.20 6次
    DIARY_TOBE_EXCELLENT = ('29', '日记被标记为优质') # 7.6.20 6次
    CREATE_TOPIC = ('30', '发表术后日记') # 7.6.20 6次
    UPDATE_NICKNAME = ('31', '修改昵称')


class CONSTELLATION(Enum):
    Capricorn = ('12', u'魔羯座') # 12 / 22 - 1 / 19
    Aquarius = ('1', u'水瓶座') # (1 / 20 - 2 / 18)
    Pisces = ('2', u'双鱼座') # (2 / 19 - 3 / 20)
    Aries = ('3', u'牡羊座') # (3 / 21 - 4 / 20)
    Taurus = ('4', u'金牛座') # (4 / 21 - 5 / 20)
    Gemini = ('5', u'双子座') # (5 / 21 - 6 / 21)
    Cancer = ('6', u'巨蟹座') # (6 / 22 - 7 / 22)
    Leo = ('7', u'狮子座') # (7 / 23 - 8 / 22)
    Virgo = ('8', u'处女座') # (8 / 23 - 9 / 22)
    Libra = ('9', u'天秤座') # (9 / 23 - 10 / 22)
    Scorpio = ('10', u'天蝎座') # (10 / 23 - 11 / 21)
    Sagittarius = ('11', u'射手座') # (11 / 22 - 12 / 21)
    Unknown = ('13', u'未知')


class UserRightType(Enum):
    Identify = ('1', u'身份铭牌')
    Points =('2', u'美分奖励')
    Video = ('3', u'短视频')
    Free_order = ('4', u'免费订制')
    Free_experience = ('5', u'免费体验')
    Constellation = ('6', u'星座铭牌')


class FEEDBACK(Enum):
    """卡片隐藏反馈理由"""

    NO_INTEREST = (0, "不感兴趣")
    BUY = (1, "买过了")
    LOW_QUALITY = (2, "质量差")
