# -*- coding: utf-8 -*-
"""
Created on Thu Oct  5 15:28:45 2017

@author: hanye
"""

import datetime
from func_calculate_monthly_net_inc import cal_monthly_net_inc
import logging


today=datetime.datetime(2018,5,1)
fetch_year=today.year
fetch_month=today.month
fetch_day=today.day

# define logger
logger=logging.getLogger('calculate_monthly_net_inc')
logger.setLevel(logging.DEBUG)
# create handler
#path='D:\\CSM\\Python\\test_logging\\'
path='/home/hanye/project_data/Python/Projects/proj-short-videos/write-data-into-es/log/'
log_fn='calculate_monthly_net_inc_for_%s_on_%s_log' % (today.isoformat()[:10], datetime.datetime.now().isoformat().replace(':','-'))
fh=logging.FileHandler(path+log_fn)
fh.setLevel(logging.INFO)
# create formatter and add it to the handler
formatter=logging.Formatter('%(asctime)s - %(name)s - %(levelname)s - %(message)s')
fh.setFormatter(formatter)
# add handler to logger
logger.addHandler(fh)

logger.info('short-video log starts')

search_body={
                "query": {
                        "bool": {
                                "must": [{"range": {"release_time": {"gte": 0, "lte": 0}}},
                                         {"range": {"fetch_time": {"gte": 0, "lte": 0}}}],
#                                "must_not": [{"exists": {"field":"monthly_cal_base"}}]
                                }
                        },
                "size": 2, 
                "aggs": {
                  "release_time_distribution": {
                    "date_histogram": {
                      "field": "release_time",
                      "interval": "day",
                      "time_zone": "Asia/Shanghai"
                    }
                  }
                }                    
            }

cal_monthly_net_inc(fetch_year, fetch_month, fetch_day,
                    doc_type_target='daily-url-2018-04-30',
                    search_body=search_body)

