# coding=utf-8
# create by oldman at 17/3/21

from gm_types.utils.enum import Enum, unique


@unique
class ORDER_OPERATE(Enum):
    GENERATE_ORDER = (0, u'生成订单')
    ON_THE_AD = (1, u'上架广告')
    CANCEL_ORDER = (2, u'取消订单')
    AD_EXPIRES = (3, u'广告到期')
    INITIATE_REFUND = (4, u'发起退款')
    REFUND_COMPLETE = (5, u'退款完成')


@unique
class ACCOUNT_STATUS(Enum):
    """
    账户的状态
    """
    NORMAL = (0, u'正常状态')
    FREEZED = (1, u'冻结')


@unique
class RECHANGE_STATUS(Enum):
    """
    充值的状态
    """
    PENDING_REVIEW = (0, u'待财务审核')
    PASSED = (1, u'审核通过')
    TURN_DOWN = (2, u'财务驳回')
    RECOMMIT = (3, u'待财务重新审核')

@unique
class RECHARGE_STATUS(Enum):
    """
    自动充值的状态
    """
    NO_PAY = (0, u'未支付')
    PAY_SUCCESS = (1, u'充值成功')

@unique
class PAYINFO_IMAGE(Enum):
    """
    充值上传的图片类型
    """
    PROOF_OF_PAYMENT = (0, u'支付凭证')
    AUTHORIZATION_VOUCHER = (1, u'授权凭证')
    COLLECTION_OF_PAYMENTS = (2, u'收款凭证')


@unique
class RECHANGE_OPERATE(Enum):
    """
    充值审核的操作类型
    """
    INITIATE_APPLICATION = (0, u'待财务审核')
    PASS = (1, u'审核通过')
    TURN_DOWN = (2, u'财务驳回')
    RECOMMIT = (3, u'待财务重新审核')


@unique
class CASHBACK_STATUS(Enum):
    """
    返现的状态
    """
    PENDING_REVIEW = (0, u'待财务审核')
    PASSED = (1, u'审核通过')
    TURN_DOWN = (2, u'财务驳回')
    RECOMMIT = (3, u'待财务重新审核')


@unique
class CASHBACK_OPERATE(Enum):
    """
    返现审核的操作类型
    """
    INITIATE_APPLICATION = (0, u'待财务审核')
    PASS = (1, u'审核通过')
    TURN_DOWN = (2, u'财务驳回')
    RECOMMIT = (3, u'待财务重新审核')


@unique
class CASHBACK_VALIDITY_STATUS(Enum):
    """
    返现有效期状态
    """
    WAIT = (0, u'未扣款')
    PROCESS = (1, u'正在扣款')
    END = (2, u'已扣完或过期')


@unique
class ACCOUNT_OPERATE(Enum):
    """
    账号的操作类型
    """
    FREEZE = (0, u'冻结账号')
    REFUNDS = (1, u'退款')


@unique
class ACCOUNTFLOW_OPERATE(Enum):
    """
    账号的流水类型
    """
    RECHANGE = (0, u'商桥充值(线下打款)')
    CASHBACK = (1, u'平台返点')
    REFUNDS = (2, u'退款')
    BUYADVERTISE = (3, u'其他资源消耗')
    ORDERTORECHANGE = (4, u'交易转服务')
    PVDEDUCT = (5, u'浏览消耗')
    MESSAGEDEDUCT = (6, u'私信消耗')
    CPCDEDUCT = (7, u'点点通商品消耗')
    ADJUST = (8, u'业务调账')
    CPCDEDUCT_COMMUNITY = (9, u'点点通内容消耗')
    CPC_REFUND = (10, u'点点通返款')
    AUTO_RECHARGE = (11, u'商桥充值(在线充值)')
    CPCDEDUCT_DOCTOR = (12, u'点点通机构消耗')
    DISCOUNT_CASHBACK = (13, u'佣金返点')
    ADD_VALUE_ADVERTISE = (14, u'增值服务消耗')
    RECHANGE_DEDUCT_RECEIVE = (15, u'财务充值抵扣应收消耗')


@unique
class CPC_DEDUCT_TYPE(Enum):
    """
    点点通类型
    """
    SERVICE = (0, u'商品')
    COMMUNITY = (1, u'内容')
    DOCTOR = (2, u'机构')


@unique
class CASHBACK_AREA(Enum):
    """
    返点大区
    """
    PUBLIC = (0, u'公立')
    SOUTH = (1, u'南区')
    NORTH = (2, u'北区')
    NONE = (3, u'未知')


@unique
class ADVERTISE_TYPE(Enum):
    """
    广告类型
    第一类： 选时间，时间后面选城市的
    第二来： 选时间，时间后面选城市，并且添加关键词的
    第三类： 附带按钮数据的
    第四类：直接自定义价格价格的
    第五类：选择专题，一个专题有多个广告的
    第六类： 榜单list,一个榜单可以配置多个广告，广告下面选城市
    第七类：只选择时间

    自定义广告类型
    """
    FIRST = (0, u'第一类：APP开屏（分地域），商品-固定ICON，商品-专题美购外显，热门搜索-综合，'
                u'首页-日记本加权，首页-日记本固定位，首页-医生排名，首页-医院排名，商品-底部推荐列表'
                u'热门搜索-医生，热门搜索-医院, 首页-聚合页-banner, 热门搜索-商品, 首页-聚合页-美购列表')
    SECOND = (1, u'第二类：搜索关键词－商品列表，搜索关键词－医生列表，搜索关键词－医院列表') # 带有关键词的
    THIRD = (2, u'第三类：商品－品类模块')
    FOURTH = (3, u"第四类：达人，黄金档直播, 资源包, 微信公众号软植, 微信公众号文末贴片")
    FIVE = (4, u'第五类: 专题list')
    SIX = (5, u'第六类：榜单list')
    SEVEN = (6, u'第七类：首页-免费整形ICON，APP开屏（全国）')
    CUSTOM = (1000, u'自定义广告类型')
    CASHBACK_VALIDITY = (1001, u'返点到期清零')
    HISTORY_DEDUCTION = (1002, u'历史欠款补收')
    CUSTOM_ADD_VALUE = (7, u'自定义增值广告')

@unique
class CATEGORY_TYPE(Enum):
    """
    广告分类
    """
    LIST = (0, u"列表类")
    CASE = (1, u"案例类")
    PLAN = (2, u"策划类")
    CUSTOM = (3, u"自定义类")
    OTHER = (4, u"其他类")

@unique
class CITY_TYPE(Enum):
    """
    城市类型
    """
    STANDARD_CITY = (0, u'标准城市')
    OTHER_CITY = (1, u'其他城市')
    RESIDUAL_FLOW = (2, u'剩余流量')


@unique
class PROVINCE_TYPE(Enum):
    """
    城市类型
    """
    STANDARD_PORVINCE = (0, u'标准省份')
    OTHER_PROVINCE = (1, u'其他省份')


@unique
class FACTOR_TYPE(Enum):
    """
    因子级别
    """
    FIRST = (0, u'第一因子')
    SECOND = (1, u'第二因子')


@unique
class MATERIAL_STATUS(Enum):
    """
    医生提报广告审核状态
    """
    SUBMMIT = (0, u'提交')
    PASS = (1, u'审核通过')


@unique
class DETAIL_TYPE(Enum):
    """
    三十四类广告类型
    """
    HOME_BANNER = (0, u'首页banner, 关闭')
    SERVICE_HOME_BANNER = (1, u'商品首页banner, 关闭')
    SERVICE_TOFU_BLOCK = (2, u'商品豆腐块栏, 关闭')
    FEED_BANNER = (3, u'信息流banner, 关闭')
    FEED_DIARY = (4, u'信息流日记本')
    SERVICE_HOME_COMMAND_LIST = (5, u'商品首页推荐列表')
    HOME_SEARCH_SERVICE_LIST_RANK = (6, u'搜索关键词－商品列表')
    HOME_SEARCH_DOCTOR_LIST_RANK = (7, u'搜索关键词－医生列表')
    SERVICE_HOME_BUTTON = (8, u'商品－品类模块')
    ZHIBO = (9, u'直播')
    DAREN = (10, u'达人')
    HOME_SEARCH_HOSPITAL = (11, u'搜索关键词－医院列表')
    WECHAT_RUANZHI = (12, u'微信公众号软植')
    WECHAT_WENMOTIEPIAN = (13, u'微信公众号文末贴片')
    SPECIAL_LIST = (14, u'专题list, 关闭')
    BANGDAN_LIST = (15, u'榜单list, 关闭')
    HOME_DIARY_WEIGHTED = (16, u'首页-日记本加权')
    HOME_DIARY_FIXED_POSITION = (17, u'首页-日记本、帖子固定位')
    HOME_FREE_PLASTIC_ICON = (18, u'首页-免费整形ICON')
    APP_OPEN_FOR_NATIONAL = (19, u'APP开屏（全国）')
    APP_OPEN_FOR_REGIONAL = (20, u'APP开屏（分地域）')
    HOME_DOCTOR_RANK = (21, u"首页-医生排名")
    HOME_HOSPITAL_RANK = (22, u"首页-医院排名")
    SERVICE_THEMATIC_OUTSITE = (23, u"商品-专题外显（医院专场套餐）")
    SEARCH_HOT_WORD_DOCTOR = (24, u"热门搜索-医生")
    SEARCH_HOT_WORD_HOSPITAL = (25, u"热门搜索-医院")
    SERVICE_HOME_FIXED_ICON = (26, u"商品-固定ICON")
    SEARCH_HOT_WORD_COMPREHENSIVE = (27, u"热门搜索-综合")
    INDEX_AGG_BANNER = (28, u'首页-聚合页-banner')
    SEARCH_HOT_SERVICE = (29, u'热门搜索-商品')
    INDEX_AGG_SERVICE = (30, u'首页-聚合页-商品列表')
    RESOURCE = (31, u'资源包')
    SERVICE_DOCTOR_LIST = (32, u'商品首页-医生榜')
    SERVICE_HOSPITAL_LIST = (33, u'商品首页-医院榜')
    HOME_AGG_DOCTOR_LIST = (34, u'首页-聚合页-医生列表')
    HOME_AGG_HOSPITAL_LIST = (35, u'首页-聚合页-医院列表')
    CUSTOM_TYPE = (1000, u"自定义类型")
    CASHBACK_VALIDITY_TYPE = (1001, u'返点到期清零')
    HISTORY_DEDUCTION = (1002, u'历史欠款补收')


class AD_ORDER_STATUS(Enum):
    """
    广告订单的状态
    """
    ALL = (0, u'全部')
    BUY = (1, u'已购买')
    WAIT_CHECK = (2, u'待审核')
    WAIT_ACTIVATE = (3, u'待上线')
    ONLINE = (4, u'上线中')
    OFFLINE = (5, u'已下线')


class AD_BD_TYPE(Enum):
    """
    榜单list中榜单类型
    """
    SERVICE = (0, u'美购')
    DOCTOR = (1, u'医生')
    HOSPITAL = (2, u'医院')


class AD_REVENUE_STATUS(Enum):
    """
    子账户状态
    """
    WAIT = (0, u'未扣款')
    PROCESS = (1, u'正在扣款')
    END = (2, u'已扣完')


class AD_EXPAND_TYPE(Enum):
    """
    消耗类型
    """
    REFUND = (2, u'退款')
    AD = (3, u'购买广告')
    PV = (5, u'PV消耗')
    MESSAGE = (6, u'私信消耗')
    CPC = (7, u'点点通消耗')
    CPC_COMMUNITY = (9, u'内容点点消耗')
    CPC_REFUND = (10, u'点点通返款')
    

class CPC_DEDUCT_STATUS(Enum):
    """
    cpc扣款状态，key为error
    """
    SUCCESS = (0, u'成功')
    ERROR = (1, u'失败')


class CPC_DEDUCT_DESC(Enum):
    """
    cpc扣款成功后的描述，key为desc
    """
    NORMAL = (0, u'正常扣款成功')
    REPETITION = (1, u'重复扣款')
    MINUS = (2, u'扣款之后账户已小于等于零')


@unique
class CPC_UNPROMOTE_REASON(Enum):
    ACCOUNT_AMOUNT = 1, '帐户欠费'
    NO_PERMISSION = 2, '未开通点点通'
    MERCHANT_BUDGET = 4, '到单日总预算'
    SERVICE_BUDGET = 8, '到美购单日预算'
    SUSPENDED = 16, '手动暂停'
    NOT_ON_TIME = 32, '不在推广期'
    NOT_ON_HOUR = 64, '不在推广时间段'


@unique
class PROMOTE_ACTION(Enum):
    PROMOTE_MODIFY = 'modify', '医生修改推广'
    MERCHANT_BUDGET = 'merchant_budget', '机构修改日预算'
    MERCHANT_ENABLE = 'merchant_enable', '机构开关cpc功能'
    DEDUCTION = 'deduction', '扣费'
    ROUND_CHECK = 'round_check', '兜底轮询'
    DAILY_CHECK = 'daily_check', '每天的开始检查'


@unique
class DISCOUNT_PRODUCT_TYPE(Enum):
    """打折商品类型"""
    ALL = (0, u'全部商品')
    SOME = (1, u'部分商品')


@unique
class DISCOUNT_TYPE(Enum):
    """打折方式"""
    PERFERENTIAL_DISCOUNT = (0, u'择优打折')
    SUPERPOSITION_DISCOUNT = (1, u'叠加打折')
    NONE = (2, u'无')


@unique
class AREA_TYPE(Enum):
    """地域类型"""
    WHOLE_COUNTRY = (0, u'全国')
    SOME_AREA = (1, u'部分地域')


@unique
class AD_ORDER_TYPE(Enum):
    NORMAL = (0, u'普通广告订单')
    CASHBACK_RESET = (1, u'返点到期清零订单')


@unique
class ACCREDIT_STATUS(Enum):
    PRE = u'PRE', u'未生效'
    ING = u'ING', u'生效中'
    DONE = u'DONE', u'已完成'
    CANCEL = u'CANCEL', u'已撤销'


@unique
class ACCREDIT_TYPE(Enum):
    CPT = (0, '返点购买本省CPT')
    CONVERSATION = (1, '主动私信有效浏览用户')
    BUDAN_BILL= (2, '转诊提前开票')
    BDTRANSER_DISPATCH = (3, '转诊在线派单')
    MESSAGE_VOICE_ALERT = (4, '私信语音提醒')


@unique
class ACCREDIT_TIMES_TYPE(Enum):
    NO_LIMIT = (1, '不限次数')
    LIMIT_PER_DAY = (2, '每天限次')
    LIMIT_TOTAL = (3, '限制总次数')


@unique
class ACCREDIT_REASON(Enum):
    A = '新机构扶持', '新机构扶持'
    B = '合作机构授权', '合作机构授权'


@unique
class COMMUNITY_CPC_TYPE(Enum):
    DIARY = (1, u'日记本')


@unique
class COMMUNITY_CPC_UNPROMOTE_REASON(Enum):
    ACCOUNT_AMOUNT = 1, '帐户欠费'
    NO_PERMISSION = 2, '未开通点点通'
    MERCHANT_BUDGET = 4, '到单日总预算'
    COMMUNITY_BUDGET = 8, '到内容单日预算'
    SUSPENDED = 16, '手动暂停'
    NOT_ON_TIME = 32, '不在推广期'
    NOT_ON_HOUR = 64, '不在推广时间段'


@unique
class COMMUNITY_PROMOTE_ACTION(Enum):
    PROMOTE_MODIFY = 'modify', '医生修改推广'
    MERCHANT_BUDGET = 'merchant_budget', '机构修改日预算'
    MERCHANT_ENABLE = 'merchant_enable', '机构开关cpc功能'
    DEDUCTION = 'deduction', '扣费'
    ROUND_CHECK = 'round_check', '兜底轮询'
    DAILY_CHECK = 'daily_check', '每天的开始检查'

class PERSON_PAYMENT_CHANNEL(Enum):
    """
    个人支付方式
    """
    WX = ("WECHAT", "微信")
    ALI = ("ALIPAY", "支付宝")
    HZ_BANK = ("HZBANK_B2C", "杭州银行")
    ABC_BANK = ("ABC_B2C", "农业银行")
    HXB_BANK = ("HXB_B2C", "华夏银行")
    CCB_BANK = ("CCB_B2C", "建设银行")
    CIB_BANK = ("CIB_B2C", "兴业银行")
    CEB_BANK = ("CEB_B2C", "光大银行")
    BOC_BANK = ("BOC_B2C", "中国银行")
    GDB_BANK = ("GDB_B2C", "广发银行")
    SHB_BANK = ("SHB_B2C", "上海银行")
    ICBC_BANK = ("ICBC_B2C", "工商银行")
    BOCO_BANK = ("BOCO_B2C", "交通银行")
    SZPA_BANK = ("SZPA_B2C", "平安银行")
    CMBC_BANK = ("CMBC_B2C", "民生银行")
    BCCB_BANK = ("BCCB_B2C", "北京银行")
    NBCB_BANK = ("NBCB_B2C", "宁波银行")
    CMB_BANK = ("CMBCHINA_B2C", "招商银行")
    SZPA1_BANK = ("SZPA_B2C", "深圳发展银行")
    ECITIC_BANK = ("ECITIC_B2C", "中信银行")
    SPDB_BANK = ("SPDB_B2C", "上海浦东发展银行")
    PSBC_BANK = ("PSBC_B2C", "中国邮政储蓄银行")
    BJRCB_BANK = ("BJRCB_B2C", "北京农商银行")
    SRCB_BANK = ("SRCB_B2C", "上海农村商业银行")


class BUSINESS_PAYMENT_CHANNEL(Enum):
    """
    商业支付方式
    """
    ABC_BANK = ("ABC_B2B", "农业银行")
    CCB_BANK = ("CCB_B2B", "建设银行")
    CIB_BANK = ("CIB_B2B", "兴业银行")
    CEB_BANK = ("CEB_B2B", "光大银行")
    BOC_BANK = ("BOC_B2B", "中国银行")
    ICBC_BANK = ("ICBC_B2B", "工商银行")
    SZPA_BANK = ("SZPA_B2B", "平安银行")
    CMBC_BANK = ("CMBC_B2B", "民生银行")
    SZPA1_BANK = ("SZPA_B2B", "深圳发展银行")
    CMB_BANK = ("CMBCHINA_B2B", "招商银行")
    ECITIC_BANK = ("ECITIC_B2B", "中信银行")
    SPDB_BANK = ("SPDB_B2B", "上海浦东发展银行")
    #HZ_BANK = ("HZBANK_B2B", "杭州银行")
    #HXB_BANK = ("HXB_B2B", "华夏银行")
    #GDB_BANK = ("GDB_B2B", "广发银行")
    #SHB_BANK = ("SHB_B2B", "上海银行")
    #BOCO_BANK = ("BOCO_B2B", "交通银行")
    #BCCB_BANK = ("BCCB_B2B", "北京银行")
    #NBCB_BANK = ("NBCB_B2B", "宁波银行")
    #PSBC_BANK = ("PSBC_B2B", "中国邮政储蓄银行")
    #BJRCB_BANK = ("BJRCB_B2B", "北京农商银行")
    #SRCB_BANK = ("SRCB_B2B", "上海农村商业银行")

@unique
class CUSTOMAD_TYPE(Enum):
    """
     自定义广告商品类型
    """
    PROMOTION = (1, u'大促类')
    CASE = (2, u'案例类')
    LIST = (3, u'列表类')
    PLAN = (4, u'策划类')
    OTHER = (5, u'其他类')


@unique
class DOCTOR_CPC_UNPROMOTE_REASON(Enum):
    ACCOUNT_AMOUNT = 1, '帐户欠费'
    NO_PERMISSION = 2, '未开通点点通'
    MERCHANT_BUDGET = 4, '到单日总预算'
    DOCTOR_BUDGET = 8, '到单个推广医生单日预算'
    SUSPENDED = 16, '手动暂停'
    NOT_ON_TIME = 32, '不在推广期'
    NOT_ON_HOUR = 64, '不在推广时间段'


@unique
class DOCTOR_PROMOTE_ACTION(Enum):
    PROMOTE_MODIFY = 'modify', '医生修改推广'
    MERCHANT_BUDGET = 'merchant_budget', '机构修改日预算'
    MERCHANT_ENABLE = 'merchant_enable', '机构开关cpc功能'
    DEDUCTION = 'deduction', '扣费'
    ROUND_CHECK = 'round_check', '兜底轮询'
    DAILY_CHECK = 'daily_check', '每天的开始检查'


class CUSTOM_AD_BUSINESS(Enum):
    """
    自定义广告商家类型
    """
    ALL_BUSINESS = (0, u'全部商家')
    HOSPITAL_BUSINESS  = (1, u'部分商家-机构')
    TEAM_BUSINESS = (2, u'部分商家-商务')

