# -*- coding: utf-8 -*-
from .utils.enum import Enum


class COUNSELLOR_TYPE(Enum):
    """
    面诊顾问类别
    """
    DOCTOR = (1, '医生')
    CONSULTANT = (2, '面诊师')


class COUNSELLOR_STATUS(Enum):
    """
    面诊顾问面诊状态
    """
    OFFLINE = (1, '离线')
    ONLINE = (2, '在线')
    CONSULTING_NOW = (3, '面诊中')


class CONSULTATION_RECORD_STATUS(Enum):
    """
    面诊连线状态
    """
    START = (1, '等待接通')
    ONLINE = (2, '连线中')
    FINISH = (3, '结束')


class CONSULTATION_RECORD_FINISH_REASON(Enum):
    """
    面诊连线结束原因
    """
    NOT_FINISH = (1, '未结束')
    USER_CANCELLED = (2, '用户取消')
    COUNSELLOR_CANCELLED = (3, '面诊顾问取消')
    SYSTEM_CANCELLED = (4, '接通超时')
    USER_FINISH = (5, '用户挂断')
    COUNSELLOR_FINISH = (6, '面诊顾问挂断')
    SYSTEM_FINISH = (7, '连线超时')


class COMPLAINT_STATUS(Enum):
    """
    面诊投诉状态
    """
    PENDING = (0, u'审核中')
    SUCCESS = (1, u'已通过')
    REJECT = (2, u'已驳回')


class COMPLAINT_TYPE(Enum):
    """
    面诊投诉类型
    """
    USER_LAUNCHED = (0, '用户发起')
    DOCTOR_LAUNCHED = (1, '面诊师发起')


class CONSULTATION_TABS(Enum):
    """tabs"""
    ALL = (0, '全部')
    CONTOUR_SKELETON = (1, '轮廓骨骼')
    SKIN = (2, '皮肤美容')
    SYS = (3, '眼部整形')
    NOSE = (4, '鼻部整形')
    CHEST = (5, '胸部塑身')
    SLIMMING = (6, '瘦身美体')
    INJECTION = (7, '注射美容')
    TOOTH = (8, '牙齿美容')
    HAIR = (9, '毛发管理')
    VISION = (10, '视力矫正')


class CONSULTATION_COMMENT_STATUS(Enum):
    """
    评价状态
    """
    NO_COMMENTED = (0, '未评价')
    COMMENTED = (1, '已评价')


class CONSULTATION_COMMENT_STAR(Enum):
    """
    评价星级
    """
    NONE = (0, '用户发起')
    ONE = (1, '一星')
    TWO = (2, '二星')
    THREE = (3, '三星')
    FOUR = (4, '四星')
    FIVE = (5, '五星')


class COUNSELLOR_GRADE(Enum):
    """
    医生和面诊师评级
    """
    ONE = (1, '一级')
    TWO = (2, '二级')
    THREE = (3, "三级")


class COUNSELLOR_REPORT_STATUS(Enum):
    """
    面诊报告表状态值
    """
    NO_NEED_WRITE = (0, u'不用写')
    TO_BE_WRITE = (1, u'待填写')
    FINSH = (2, u'已完成')


class CONSULTATION_EVENT_TYPE(Enum):
    """ 面诊连线记录相关事件定义 """

    INVETED_JOIN = ('1', '被邀请加入')
    JOIN_SUCCESS = ('2', '加入成功')
    JOIN_FAILED = ('3', '加入失败')
    AGREE_INVITE = ('4', '接受邀请')
    REJECT_INVITE = ('5', '拒绝邀请')
    ACTIVE_QUIT = ('6', '主动退出')
    PASSIVE_QUIT = ('7', '被动退出')
    HEARTBEAT = ('8', '心跳')
    RECOMMENDED_BAG_UPDATE = ('9', '推荐袋数据更新')
    SYSTEM_CANCELLED = ('10', '接通超时')
    USER_CANCELLED = ('11', '用户取消')
    USER_DISPATCH = ('12', '用户发起派单')
    USER_INVENTED_JOIN = ('13', '用户被邀请加入') # 面诊顾问呼出


class CONSULTATION_USER_ROLE(Enum):
    USER = (1, "用户")
    COUNSELLOR = (2, "面诊师")
    SYSTEM = (3, "系统")


class CONSULTATION_COUNSELLOR_TYPE(Enum):
    """面诊师傅类型"""
    DOCTOR = (0, '面诊医生(医生本人)')
    DOCTOR_ASSISTOR = (1, '面诊医生(医生助理)')


class COUNSEllOR_OPERATE_TYPE(Enum):
    """ 面诊师状态操作类型 """
    ON = (1, '开')
    DOWN = (0, '关')


class CONSULTATION_REFERER(Enum):
    """ 视频面诊呼入来源类型 """

    VIDEO_FACE_CONSULTATION = ("video_face_consultation", "视频面诊频道页")
    EXPERT_DETAIL = ("expert_detail", "医生主页")
    CONVERSATION_DETAIL = ("conversation_detail", "私信会话页")


class CONSULTANT_AUDIT_TYPE(Enum):
    """医生后台面诊师资料类型 """

    REGISTERED = (0, "注册类型")
    CHANGED = (1, "变更过注册类型")


class APPOINTMENT_TYPE(Enum):
    """
    用户预约状态
    """
    ONLINE = (1, '医生在线')
    HAS_APPOINTMENT = (2, '已预约')
    DEFAULT = (3, '未预约')
    EXPIRED = (4, '已过期')
    CONSULTING_NOW = (5, '面诊中')


class CONSULTANT_AUDIT_STATUS(Enum):
    """
    面诊审核状态
    """
    PENDING = (0, u'审核中')
    SUCCESS = (1, u'已通过')
    REJECT = (2, u'已驳回')


class CONSULTANT_APPROVE_STATUS(Enum):
    """ 面诊师认证状态 """
    UNAPPROVE = (0, u'未认证')
    APPROVED = (1, u'已认证')


class CONSULTANT_CERTIFICATE_TYPE(Enum):
    """
    证件类型
    """
    IMAGE = (0, u'形象照')
    ID_PHOTO = (1, u"手持身份证照")
    RELATION_PHOTO = (2, u"关系证明照")
    HONOR_CERTICATE = (3, u"荣誉证书")
    TRAINING_CERTICATE = (4, u"培训证书")


class CONSULTANT_OPERATE_TYPE(Enum):
    """ 面诊师操作类型 """

    ONLINE = (1, u'上线')
    OFFLINE = (2, U'下线')


class CONSULTANT_AUDIT_OPERATE_TYPE(Enum):
    """ 面诊师操作类型 """

    APPROVE = (1, u'通过')
    REJECT = (2, U'驳回')

class CONSULTANT_AUDIT_STATUS_TAB(Enum):
    """
    面诊审核状态
    """
    PENDING = (1, u'入驻待审核')
    CHANGED = (2, u'更改资料待审核')
    SUCCESS = (3, u'审核通过')
    REJECT = (4, u'审核不通过')


class CONSULTATION_DISPATCH_STATUS(Enum):
    """
    面诊派单状态
    """
    START = (1, '待抢单')
    ONLINE = (2, '连线中')
    FINISH = (3, '结束')


class CONSULTATION_HERA_DISPATCH_STATUS(Enum):
    """
    面诊hera派单状态
    """
    START = (1, '待抢单')
    ONLINE = (2, '连线中')
    USER_CANCELLED = (3, '用户取消派单')
    SYSTEM_CANCELLED = (4, '系统取消派单')
    RECORD_FINISH = (5, '连线结束')


class CONSULTATION_DISPATCH_FINISH_REASON(Enum):
    """
    面诊派单结束原因
    """
    NOT_FINISH = (1, '未结束')
    USER_CANCELLED = (2, '用户取消')
    SYSTEM_CANCELLED = (3, '系统取消')
    RECORD_FINISH = (4, '连线记录结束')


class CONSULTATION_RECORD_TYPE(Enum):
    """
    面诊连线记录类型
    """
    ONE_TO_ONE = (1, '1V1')
    DISPATCH = (2, '抢单')


class CONSULTATION_RECOMMAND_ADVERTISING_POSITION(Enum):
    """
    视频面诊广告位位置
    """
    RECOMMAND = (1, '视频面诊推荐')
    FEED = (2, '视频面诊主页feed流')


class CONSULTATION_RECOMMAND_ADVERTISING_AREA_TYPE(Enum):
    """
    视频面诊广告展示地区类型
    """
    COUNTRY = (1, '全国展示')
    PROVINCE = (2, '部分省份展示')
    CITY = (3, '部分城市展示')


class CONSULTATION_RECOMMAND_ADVERTISING_SHOW_STATUS(Enum):
    """
    视频面诊广告位生效状态
    """
    NOT_BEGIN = (1, '未开始')
    SHOWING = (2, '生效中')
    EXPIRED = (3, '已过期')
    CLOSED = (4, '已关闭')


class CONSULTATION_SMART_RANK_FACTOR(Enum):
    """
    面诊师推荐smart rank 因子
    """
    CONNECTED_RATE = (1, '连通率')
    VALID_RATE = (2, '有效率')


class ORDER_TYPE(Enum):
    """ 面诊订单类型 """

    ONE_TO_ONE = (1, '1V1')
    DISPATCH = (2, '抢单')


class ORDER_STATUS(Enum):
    """ 面诊订单状态 """

    UNPAY = (0, '未付款')
    CANCELLED = (1, '已取消')
    PAID = (2, '已付款')
    COMPLAITING = (3, '投诉审核中')
    REFUNDING = (4, '退款处理中')
    REFUNDED = (5, '已退款')
    COMPLETED = (6, '已完成')


class ORDER_PAYMENT_CHANNEL(Enum):
    """ 面诊订单支付渠道 """
    ALIPAY = (0, '支付宝')
    WECHAT = (1, '微信支付')


class ORDER_RABATE_TYPE(Enum):
    """ 面诊订单更美抽成类型 """

    NO_REBATE = (0, '不抽成')
    BY_RATE = (1, '固定比例抽成')
    BY_FIXED = (2, '固定金额抽成')


class ORDER_PAYMENT_STATUS(Enum):
    """ 面诊订单支付状态 """

    PAYING = (0, '支付中')
    PAY_SUCCESS = (1, '支付成功')
    PAY_FAILED = (2, '支付失败')


class ORDER_REFUND_STATUS(Enum):
    """ 面诊订单退款状态 """

    REFUNDING = (0, '退款中')
    REFUND_SUCCESS = (1, '退款成功')
    REFUND_FAILED = (2, '退款失败')


class ORDER_SERVICE_TYPE(Enum):
    """ 面诊订单服务计费类型 """

    ONE_TO_ONE = (1, '1V1')
    DISPATCH = (2, '抢单')


class ORDER_OPERATION_ROLE(Enum):
    """ 面诊订单操作角色 """

    SYSTEM = (0, '系统')
    USER = (1, '用户')
    COUNSELLOR = (2, '面诊顾问')
    OPERATE = (3, '运营')


class ORDER_OPERATION_TYPE(Enum):
    """ 面诊订单操作类型 """

    CREATE = (0, '创建订单')
    COMFIRM = (1, '确认订单')
    PAY = (2, '支付订单')
    CANCELL = (3, '取消订单')
    REFUND = (4, '发起退款')
    REFUND_SUCCESS = (5, '退款成功')
    COMPLAIN = (6, '发起申述')
    COMPLAIN_PASS = (7, '审核申诉通过')
    COMPLAIN_REJECT = (8, '审核申诉驳回')


class COUNSELLOR_SERVICE_TYPE(Enum):
    """ 面诊顾问服务收费类型 """
    ONE_TO_ONE = (1, '1V1')
    DISPATCH = (2, '抢单')


class COUNSELLOR_SERVICE_MODE(Enum):
    """ 面诊顾问服务收费类型 """
    MIANDAN = (0, '免单')
    BY_LEVEL_PER_COUNT = (1, '按等级每次')


class COMMENT_TYPE(Enum):
    """ 面诊评价类型 """
    SYSTEM_COMMENTED = (1, '系统评价')
    USER_COMMENTED = (2, '用户评价')
    USER_SECOND_COMMENTED = (3, '二次评价')


class ORDER_SETTLE_STATUS(Enum):
    """ 订单结算状态 """
    UNSETTLE = (0, '未结算')
    SETTLE_SUCCESS = (1, '结算成功')
    SETTLE_FAILED = (2, '结算失败')


class ORDER_SETTLE_TYPE(Enum):
    """ 订单结算类型 """

    ALIPAY = (1, '支付宝')


class ORDER_SETTLE_OPERATE_TYPE(Enum):
    """ 订单结算操作类型 """

    SUCCESS = (1, '标记为结算成功')
    FAILED = (2, '标记为结算失败')


class ORDER_REFUND_CASE(Enum):

    A = ('A', '自动退款 Case[A]: 医生拒绝接听自动退款, 同步调用')
    B = ('B', '自动退款 Case[B]: 用户取消1v1呼叫, 订单自动退款')
    C = ('C', '自动退款 Case[C]: 系统接通超时, 订单自动退款')
    D = ('D', '自动退款 Case[D]: 派单超时, 订单自动退款')
    E = ('E', '自动退款 Case[E]: 用户取消派单, 订单自动退款')
    F = ('F', '自动退款 Case[F]: 支付完成，没有发起1v1连线，订单自动退款')
    G = ('G', '自动退款 Case[G]: 支付完成，没有发起派单，订单自动退款')
    H = ('H', '自动退款 Case[H]: 审核通过，订单自动退款')
    I = ('I', '自动退款 Case[I]: 订单取消后收到支付成功回调，订单自动退款')
    J = ('J', '自动退款 Case[J]: 发起面诊失败，订单自动退款')
    K = ('K', '自动退款 Case[K]: 发起派单失败，订单自动退款')