CREATE TABLE `zhihu_answer` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `title` varchar(40) DEFAULT NULL COMMENT '标题',
  `content` mediumtext COMMENT '内容',
  `answer_id` int(11) DEFAULT NULL COMMENT 'id',
  `created_time` int(11) DEFAULT NULL COMMENT '创建时间',
  `comment_count` int(11) DEFAULT NULL COMMENT '评论数',
  `new_content` mediumtext COMMENT '新内容',
  `is_new` tinyint(1) NOT NULL DEFAULT 0 COMMENT '是否已更新',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='知乎问答';
alter table `zhihu_answer` add column `is_new` tinyint(1) NOT NULL DEFAULT 0 COMMENT '是否已更新';

CREATE TABLE `zhihu_answer_root_comment` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `root_comment_id` int(11) DEFAULT NULL COMMENT '父评论id',
  `author_name` varchar(40) DEFAULT NULL COMMENT '作者名',
  `content` mediumtext COMMENT '内容',
  `answerid` int(11) DEFAULT NULL COMMENT '回答ID',
  `child_comment_count` int(11) DEFAULT NULL COMMENT '子评论数量',
  `featured` varchar(5) DEFAULT NULL COMMENT '是否精彩评论',
  `created_time` int(11) DEFAULT NULL COMMENT '创建时间',
  `author_id` varchar(50) DEFAULT NULL COMMENT '作者id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='知乎问答父评论';


CREATE TABLE `zhihu_article` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `title` varchar(40) DEFAULT NULL COMMENT '标题',
  `content` mediumtext COMMENT '内容',
  `article_id` int(11) DEFAULT NULL COMMENT 'id',
  `created_time` int(11) DEFAULT NULL COMMENT '创建时间',
  `comment_count` int(11) DEFAULT NULL COMMENT '评论数量',
  `new_content` mediumtext COMMENT '新内容',
  `is_new` tinyint(1) NOT NULL DEFAULT 0 COMMENT '是否已更新',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='知乎文章';


CREATE TABLE `zhihu_child_comment` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `root_comment_id` int(11) DEFAULT NULL COMMENT '父评论id',
  `author_name` varchar(40) DEFAULT NULL COMMENT '作者名',
  `content` mediumtext COMMENT '内容',
  `reply_name` varchar(40) DEFAULT NULL COMMENT '回复者名字',
  `child_comment_id` int(11) DEFAULT NULL COMMENT '子评论id',
  `created_time` int(11) DEFAULT NULL COMMENT '创建时间',
  `author_id` varchar(50) DEFAULT NULL COMMENT '作者id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='知乎子评论';


CREATE TABLE `zhihu_article_root_comment` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `root_comment_id` int(11) DEFAULT NULL COMMENT '父评论id',
  `author_name` varchar(40) DEFAULT NULL COMMENT '作者名',
  `content` mediumtext COMMENT '内容',
  `answerid` int(11) DEFAULT NULL COMMENT '文章id',
  `child_comment_count` int(11) DEFAULT NULL COMMENT '子评论数',
  `featured` varchar(5) DEFAULT NULL COMMENT '是否精彩评论',
  `created_time` int(11) DEFAULT NULL COMMENT '创建时间',
  `author_id` varchar(50) DEFAULT NULL COMMENT '作者id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='知乎文章评论';


CREATE TABLE `zhihu_answer_picture_url` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `answer_id` int(11) DEFAULT NULL COMMENT '问答id',
  `url` mediumtext COMMENT 'url',
  `new_url` mediumtext COMMENT '新url',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='知乎问答图片';


CREATE TABLE `zhihu_article_picture_url` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `article_id` int(11) DEFAULT NULL COMMENT '文章id',
  `url` mediumtext COMMENT 'url',
  `new_url` mediumtext COMMENT '新url',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='知乎文章图片';


CREATE TABLE `zhihu_thought` (
   `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `thought_id` varchar(50) DEFAULT NULL COMMENT '想法id',
  `content` text COMMENT '内容',
  `created_time` int(11) DEFAULT NULL COMMENT '创建时间',
  `comment_count` int(11) DEFAULT NULL COMMENT '评论数量',
  `new_content` mediumtext COMMENT '新内容',
  `is_new` tinyint(1) NOT NULL DEFAULT 0 COMMENT '是否已更新',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='知乎想法';


CREATE TABLE `zhihu_thought_comment` (
    `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `thought_comment_id` int(11) DEFAULT NULL COMMENT '想法评论id',
  `author_name` varchar(40) DEFAULT NULL COMMENT '作者名',
  `content` text COMMENT '内容',
  `answerid` varchar(50) DEFAULT NULL COMMENT '想法id',
  `created_time` int(11) DEFAULT NULL COMMENT '创建时间',
  `author_id` varchar(50) DEFAULT NULL COMMENT '作者名',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='知乎想法评论';


CREATE TABLE `zhihu_thought_picture_url` (
    `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `thought_id` varchar(50) DEFAULT NULL COMMENT '想法ID',
  `url` text COMMENT 'url',
  `new_url` text COMMENT 'new url',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='知乎想法图片'
