//Copyright (C) 2013 Steve Taylor (steve98654@gmail.com), Davis E. King
//License: Boost Software License.  See LICENSE.txt for full license.
#ifndef DLIB_NUMERIC_CONSTANTs_H_
#define DLIB_NUMERIC_CONSTANTs_H_

namespace dlib 
{

    // pi -- Pi
    const double pi = 3.1415926535897932385;

    // e  -- Euler's Constant
    const double e = 2.7182818284590452354;

    // sqrt_2 -- the square root of 2
    const double sqrt_2 = 1.4142135623730950488;

    // sqrt_3 -- the square root of 3
    const double sqrt_3 = 1.7320508075688772935;

    // light_spd -- the speed of light in vacuum in meters per second
    const double light_spd = 2.99792458e8;

    // newton_G  -- Newton's gravitational constant (in metric units of m^3/(kg*s^2))
    const double newton_G = 6.67384e-11;

    // planck_cst -- Planck's constant (in units of Joules * seconds) 
    const double planck_cst = 6.62606957e-34;

}

#endif //DLIB_NUMERIC_CONSTANTs_H_

