import pymysql
import random
import traceback
import logging
from threading import Thread
from vest.request.auto_request import login, time_convs, Urge
from vest.request.auto_request import host, user, db, passwd
from libs.error import logging_exception
from libs.timelib import get_rand_time


def get_commnet_id(numtime, numtime2):
    pc = pymysql.connect(host=host, user=user, passwd=passwd, db=db, port=3306)
    cursor = pc.cursor()

    # 注册后
    # todo 这个查询太慢了，加一个limit
    cursor.execute(

        "select  a.user_id, u.is_shadow from account_user a left join user_extra u on a.user_id = u.user_id "
        "WHERE  a.create_time > '%s' and a.create_time < '%s' limit 10000" % (numtime, numtime2))

    res = cursor.fetchall()
    return res and [i for (i, is_shadow) in res if is_shadow != 1] or []


def batch_handle(auto_follow_list):
    for user_id in auto_follow_list:
        try:
            cookies = login()
            if cookies is not None:
                # follow(cookies, user_id)
                time = get_rand_time()
                Urge.apply_async(args=(cookies, user_id), eta=time)

        except:
            pass


def auto_urge_per_1d_by_regist():
    # 注册事件触发自动催更
    auto_urge_list = []
    try:
        # 1天前注册：[3-6]个催更
        # numtime1, numtime2 = time_convs(1, 1)
        # user_ids= get_commnet_id(numtime2, numtime1)
        # for user_id in user_ids:
        #     follow_num = random.randint(3, 6)
        #     for i in range(follow_num):
        #         auto_urge_list.append(user_id)


        # 2-10天前注册：[0-1]个催更
        # numtime1, numtime2 = time_convs(2, 10)
        # user_ids = get_commnet_id(numtime2,  numtime1)
        # for user_id in user_ids:
        #     follow_num = random.randint(0, 1)
        #     for i in range(follow_num):
        #         auto_urge_list.append(user_id)

        # 每隔9天[0-1]个催更
        numtime1, numtime2 = time_convs(1, 1)
        user_ids = get_commnet_id('2019-05-11', numtime2)
        for user_id in user_ids:
            follow_num = random.randint(1, 18)
            if follow_num == 1:
                auto_urge_list.append(user_id)

    except:
        logging_exception()
        logging.error("catch exception,main:%s" % traceback.format_exc())


    logging.info('auto_follow_per_1d_by_regist: len %s' % len(auto_urge_list))
    print('auto_follow_per_1d_by_regist: len %s' % len(auto_urge_list))

    total = len(auto_urge_list)
    limit = (total + 10) // 10
    for start in range(0, total, limit):
        batch = auto_urge_list[start:start + limit]
        t = Thread(target=batch_handle, args=[batch])
        t.start()
