#!/usr/bin/env python
# -*- coding: utf-8 -*-

import logging
import traceback
import datetime
import json
from libs.es import ESPerform
from libs.cache import redis_client

class PickUtils(object):

    @classmethod
    def refresh_redis_data(cls,have_read_celebrity_list,redis_cli,redis_key):
        try:
            now = datetime.datetime.now()

            str_end_time = "%s-%s-%s 23:59:59" % (now.year, now.month, now.day)
            end_time = datetime.datetime.strptime(str_end_time, "%Y-%m-%d %H:%M:%S")

            valid_seconds = int((end_time - now).seconds)

            #logging.info("duan add,have_read_celebrity_list:%s" % str(have_read_celebrity_list))
            redis_cli.setex(redis_key,valid_seconds,json.dumps(have_read_celebrity_list))

            return True
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return False

    @classmethod
    def ___get_filter_term_list(cls,ori_list):
        try:
            should_term_list = list()
            for term_id in ori_list:
                term_dict = {
                    "term":{
                        "id":{"value":term_id}
                    }
                }
                should_term_list.append(term_dict)
            return should_term_list
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return []

    @classmethod
    def get_recommend_celebrity_id_list(cls,pick_id,have_read_pick_celebrity_ids,offset,size):
        """
        :remark 根据榜单ID推荐明星ID
        :param pick_id:
        :param have_read_pick_celebrity_ids:
        :return:
        """
        try:
            filter_term_list = cls.___get_filter_term_list(have_read_pick_celebrity_ids)
            q = dict()
            q["query"] = {
                "bool":{
                    "filter":filter_term_list,
                    "must":[
                        {"term":{"pick_id_list":pick_id}},
                        {"term":{"is_online":True}}
                    ]
                }
            }
            q["_source"] = {
                "include": ["id"]
            }
            result_dict = ESPerform.get_search_results(ESPerform.get_cli(),sub_index_name="celebrity",query_body=q,offset=offset,size=size)
            recommend_pick_celebrity_list = [item["id"] for item in result_dict["hits"]]

            return recommend_pick_celebrity_list
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return []

    @classmethod
    def get_topic_pick_query(cls,query,pick_id,offset,size):
        """
        :remark 查询榜单下帖子列表
        :param query:
        :param pick_id:
        :param offset:
        :param size:
        :return:
        """
        try:
            q = dict()
            multi_fields = {
                'description': 2,
                'name': 4,
            }
            query_fields = ['^'.join((k, str(v))) for (k, v) in multi_fields.items()]
            multi_match = {
                'query': query,
                'type': 'cross_fields',
                'operator': 'and',
                'fields': query_fields,
            }
            q["query"] = {
                "multi_match":multi_match,
                "bool":{
                    "must":[
                        {"term":{"pick_id_list":pick_id}},
                        {"term":{"is_online":True}}
                    ]
                }
            }
            q["_source"] = {
                "include":["id"]
            }
            result_dict = ESPerform.get_search_results(ESPerform.get_cli(),sub_index_name="topic",query_body=q,offset=offset,size=size)

            recommend_topic_id_list = []
            if len(result_dict["hits"]) > 0:
                recommend_topic_id_list = [item["_source"]["id"] for item in result_dict["hits"]]

            return recommend_topic_id_list
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return []

    @classmethod
    def get_celebrity_pick_query(cls,query,pick_id,offset,size):
        try:
            q = dict()
            """
            multi_fields = {
                'name': 2,
            }
            query_fields = ['^'.join((k, str(v))) for (k, v) in multi_fields.items()]
            multi_match = {
                'query': query,
                'type': 'cross_fields',
                'operator': 'and',
                'fields': query_fields,
            }            
            """
            q["query"] = {
                #"multi_match":multi_match,
                "match":{
                    "name":query
                },
                "bool":{
                    "must":[
                        {"term":{"pick_id_list":pick_id}},
                        {"term":{"is_online":True}}
                    ]
                }
            }
            q["_source"] = {
                "include":["id"]
            }
            result_dict = ESPerform.get_search_results(ESPerform.get_cli(),sub_index_name="celebrity",query_body=q,offset=offset,size=size)

            recommend_celebrity_id_list = []
            if len(result_dict["hits"]) > 0:
                recommend_celebrity_id_list = [item["_source"]["id"] for item in result_dict["hits"]]

            return recommend_celebrity_id_list
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return []
