import pymysql
import traceback
import logging
from vest.request.auto_request import login, follow, time_conv
from vest.request.auto_request import host, user, db, passwd
from vest.data.majia_user_ids import majia_user_ids_list, majia_user_ids_dict
from libs.error import logging_exception


def get_user_id(numtime):
    pc = pymysql.connect(host=host, user=user, passwd=passwd, db=db, port=3306)
    cursor = pc.cursor()
    majia_user_ids_tuple = tuple(majia_user_ids_list)
    cursor.execute(
        "SELECT  user_id, follow_id FROM user_follow WHERE  create_time > '%s' and follow_id in %s " % (numtime, str(majia_user_ids_tuple))
    )
    data_comment = cursor.fetchall()
    return data_comment and [i for i in data_comment] or []


def auto_follow_per_5m_by_followed():
    # 如果马甲被用户关注，马甲即反向关注用户, 被关注5分钟后
    try:
        numtime1, numtime2 = time_conv(1, 5)
        users = get_user_id(numtime2)
        try:
            for user in users and users:
                user_id = user[0]
                cookies = login(str(majia_user_ids_dict.get(user[1])))
                if cookies is not None:
                    follow(cookies, user_id)
        except:
            pass

    except:
        logging_exception()
        logging.error("catch exception,main:%s" % traceback.format_exc())
