import datetime

from django.db import models


class AccountRegExtra(models.Model):
    class Meta:
        verbose_name = u"设备用户关系表"
        db_table = "account_reg_extra"

    id = models.IntegerField(verbose_name="主键ID", primary_key=True)
    is_online = models.BooleanField(verbose_name=u"是否上线")
    create_time = models.DateTimeField(verbose_name=u"创建时间", default=datetime.datetime.fromtimestamp(0))
    update_time = models.DateTimeField(verbose_name=u"更新时间", default=datetime.datetime.fromtimestamp(0))
    is_deleted = models.BooleanField(verbose_name=u"")
    geo = models.CharField(verbose_name=u"", max_length=300)
    model = models.CharField(verbose_name=u"", max_length=64)
    device_id = models.CharField(verbose_name=u"设备ID", max_length=64)
    share_code = models.CharField(verbose_name=u"", max_length=64)
    user_id = models.IntegerField(verbose_name="用户ID")
