from django.db import models


class LinDeviceTagCtr(models.Model):
    class Meta:
        verbose_name = u"30天内设备的tag的ctr"
        db_table = "lin_device_tag_ctr"
        unique_together = ("device_id", "tag_id")

    id = models.IntegerField(primary_key=True, verbose_name=u"主键ID")
    create_time = models.DateTimeField(verbose_name=u'统计创建时间')
    update_time = models.DateTimeField(verbose_name=u'统计更新时间')
    device_id = models.CharField(verbose_name=u'设备id', max_length=100)
    tag_id = models.IntegerField(verbose_name=u'标签id')
    tag_click_30 = models.IntegerField(verbose_name=u'30天内的点击数')
    tag_impress_30 = models.IntegerField(verbose_name=u"30天内的曝光数")
    tag_ctr_30 = models.FloatField(verbose_name=u"30天内的ctr")


class LinTopicCtr(models.Model):
    class Meta:
        verbose_name = u"30天内回答的ctr"
        db_table = "lin_topic_ctr "

    id = models.IntegerField(primary_key=True, verbose_name=u"主键ID")
    create_time = models.DateTimeField(verbose_name=u'统计创建时间')
    update_time = models.DateTimeField(verbose_name=u'统计更新时间')
    topic_id = models.IntegerField(verbose_name=u'回答id', unique=True)
    is_new = models.IntegerField(verbose_name=u"是否是新帖")
    topic_ctr_30 = models.FloatField(verbose_name=u"30天内回答的ctr")
    like_rate_30 = models.FloatField(verbose_name=u"30天内回答的点赞率")
