#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
import sys
import logging
import traceback
from elasticsearch import Elasticsearch


class ESPerform(object):
    def __init__(self):
        self.cli_obj = None
        self.cli_info_list = [
            {
                "host":"10.29.130.141",
                "port":9200
            }
        ]
        self.index_prefix = "gm-dbmw"

    def get_cli(self):
        try:
            self.cli_obj = Elasticsearch(self.cli_info_list)
            return self.cli_obj
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return None

    def __get_official_index_name(self,sub_index_name,index_flag=None):
        """
        :remark:get official es index name
        :param sub_index_name:
        :param index_flag:
        :return:
        """
        try:
            assert (index_flag in [None,"read","write"])

            official_index_name = self.index_prefix + "-" + sub_index_name
            if index_flag:
                official_index_name += "-" + index_flag

            return official_index_name
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return None

    def create_index(self,es_cli,sub_index_name):
        """
        :remark: create es index,alias index
        :param sub_index_name:
        :return:
        """
        try:
            assert (es_cli is not None)

            official_index_name = self.__get_official_index_name(sub_index_name)
            index_exist = es_cli.indices.exists(official_index_name)
            if not index_exist:
                es_cli.indices.create(official_index_name)
                read_alias_name = self.__get_official_index_name(sub_index_name,"read")
                es_cli.indices.put_alias(official_index_name,read_alias_name)

                write_alias_name = self.__get_official_index_name(sub_index_name,"write")
                es_cli.indices.put_alias(official_index_name,write_alias_name)

            return True
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return False
