#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.conf import settings
from django.core.management.base import BaseCommand, CommandError
import traceback
import logging
from django.db import models
import datetime

manager = lambda: models.Manager().db_manager(using='face')


class FaceUserContrastSimilar(models.Model):
    class Meta:
        app_label = "face"
        verbose_name = u"用户脸相似表"
        db_table = "face_user_contrast_similar"

    objects = manager()

    id = models.IntegerField(verbose_name="主键ID", primary_key=True)
    is_online = models.BooleanField(verbose_name="是否上线")
    is_deleted = models.BooleanField(verbose_name="是否删除")
    participant_user_id = models.IntegerField(verbose_name=u'参与者用户ID')
    similarity = models.FloatField(verbose_name=u'相似度', default=0)
    create_time = models.DateTimeField(verbose_name=u'创建时间', default=datetime.datetime.fromtimestamp(0))
    update_time = models.DateTimeField(verbose_name=u'更新时间', default=datetime.datetime.fromtimestamp(0))
    contrast_user_id = models.IntegerField(verbose_name=u'对照者用户ID')


class UserSimilarScore(models.Model):
    class Meta:
        verbose_name=u"首页推荐用"
        db_table="user_similar_score"

    id = models.IntegerField(verbose_name=u"主键ID",primary_key=True)
    is_deleted = models.BooleanField(verbose_name=u"是否删除")
    user_id = models.IntegerField(verbose_name=u"用户ID")
    contrast_user_id = models.BigIntegerField(verbose_name="参数对比的用户id", db_index=True)
    score = models.FloatField(verbose_name='相似度', default=0)
    create_time = models.DateTimeField(verbose_name=u'创建时间',default=datetime.datetime.fromtimestamp(0))
    update_time = models.DateTimeField(verbose_name=u'更新时间', default=datetime.datetime.fromtimestamp(0))


