import logging
import traceback
from django.db import models
from django.conf import settings


class LikeDeviceTagStat(models.Model):
    class Meta:
        verbose_name = u"30天内设备的tag的stat"
        db_table = "like_device_tag_stat"
        unique_together = ("device_id", "tag_id")

    id = models.IntegerField(primary_key=True, verbose_name=u"主键ID")
    create_time = models.DateTimeField(verbose_name=u'统计创建时间')
    update_time = models.DateTimeField(verbose_name=u'统计更新时间')
    device_id = models.CharField(verbose_name=u'设备id', max_length=100)
    tag_id = models.IntegerField(verbose_name=u'标签id')
    tag_click_30 = models.IntegerField(verbose_name=u'30天内的点击数')
    tag_impress_30 = models.IntegerField(verbose_name=u"30天内的曝光数")
    tag_ctr_30 = models.FloatField(verbose_name=u"30天内的ctr")


class LikeTopicStat(models.Model):
    class Meta:
        verbose_name = u"30天内回答的stat"
        db_table = "like_topic_stat"

    id = models.IntegerField(primary_key=True, verbose_name=u"主键ID")
    create_time = models.DateTimeField(verbose_name=u'统计创建时间')
    update_time = models.DateTimeField(verbose_name=u'统计更新时间')
    topic_id = models.IntegerField(verbose_name=u'回答id', unique=True)
    is_new_topic = models.IntegerField(verbose_name=u"是否是新帖")
    topic_ctr_30 = models.FloatField(verbose_name=u"30天内回答的ctr")
    like_rate_30 = models.FloatField(verbose_name=u"30天内回答的点赞率")


class LikePictorialStat(models.Model):
    class Meta:
        verbose_name = u"30天内问题的stat"
        db_table = "like_pictorial_stat"

    id = models.IntegerField(primary_key=True, verbose_name=u"主键ID")
    create_time = models.DateTimeField(verbose_name=u'统计创建时间')
    update_time = models.DateTimeField(verbose_name=u'统计更新时间')
    pictorial_id = models.IntegerField(verbose_name=u'问题id', unique=True)
    is_new_pictorial = models.IntegerField(verbose_name=u"是否是新问题")
    pictorial_ctr_30 = models.FloatField(verbose_name=u"30天内问题的ctr")
    like_rate_30 = models.FloatField(verbose_name=u"30天内问题的点赞率")
    pictorial_ctr_all = models.FloatField(verbose_name=u"历史该问题的ctr")
    like_rate_all = models.FloatField(verbose_name=u"历史该问题的点赞率")


    @classmethod
    def get_pictorial_is_new(cls, pictorial_id):
        try:
            is_new_pictorial = LikePictorialStat.objects.using(settings.SLAVE1_DB_NAME).filter(pictorial_id=pictorial_id).values_list(
                "is_new_pictorial", flat=True).first()
            if is_new_pictorial == 0:
                return False
            else:
                return True
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return True

    @classmethod
    def get_pictorial_ctr_30(cls, pictorial_id):
        try:
            pictorial_ctr_30 = LikePictorialStat.objects.using(settings.SLAVE1_DB_NAME).filter(pictorial_id=pictorial_id).values_list(
                "pictorial_ctr_30", flat=True).first()

            return pictorial_ctr_30
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return 0.0

    @classmethod
    def get_pictorial_like_rate_30(cls, pictorial_id):
        try:
            like_rate_30 = LikePictorialStat.objects.using(settings.SLAVE1_DB_NAME).filter(pictorial_id=pictorial_id).values_list(
                "like_rate_30", flat=True).first()

            return like_rate_30
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return 0.0

    @classmethod
    def get_pictorial_ctr_all(cls, pictorial_id):
        try:
            pictorial_ctr_all = LikePictorialStat.objects.using(settings.SLAVE1_DB_NAME).filter(pictorial_id=pictorial_id).values_list(
                "pictorial_ctr_all", flat=True).first()

            return pictorial_ctr_all
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return 0.0

    @classmethod
    def get_pictorial_like_rate_all(cls, pictorial_id):
        try:
            like_rate_all = LikePictorialStat.objects.using(settings.SLAVE1_DB_NAME).filter(pictorial_id=pictorial_id).values_list(
                "like_rate_all", flat=True).first()

            return like_rate_all
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return 0.0
