import requests
import datetime
import random
import traceback
import logging
import json
import redis
import smtplib
from celery import shared_task
from libs.cache import redis_client
from email.mime.text import MIMEText
from email.utils import formataddr
from physical.settings_local import DATABASES
from physical.settings_local import REDIS_URL
from vest.cache.base import reply_cache, follow_cache, click_cache
from vest.data.topic_models import get_pictorial_tag_by_id, get_topic_product_info, get_edit_tag_id_list, \
    get_category_tag_id, topic_has_image, get_tag_id_list
from django.conf import settings

my_sender = 'lixiaofang@igengmei.com'
my_pass = 'tg5AVKBB8jLQGBET'
my_user6 = "lixiaofang@igengmei.com"

auto_vote_url = settings.AUTO_VOTE_URL
auto_click_url = settings.AUTO_CLICK_URL
auto_reply_url = settings.AUTO_REPLY_URL
auto_follow_url = settings.AUTO_FOLLOW_URL
auto_urge_url = settings.AUTO_URGE_URL

host = DATABASES['default']['HOST']

user = DATABASES['default']['USER']

port = DATABASES['default']['PORT']

db = DATABASES['default']['NAME']

passwd = DATABASES['default']['PASSWORD']


def get_majia_reply(user_id):
    try:
        data = open("/srv/apps/physical/vest/data/vest_user_email.txt")
        list = []
        for i in data:
            if i != user_id:
                list.append(i.strip('\n').strip(','))

        maj = random.randint(1, len(list))
        user_id = list[maj - 1]
        return user_id

    except:
        logging.error("catch exception,get_majia:%s" % traceback.format_exc())
        return None


def get_majia():
    try:
        data = open("/srv/apps/physical/vest/data/vest_user_email.txt")
        list = []
        for i in data:
            list.append(i.strip('\n').strip(','))
        maj = random.randint(1, len(list))
        user_id = list[maj - 1]
        return user_id

    except:
        logging.error("catch exception,get_majia:%s" % traceback.format_exc())
        return None


def get_cookies(user_id):
    try:
        session_key = "majia_login_session"
        data = redis_client.hget(session_key, user_id)
        logging.info("get data:%s" % data)
        logging.info("get data:%s" % json.loads(data))

        return json.loads(data)

    except:
        logging.error("catch exception,get_majia:%s" % traceback.format_exc())
        return None


def login(user_id=None):
    try:
        if not user_id:
            user_id = get_majia()
        logging.info("get user_id:%s" % user_id)

        cookies = get_cookies(user_id)
        if cookies is not None:
            return {'sessionid': cookies}

    except:

        logging.error("catch exception,logins:%s" % traceback.format_exc())

        return None


def logins(user_id):
    try:
        cookies = get_cookies(user_id)
        if cookies is not None:
            return {'sessionid': cookies}

    except:

        logging.error("catch exception,logins:%s" % traceback.format_exc())

        return None


@shared_task(retry_kwargs={'max_retries': 0})
def click(cookies_get, id):
    try:
        click_key = 'click topic_id:%s, cookies_get: %s' % (str(cookies_get), str(id))
        cache_count = click_cache.incr(click_key, 1)
        click_cache.expire(click_key, settings.CACHE_SECONDS)
        if cache_count > 1:
            return
    except:
        return

    # 点赞
    try:
        topic_id = id[0]
        pictorial_id = id[1]

        if pictorial_id:
            post_dict = {
                "topic_id": topic_id,
                "pictorial_id": pictorial_id
            }
            response = requests.post(url=auto_vote_url,
                                     cookies=cookies_get,
                                     data=post_dict)

        else:
            post_dict = {
                'type': 0,
                'id': topic_id
            }
            response = requests.post(url=auto_click_url,
                                     cookies=cookies_get,
                                     data=post_dict)

        print(response.text)
        logging.info("response.text:%s" % response.text)

        get_error(response.text, "click", id)
    except:

        logging.error("catch exception,logins:%s" % traceback.format_exc())


@shared_task(retry_kwargs={'max_retries': 0})
def reply(cookies_get, id, content):
    try:
        reply_key = 'reply topic_id:%s, cookies_get: %s, content:%s' % (str(id), str(cookies_get), str(content))
        cache_count = click_cache.incr(reply_key, 1)
        reply_cache.expire(reply_key, settings.CACHE_SECONDS)
        if cache_count > 1:
            return
    except:
        return

    try:
        post_dict = {
            'topic_id': id,
            'content': content,
            "type": 4
        }
        response = requests.post(url=auto_reply_url,
                                 cookies=cookies_get,
                                 data=post_dict)

        print(response.text)
        logging.info("response.text:%s" % response.text)
        get_error(response.text, "reply", id)
    except:

        logging.error("catch exception,logins:%s" % traceback.format_exc())


def time_conv(minutest, minutest2):
    try:
        now = datetime.datetime.now()
        yes_time = now - datetime.timedelta(minutes=minutest)
        yes_time2 = now - datetime.timedelta(minutes=minutest2)
        return yes_time, yes_time2
    except:
        return None


def time_conv_minute(minutest, minutest2):
    try:
        now = datetime.datetime.now()
        minute = datetime.datetime.now().minute
        yes_time = now - datetime.timedelta(minutes=minutest)
        yes_time2 = now - datetime.timedelta(minutes=minutest2)
        return yes_time, yes_time2, minute
    except:
        return None


def time_conv_hour(minutest, minutest2):
    try:
        now = datetime.datetime.now()
        yes_time = now - datetime.timedelta(hours=minutest)
        yes_time2 = now - datetime.timedelta(hours=minutest2)
        return yes_time, yes_time2
    except:
        return None


def time_now(minutest):
    try:
        now = datetime.datetime.now()
        yes_time = now - datetime.timedelta(hours=minutest)
        return yes_time, now
    except:
        return None


def time_convs(numtime, numtime2):
    '''
    params: 1, 2
    datetime.now(): 2019-10-09 10:35:50.231463
    return: 2019-10-08 23:59:59.000000 2019-10-07 00:00:00.000000
    '''
    try:
        now = datetime.datetime.now()
        yes_time = now - datetime.timedelta(days=numtime)
        yes_time_str = yes_time.strftime('%Y-%m-%d')
        yes_time_str = yes_time_str + ' 23:59:59.000000'

        yes_time2 = now - datetime.timedelta(days=numtime2)
        yes_time_str2 = yes_time2.strftime('%Y-%m-%d')
        yes_time_str2 = yes_time_str2 + ' 00:00:00.000000'

        logging.info("get yes_time_str:%s" % yes_time_str)
        logging.info("get yes_time_str2:%s" % yes_time_str2)
        return yes_time_str, yes_time_str2
    except:
        return None


def get_comment():
    try:
        data = open("/srv/apps/physical/vest/data/guanshui.txt", "r")
        list_guanshui = []
        for i in data:
            list_guanshui.append(i)

        num = random.randint(0, len(list_guanshui))

        comment = list_guanshui[num - 1]
        return comment

    except:

        return None


def get_comments():
    try:
        data = open("/srv/apps/physical/vest/data/guanshui.txt", "r")
        list_guanshui = []
        for i in data:
            list_guanshui.append(i)

        num1 = random.randint(0, 200)
        num2 = random.randint(200, 400)
        num3 = random.randint(400, len(list_guanshui))

        comment1 = list_guanshui[num1 - 1]
        comment2 = list_guanshui[num2 - 1]
        comment3 = list_guanshui[num3 - 1]

        comment_list = [comment1, comment2, comment3]

        return comment_list

    except:

        return None


@shared_task(retry_kwargs={'max_retries': 0})
def follow(cookies_get, id):
    try:
        follow_key = 'follow user_id:%s, cookies_get: %s' % (str(id), str(cookies_get))
        cache_count = follow_cache.incr(follow_key, 1)
        follow_cache.expire(follow_key, settings.CACHE_SECONDS)
        if cache_count > 1:
            return
    except:
        return

    try:
        post_dict = {
            'type': 1,
            'id': id
        }
        response = requests.post(url=auto_follow_url,
                                 cookies=cookies_get,
                                 data=post_dict)

        print(response.text)
        logging.info("response.text:%s" % response.text)
        get_error(response.text, "follow", id)
    except:

        logging.error("catch exception,logins:%s" % traceback.format_exc())


@shared_task(retry_kwargs={'max_retries': 0})
def Urge(cookies_get, id):
    try:
        urge_key = 'urge user_id:%s, cookies_get: %s' % (str(id), str(cookies_get))
        cache_count = click_cache.incr(urge_key, 1)
        reply_cache.expire(urge_key, settings.CACHE_SECONDS)
        if cache_count > 1:
            return
    except:
        return

    try:
        post_dict = {
            'id': id
        }
        response = requests.post(url=auto_urge_url,
                                 cookies=cookies_get,
                                 data=post_dict)

        logging.info("response.text:%s" % response.text)
        get_error(response.text, "Urge", id)
    except:

        logging.error("catch exception,logins:%s" % traceback.format_exc())


def get_offline_comment():
    try:
        data = open("/srv/apps/physical/vest/data/offline_comment.txt", "r")

        list_guanshui = []
        for i in data:
            list_guanshui.append(i)
        num1 = random.randint(0, 200)
        num2 = random.randint(200, 300)
        num3 = random.randint(300, 400)
        num4 = random.randint(400, len(list_guanshui))

        comment1 = list_guanshui[num1 - 1]
        comment2 = list_guanshui[num2 - 1]
        comment3 = list_guanshui[num3 - 1]
        comment4 = list_guanshui[num4 - 1]

        comment_list = [comment1, comment2, comment3, comment4]
        return comment_list

    except:

        return None


def get_user_id():
    user_data = open("/srv/apps/physical/vest/data/get_user_id.txt", "r")
    user_list = []

    for i in user_data.readlines():
        user_list.append(int(i.strip()))

    return user_list


def send_email(stat_data):
    ret = True
    now = datetime.datetime.now()
    yes_time = now - datetime.timedelta(days=1)
    yes_time_str = yes_time.strftime('%Y%m%d')
    try:
        msg = MIMEText(stat_data, 'plain', 'utf-8')
        msg['From'] = formataddr(["李小芳", my_sender])
        msg["To"] = formataddr(["李小芳", my_user6])
        msg['Subject'] = str(datetime.date.today()) + "like的" + str(settings.SERVICE_NAME) + "环境的自动点赞出问题了"
        server = smtplib.SMTP_SSL("smtp.exmail.qq.com", 465)
        server.login(my_sender, my_pass)
        server.sendmail(my_sender, [my_user6], msg.as_string())
        server.quit()
        return ret
    except Exception:
        ret = False
        logging.error("catch exception,main:%s" % traceback.format_exc())


def get_error(line, type, id):
    try:
        if len(line) > 1:
            data_dict = json.loads(line)
            if data_dict["error"] != 0:
                stat_data = str(line) + str(type) + str(id)
                ret = send_email(stat_data)
                if ret:
                    logging.info('like query统计邮件发送成功')
                else:
                    logging.info('like query统计邮件发送失败')
            else:
                pass
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())


def get_answer_data():
    try:

        # 获取第一条评论
        data = open("/srv/apps/physical/vest/data/reply_answer_data1.txt", "r")

        answer_data1 = []
        for i in data:
            answer_data1.append(i)
        num1 = random.randint(0, len(answer_data1))

        comment1 = answer_data1[num1 - 1]

        # 获取第二条评论
        data = open("/srv/apps/physical/vest/data/reply_answer_data2.txt", "r")

        answer_data2 = []
        for i in data:
            answer_data2.append(i)
        comment2 = answer_data2[num1 - 1]

        logging.info("get comment1:%s" % comment1)
        logging.info("get comment2:%s" % comment2)

        return comment1, comment2

    except:

        return ["", ""]


def reply_answer(cookies_get, id, content):
    try:
        post_dict = {
            'topic_id': id,
            'content': content,
            "type": 4
        }
        response = requests.post(url=auto_reply_url,
                                 cookies=cookies_get,
                                 data=post_dict)

        logging.info("response.text:%s" % response.text)
        get_error(response.text, "reply", id)

        return response.text
    except:

        logging.error("catch exception,logins:%s" % traceback.format_exc())


def set_reply_to_redis():
    try:
        redis_client = redis.StrictRedis.from_url(REDIS_URL)
        return redis_client
    except:
        logging.error("catch exception,logins:%s" % traceback.format_exc())


@shared_task(retry_kwargs={'max_retries': 0})
def reply2(cookies_get, id, content, replied_id):
    try:
        reply_key = 'reply2 topic_id:%s, cookies_get: %s, content:%s, replied_id: %s' % \
                    (str(id), str(cookies_get), str(content), str(replied_id))
        cache_count = reply_cache.incr(reply_key, 1)
        reply_cache.expire(reply_key, settings.CACHE_SECONDS)
        if cache_count > 1:
            return
    except:
        return

    try:
        post_dict = {
            'topic_id': id,
            'content': content,
            "type": 4,
            "replied_id": replied_id
        }
        response = requests.post(url=auto_reply_url,
                                 cookies=cookies_get,
                                 data=post_dict)

        print(response.text)
        logging.info("response.text:%s" % response.text)
        get_error(response.text, "reply2", id)
    except:

        logging.error("catch exception,logins:%s" % traceback.format_exc())


@shared_task(retry_kwargs={'max_retries': 0})
def pictorial_reply(cookies_get, id, content):
    try:
        reply_key = 'click topic_id:%s, cookies_get: %s, content:%s' % (str(id), str(cookies_get), str(content))
        cache_count = click_cache.incr(reply_key, 1)
        reply_cache.expire(reply_key, settings.CACHE_SECONDS)
        if cache_count > 1:
            return
    except:
        return

    try:
        post_dict = {
            'pictorial_id': id,
            'content': content,
            "type": 4
        }
        response = requests.post(url=auto_reply_url,
                                 cookies=cookies_get,
                                 data=post_dict)

        print(response.text)
        logging.info("response.text:%s" % response.text)
        get_error(response.text, "pictorial_reply", id)
    except:
        logging.error("catch exception,logins:%s" % traceback.format_exc())


def get_pictorial_comment():
    try:
        data = open("/srv/apps/physical/vest/data/pictorial_reply_data.txt", "r")
        list_guanshui = []
        for i in data:
            list_guanshui.append(i)

        num = random.randint(0, len(list_guanshui))

        comment = list_guanshui[num - 1]

        logging.info("get comment:%s" % comment)

        return comment

    except:
        logging.error("catch exception,logins:%s" % traceback.format_exc())
        return None


def get_product_comment():
    try:
        data = open("/srv/apps/physical/vest/data/product_reply_data.txt", "r")
        list_guanshui = []
        for i in data:
            list_guanshui.append(i)

        num = random.randint(0, len(list_guanshui))

        comment = list_guanshui[num - 1]

        return comment

    except:

        return None


def get_face_comment():
    try:
        data = open("/srv/apps/physical/vest/data/face_reply_data.txt", "r")
        list_guanshui = []
        for i in data:
            list_guanshui.append(i)

        num = random.randint(0, len(list_guanshui))

        comment = list_guanshui[num - 1]

        return comment

    except:

        return None


def get_hellolike_comment():
    try:
        data = open("/srv/apps/physical/vest/data/hellolike.txt", "r")
        list_guanshui = []
        for i in data:
            list_guanshui.append(i)

        num = random.randint(0, len(list_guanshui))

        comment = list_guanshui[num - 1]

        return comment

    except:

        return None


def get_category_reply_commtent(category_id):
    try:
        # 发型42、穿搭46、美妆3、护肤4、美甲21972、香水17576、瘦身32605、配饰5305608
        file = ""
        if category_id == 3:  # 美妆
            logging.info("3-------------")
            file = "/srv/apps/physical/vest/data/beauty_reply_data.txt"
        elif category_id == 42:  # 发型
            logging.info("42-------------")
            file = "/srv/apps/physical/vest/data/hairstyle_reply_data.txt"
        elif category_id == 4:  # 护肤
            logging.info("4-------------")
            file = "/srv/apps/physical/vest/data/skincare_reply_data.txt"
        elif category_id == 46:  # 穿搭
            logging.info("46-------------")
            file = "/srv/apps/physical/vest/data/wear_repy_data.txt"
        elif category_id == 10329872:  # 肌肤
            file = "/srv/apps/physical/vest/data/skin.txt"
        elif category_id == 10329873:  # 敏感肌
            file = "/srv/apps/physical/vest/data/skin_sensitive.txt"
        else:
            comment = get_comment()
            return comment
        data = open(file, "r")
        list_guanshui = []
        for i in data:
            list_guanshui.append(i)
        num = random.randint(0, len(list_guanshui))
        comment = list_guanshui[num - 1]
        logging.info("get comment:%s" % comment)
        return comment
    except:
        logging.error("catch exception,logins:%s" % traceback.format_exc())
        return None


def judge_topic_info_get_comment(topic_id):
    try:
        comment = ""
        # 先判断是不是编辑标签
        edit_tag_list = get_edit_tag_id_list(topic_id)
        logging.info("get topic_tag:%s" % edit_tag_list)
        tag_list = get_tag_id_list(topic_id)
        if len(tag_list) > 0:
            comment = get_hellolike_comment()

        # 垃圾需求--》垃圾代码 不管了 先上
        if 10329872 in edit_tag_list:
            comment = get_category_reply_commtent(10329872)
            return comment
        if 10329873 in edit_tag_list:
            comment = get_category_reply_commtent(10329873)
            return comment

        elif len(edit_tag_list) > 0:
            # 如果有编辑标签
            # 去拿他的所属分类  根据分类去拿对应的标签（随机拿一个）
            category_tag_id = get_category_tag_id(edit_tag_list)
            if category_tag_id > 0:
                comment = get_category_reply_commtent(category_tag_id)
            else:
                product_judge = get_topic_product_info(topic_id)
                logging.info("get product_judge:%s" % product_judge)
                if product_judge:
                    comment = get_product_comment()
                else:
                    # 判断有没有人脸

                    face_judge = topic_has_image(topic_id)
                    logging.info("get face_judge:%s" % face_judge)

                    if face_judge:
                        comment = get_face_comment()
                    # 原始评论
                    else:
                        # 返回空就会去拿多级评论
                        if random.randint(0, 1):
                            comment = get_comment()

        else:
            # 判断有没有商品信息
            product_judge = get_topic_product_info(topic_id)
            if product_judge:
                comment = get_product_comment()
                logging.info("get product_judge:%s" % product_judge)

            else:
                # 判断有没有人脸
                face_judge = topic_has_image(topic_id)
                logging.info("get face_judge:%s" % face_judge)

                if face_judge:
                    comment = get_face_comment()
                # 原始评论
                else:
                    # 返回空就会去拿多级评论
                    if random.randint(0, 1):
                        comment = get_comment()

        logging.info("get judge_topic_info_get_comment:%s" % comment)
        return comment
    except:
        logging.error("catch exception,logins:%s" % traceback.format_exc())
        return None


def judge_pictorial_info_get_comment(pictorial_id):
    try:
        comment = ""
        # 先判断是不是编辑标签
        edit_tag_list = get_pictorial_tag_by_id(pictorial_id)
        if len(edit_tag_list) > 0:
            # 如果有编辑标签
            # 去拿他的所属分类  根据分类去拿对应的标签（随机拿一个）
            category_tag_id = get_category_tag_id(edit_tag_list)
            logging.info("get category_tag_id:%s" % category_tag_id)
            if category_tag_id > 0:
                comment = get_category_reply_commtent(category_tag_id)
            else:
                logging.info("get -------------+++++++++++")
                comment = get_pictorial_comment()
        else:
            # 原始评论
            comment = get_pictorial_comment()

        logging.info("get judge_topic_info_get_comment:%s" % comment)
        return comment
    except:

        logging.error("catch exception,logins:%s" % traceback.format_exc())
        return None
