#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, absolute_import, print_function
from gm_rpcd.all import bind
import logging
import traceback
import json
from search.utils.topic import TopicUtils
from libs.es import ESPerform
from libs.cache import redis_client
from search.utils.common import *


def get_highlight(fields=[]):
    field_highlight = {
        'fields': {k: {} for k in fields},
        'pre_tags': ['<%s>' % 'ems'],
        'post_tags': ['</%s>' % 'ems'],
    }
    return field_highlight


@bind("physical/search/query_tag")
def query_tag(query,offset,size):
    try:
        q = {
            "query":{
                "bool":{
                    "must":[
                        {"term":{"is_online":True}},
                        {"term": {"is_deleted": False}}
                    ],
                    "should":[
                        {"match":{"name": query,"operator":"and"}}
                    ],
                    "minimum_should_match":1
                }
            },
            "sort":[
                {"near_new_topic_num":{"order":"desc"}},
                {'_score': {"order": "desc"}}
            ],
            "_source": {
                "include": ["id", "name"]
            }
        }
        q["highlight"] = get_highlight(["name"])

        ret_list = list()

        result_dict = ESPerform.get_search_results(ESPerform.get_cli(),sub_index_name="tag",query_body=q,offset=offset,size=size)
        for hit_item in result_dict["hits"]:
            if "name" in hit_item["highlight"] and len(hit_item["highlight"]["name"])>0:
                hit_item["_source"]["highlight"] = hit_item["highlight"]["name"][0]
            else:
                hit_item["_source"]["highlight"] = ""
            ret_list.append(hit_item["_source"])

        return {"tag_list": ret_list}
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return {"tag_list": []}


@bind("physical/search/query_by_tag_type")
def query_by_tag_type(tag_type_id,offset,size):
    try:
        q = {
            "query":{
                "bool":{
                    "must":[
                        {"term":{"is_online":True}},
                        {"term": {"is_deleted": False}}
                    ],
                    "filter":{"term":{"tag_type": tag_type_id}}
                }
            },
            "sort":[
                {"near_new_topic_num":{"order":"desc"}}
            ],
            "_source": {
                "include": ["id", "name"]
            }
        }

        ret_list = list()
        result_dict = ESPerform.get_search_results(ESPerform.get_cli(),sub_index_name="tag",query_body=q,offset=offset,size=size)
        for hit_item in result_dict["hits"]:
            ret_list.append(hit_item["_source"])

        return {"tag_list": ret_list}
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return {"tag_list": []}

