# coding=utf-8                                                                           
from __future__ import unicode_literals, print_function, absolute_import

import itertools

from django.conf import settings
import logging


class CeleryTaskRouter(object):
    queue_task_map = {
        "tapir-alpha": [
            'injection.data_sync.tasks.write_to_es',
        ],
        "majia-alpha": [
            'injection.data_sync.auto_instant_click.auto_click',
        ],
        "majia-alpha": [
            'injection.data_sync.auto_instant_click.auto_reply',
        ]
    }


    # Map[TaskName, QueueName]
    task_queue_map = dict(itertools.chain.from_iterable(
        [(task, queue) for task in task_list]
        for (queue, task_list) in queue_task_map.items()
    ))

    def route_for_task(self, task, args=None, kwargs=None):
        """
        if settings.DEBUG:
            return None

        if task.startswith("statistic") or task.startswith("api.tasks.export_excel_task"):
            return "slow"
        """

        logging.info("duan add,task is:%s" % str(task))
        queue_name_or_none = self.task_queue_map.get(task)
        return queue_name_or_none
