import sys

from gm_rpcd.commands.utils import add_cwd_to_path
from gm_rpcd.internals.utils import serve


def main(args):
    add_cwd_to_path()

    from gm_rpcd.internals.configuration import config
    config.is_develop_mode = True
    config.freeze()

    host = '127.0.0.1'
    port = 9000
    try:
        first_arg = args[0]
    except IndexError:
        pass
    else:
        if ':' in first_arg:
            host, port = first_arg.split(':')
            port = int(port)
        else:
            port = int(first_arg)
    print('Serving on {}:{}'.format(host, port))
    serve(host=host, port=port)


if __name__ == '__main__':
    main(sys.argv[1:])
