# coding=utf-8

import os
# from log_settings import *
from datetime import timedelta
from celery.schedules import crontab

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))

# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/1.10/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = '^j3sg)sj8rc@du74%fb$c2926tv!!4g(kp-=rx1)c5!1&1(dq='

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = False

ALLOWED_HOSTS = []

# Application definition
SENTRY_CELERY_ENDPOINT = "http://45b0ef6a79204d6988b59c32c9dd4bef:fa018677fb4f49be88d2ba61cdc7ee32@sentry.igengmei.com/135"
BROKER_URL = "redis://:Gengmei123@172.21.52.16:6379/8"

# CELERY_SEND_EVENTS = True
# CELERY_SEND_TASK_SENT_EVENT = True
#
# CELERY_DEFAULT_EXCHANGE = 'celery'
# CELERY_DEFAULT_EXCHANGE_TYPE = 'direct'
# CELERY_DEFAULT_ROUTING_KEY = 'celery'
#
# CELERY_QUEUES = {
#     'celery': {
#         'exchange': CELERY_DEFAULT_EXCHANGE,
#         'routing_key': CELERY_DEFAULT_ROUTING_KEY,
#     },
#     'order': {
#         'exchange': 'order',
#         'routing_key': 'order',
#     },
# }

LOGIN_URL = "http://earth.gmapp.env/api/account/login_pwd"
AUTO_CLICK_URL = "http://earth.gmapp.env/api/v1/like"
AUTO_VOTE_URL = "http://earth.gmapp.env/api/v1/ballot"
AUTO_REPLY_URL = "http://earth.gmapp.env/api/v1/reply/create"
AUTO_FOLLOW_URL = "http://earth.gmapp.env/api/v1/follow"
AUTO_URGE_URL = "http://earth.gmapp.env/api/v1/user/urge"
SERVICE_NAME = "测试"
AUTO_INNER_REPLY_URL = "http://saturn.iyanzhi.com/api/v1/reply/create_for_inner"

CELERY_BROKER_URL = "redis://:Gengmei123@172.21.52.16:6379/8"
CELERY_TIMEZONE = 'Asia/Shanghai'
CELERY_ROUTES = ['physical.celery_task_router.CeleryTaskRouter']



INSTALLED_APPS = (
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'trans2es',
    'search',
    'injection.data_sync',
)

CELERYBEAT_SCHEDULE = {
    'sync_face_similar_data_to_redis': {
        'task': 'injection.data_sync.tasks.sync_face_similar_data_to_redis',
        'schedule': timedelta(seconds=120),
        'args': ()
    },
    'set_tag_count': {
        'task': 'injection.data_sync.tasks.get_tag_count',
        'schedule': timedelta(seconds=1),
        'args': ()
    },
}

"""
MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
]
TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]
AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]
"""

ROOT_URLCONF = 'physical.urls'

WSGI_APPLICATION = 'physical.wsgi.application'
DATABASE_ROUTERS = ['physical.DBRouter.DBRouter']

REDIS_URL = "redis://:Gengmei123@172.21.52.16:6379"
# Database
# https://docs.djangoproject.com/en/1.10/ref/settings/#databases


DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.mysql',
        'NAME': 'alpha',
        'USER': 'work',
        'PASSWORD': 'Gengmei123!',
        'HOST': '172.21.36.16',
        'PORT': '3306',
        'OPTIONS': {
            "init_command": "SET foreign_key_checks = 0;",
            "charset": "utf8mb4",
        },
    },
    'master': {
        'ENGINE': 'django.db.backends.mysql',
        'NAME': 'alpha',
        'USER': 'work',
        'PASSWORD': 'Gengmei123!',
        'HOST': '172.21.36.6',
        'PORT': '3306',
        'OPTIONS': {
            "init_command": "SET foreign_key_checks = 0;",
            "charset": "utf8mb4",
        },
    },
     'face': {
        'ENGINE': 'django.db.backends.mysql',
        'NAME': 'face',
        'USER': 'work',
        'PASSWORD': 'Gengmei123!',
        'HOST': '172.21.36.16',
        'PORT': '3306',
        # 'CONN_MAX_AGE': None,
        'OPTIONS': {
            "init_command": "SET foreign_key_checks = 0;",
            "charset": "utf8mb4",
        },
    },
    'commodity': {
        'ENGINE': 'django.db.backends.mysql',
        'NAME': 'commodity',
        'USER': 'work',
        'PASSWORD': 'Gengmei123!',
        'HOST': '172.21.36.16',
        'PORT': '3306',
        # 'CONN_MAX_AGE': None,
        'OPTIONS': {
            "init_command": "SET foreign_key_checks = 0;",
            "charset": "utf8mb4",
        },
    }

}

ES_INFO_LIST = [
    {
        "host": "172.21.40.14",
        "port": 9200
    }
]

TAG_ES_INFO_LIST = [
    {
        "host": "172.21.40.14",
        "port": 9200
    }
]

# KAFKA_BROKER_LIST = "192.168.13.114:9092,192.168.13.116:9092,192.168.13.115:9092"
# KAFKA_TOPIC_NAME = "alpha-maidian-data"
KAFKA_BROKER_LIST = "172.21.40.14:9092"
KAFKA_TOPIC_NAME = "gm-maidian-data"
KAFKA_GM_LOGGING_TOPIC_NAME = "gm-logging-test"
ES_INDEX_PREFIX = "gm-dbmw"
SLAVE_DB_NAME = 'default'
SLAVE1_DB_NAME = 'default'
MASTER_DB_NAME = 'master'

MIDDLEWARE_CLASSES = (
    'gm_tracer.middleware.TracerMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.auth.middleware.SessionAuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
    'helios.DjangoL5dMiddleware',
)
# Password validation
# https://docs.djangoproject.com/en/1.10/ref/settings/#auth-password-validators


# Internationalization
# https://docs.djangoproject.com/en/1.10/topics/i18n/

# LANGUAGE_CODE = 'en-us'
#
TIME_ZONE = 'Asia/Shanghai'
#
USE_I18N = True

USE_L10N = True
#
# USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/1.10/howto/static-files/

STATIC_URL = '/static/'

CACHE_SECONDS = 60 * 60 * 24 * 2
REDIS_HOST = '172.21.52.16'
REDIS_PW = 'Gengmei123'
REDIS_TOPIC = {
    'reply_cache': {'host': REDIS_HOST, 'port': 6379, 'db': 9, 'password': REDIS_PW},
    'follow_cache': {'host': REDIS_HOST, 'port': 6379, 'db': 10, 'password': REDIS_PW},
    'click_cache': {'host': REDIS_HOST, 'port': 6379, 'db': 11, 'password': REDIS_PW},
}