#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
import sys
import logging
import traceback
from libs.tools import tzlc

class CelebrityTransfer(object):

    @classmethod
    def get_celebrity_data(cls,instance):
        try:
            res = dict()

            res["id"] = instance.id
            res["is_online"] = instance.is_online
            res["is_deleted"] = instance.is_deleted
            res["portrait"] = instance.portrait
            res["name"] = instance.name
            res["description"] = instance.desc
            res["gender"] = instance.gender
            res["city_id"] = instance.city_id
            res["pick_id_list"] = instance.get_pick_id_list()

            create_time = instance.create_time
            tzlc_create_time = tzlc(create_time)
            res["create_time"] = tzlc_create_time

            update_time = instance.update_time
            tzlc_udpate_time = tzlc(update_time)
            res["update_time"] = tzlc_udpate_time

            return res
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return None