#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.conf import settings
from django.core.management.base import BaseCommand, CommandError
import traceback
import logging
from libs.es import ESPerform
from django.db import models
import datetime
from .pick_celebrity import PickCelebrity

class Celebrity(models.Model):
    class Meta:
        verbose_name = u'明星表'
        db_table = 'celebrity'

    id = models.IntegerField(verbose_name="主键ID",primary_key=True)
    is_deleted = models.BooleanField(verbose_name="是否删除")
    name = models.CharField(verbose_name=u'名称', max_length=300, default='')
    portrait = models.CharField(verbose_name=u'肖像', max_length=100, default='')
    gender = models.SmallIntegerField(verbose_name=u'性别')
    city_id = models.CharField(verbose_name=u'城市id', max_length=40)
    desc = models.IntegerField(verbose_name='')
    is_online = models.BooleanField(verbose_name="是否上线")
    create_time = models.DateTimeField(verbose_name=u'创建时间',default=datetime.datetime.fromtimestamp(0))
    update_time = models.DateTimeField(verbose_name=u'更新时间', default=datetime.datetime.fromtimestamp(0))


    def get_pick_id_list(self):
        try:
            pick_id_list = list()
            query_results = PickCelebrity.objects.filter(celebrity_id=self.id,is_deleted=False)
            for data_item in query_results:
                pick_id_list.append(data_item.pick_id)

            return list(tuple(pick_id_list))
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return []