#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, absolute_import, print_function
from gm_rpcd.all import bind
import logging
import traceback
import json
from search.utils.topic import TopicUtils
from libs.es import ESPerform
from libs.cache import redis_client
from search.utils.common import *
from libs.es import ESPerform


@bind("physical/search/business/topic")
def business_topic_search(filters, nfilters=None, sorts_by=None, offset=0, size=10):
    """帖子搜索。"""

    try:

        result_list = TopicUtils.business_topic_id(
            filters=filters, nfilters=nfilters, sorts_by=sorts_by,
            offset=offset, size=size, filter_online=False,
            index_name="topic"
        )

        topic_ids = [item["_source"]["id"] for item in result_list["hits"]]
        return {"topic_ids": topic_ids, "total_count": result_list["total_count"]}
    except:
        logging.error("catch exception, err_msg:%s" % traceback.format_exc())
        return {"topic_ids": [], "total_count": 0}
