#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
import sys
import logging
import traceback
from libs.tools import tzlc
from trans2es.models.topic import Topic
from trans2es.models.tag import TopicTag,CommunityTagType,CommunityTagTypeRelation
import datetime

class TagTransfer(object):

    @classmethod
    def get_tag_data(cls,instance):
        try:
            res = dict()

            res["id"] = instance.id
            res["suggest"] = instance.name
            res["name"] = instance.name
            res["is_online"] = instance.is_online
            res["is_deleted"] = instance.is_deleted

            res["near_new_topic_num"] = 0
            if instance.is_online==True and instance.is_deleted==False:
                topic_id_list = list()

                sql_result_list = TopicTag.objects.filter(tag_id=instance.id,is_online=True).values_list("topic_id",flat=True)
                for item_id in sql_result_list:
                    topic_id_list.append(item_id)

                time_base_val = datetime.datetime.strftime(datetime.datetime.now()+datetime.timedelta(-7), "%Y-%m-%d")
                topic_num = Topic.objects.filter(id__in=topic_id_list,is_online=True,is_deleted=False,create_time__gte=time_base_val).count()

                res["near_new_topic_num"] = topic_num

            res["tag_type"] = -1
            tag_type_id = CommunityTagTypeRelation.objects.filter(tag_id=instance.id,is_online=True,is_deleted=False).values_list("tag_type_id")
            if tag_type_id:
                res["tag_type"] = tag_type_id
                            
            return res
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return dict()