#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.conf import settings
from django.core.management.base import BaseCommand, CommandError
import traceback
import logging
from libs.es import ESPerform
from django.db import models
import datetime
from .user import User

class UserFollow(models.Model):
    class Meta:
        verbose_name = u'用户关注'
        verbose_name_plural = u'用户关注'
        db_table = 'user_follow'
        app_label = 'api'

    #user_id = models.IntegerField(verbose_name="用户ID")
    user = models.ForeignKey(User,related_name="userFollow",verbose_name="关注用户信息")
    follow_id = models.IntegerField(verbose_name="关注的用户ID")
    is_online = models.BooleanField(verbose_name="是否上线")
    is_deleted = models.BooleanField(verbose_name="是否删除")
    create_time = models.DateTimeField(verbose_name=u'日记创建时间',default=datetime.datetime.fromtimestamp(0))
    update_time = models.DateTimeField(verbose_name=u'日记更新时间', default=datetime.datetime.fromtimestamp(0))
